/*
 * Decompiled with CFR 0.152.
 */
package simtools.data;

import java.util.Collection;
import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.DataSourceListener;
import simtools.data.EndNotificationListener;
import simtools.data.UnsupportedOperation;
import simtools.data.ValueProvider;
import simtools.data.buffer.BufferedDataSource;
import simtools.util.ListenerManager;
import simtools.util.NumberStringComparator;

public abstract class DataSource
extends ValueProvider {
    protected ListenerManager listeners = new ListenerManager();
    protected ListenerManager endNotificationListeners = new ListenerManager();

    public Object getMin() throws UnsupportedOperation {
        throw new UnsupportedOperation();
    }

    public Object getMax() throws UnsupportedOperation {
        throw new UnsupportedOperation();
    }

    public byte getByteMin() throws DataException {
        Object object = this.getMin();
        if (object == null) {
            return 0;
        }
        if (object instanceof String) {
            object = NumberStringComparator.stringToNumber((String)object);
        }
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        return 0;
    }

    public byte getByteMax() throws DataException {
        Object object = this.getMax();
        if (object == null) {
            return 0;
        }
        if (object instanceof String) {
            object = NumberStringComparator.stringToNumber((String)object);
        }
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        return 0;
    }

    public short getShortMin() throws DataException {
        Object object = this.getMin();
        if (object == null) {
            return 0;
        }
        if (object instanceof String) {
            object = NumberStringComparator.stringToNumber((String)object);
        }
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).shortValue();
        }
        return 0;
    }

    public short getShortMax() throws DataException {
        Object object = this.getMax();
        if (object == null) {
            return 0;
        }
        if (object instanceof String) {
            object = NumberStringComparator.stringToNumber((String)object);
        }
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).shortValue();
        }
        return 0;
    }

    public int getIntegerMin() throws DataException {
        Object object = this.getMin();
        if (object == null) {
            return 0;
        }
        if (object instanceof String) {
            object = NumberStringComparator.stringToNumber((String)object);
        }
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return 0;
    }

    public int getIntegerMax() throws DataException {
        Object object = this.getMax();
        if (object == null) {
            return 0;
        }
        if (object instanceof String) {
            object = NumberStringComparator.stringToNumber((String)object);
        }
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return 0;
    }

    public long getLongMin() throws DataException {
        Object object = this.getMin();
        if (object == null) {
            return 0L;
        }
        if (object instanceof String) {
            object = NumberStringComparator.stringToNumber((String)object);
        }
        if (object == null) {
            return 0L;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        return 0L;
    }

    public long getLongMax() throws DataException {
        Object object = this.getMax();
        if (object == null) {
            return 0L;
        }
        if (object instanceof String) {
            object = NumberStringComparator.stringToNumber((String)object);
        }
        if (object == null) {
            return 0L;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        return 0L;
    }

    public float getFloatMin() throws DataException {
        Object object = this.getMin();
        if (object == null) {
            return 0.0f;
        }
        if (object instanceof String) {
            object = NumberStringComparator.stringToNumber((String)object);
        }
        if (object == null) {
            return 0.0f;
        }
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        return 0.0f;
    }

    public float getFloatMax() throws DataException {
        Object object = this.getMax();
        if (object == null) {
            return 0.0f;
        }
        if (object instanceof String) {
            object = NumberStringComparator.stringToNumber((String)object);
        }
        if (object == null) {
            return 0.0f;
        }
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        return 0.0f;
    }

    public double getDoubleMin() throws DataException {
        Object object = this.getMin();
        if (object == null) {
            return 0.0;
        }
        if (object instanceof String) {
            object = NumberStringComparator.stringToNumber((String)object);
        }
        if (object == null) {
            return 0.0;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return 0.0;
    }

    public double getDoubleMax() throws DataException {
        Object object = this.getMax();
        if (object == null) {
            return 0.0;
        }
        if (object instanceof String) {
            object = NumberStringComparator.stringToNumber((String)object);
        }
        if (object == null) {
            return 0.0;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return 0.0;
    }

    public long getStartIndex() throws UnsupportedOperation {
        throw new UnsupportedOperation();
    }

    public long getLastIndex() throws UnsupportedOperation {
        throw new UnsupportedOperation();
    }

    public Object computeMin() throws UnsupportedOperation {
        throw new UnsupportedOperation();
    }

    public Object computeMax() throws UnsupportedOperation {
        throw new UnsupportedOperation();
    }

    public long computeStartIndex() throws UnsupportedOperation {
        throw new UnsupportedOperation();
    }

    public long computeLastIndex() throws UnsupportedOperation {
        throw new UnsupportedOperation();
    }

    public void setSlice(long l, long l2) {
    }

    public boolean isComparable() {
        return false;
    }

    public int sortedOrder() {
        return 0;
    }

    public DataInfo getInformation() {
        return null;
    }

    public DataSource[] getSourceDependencies() {
        return null;
    }

    public void addListener(DataSourceListener dataSourceListener) {
        this.listeners.add(dataSourceListener);
    }

    public void removeListener(DataSourceListener dataSourceListener) {
        this.listeners.remove(dataSourceListener);
    }

    public void addEndNotificationListener(EndNotificationListener endNotificationListener) {
        this.endNotificationListeners.add(endNotificationListener);
    }

    public void removeEndNotificationListener(EndNotificationListener endNotificationListener) {
        this.endNotificationListeners.remove(endNotificationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListenersForValueChange(long l, long l2) {
        ListenerManager listenerManager = this.listeners;
        synchronized (listenerManager) {
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                DataSourceListener dataSourceListener = (DataSourceListener)this.listeners.get(i);
                if (dataSourceListener == null) continue;
                dataSourceListener.DataSourceValueChanged(this, l, l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListenersForIndexRangeChange(long l, long l2) {
        ListenerManager listenerManager = this.listeners;
        synchronized (listenerManager) {
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                DataSourceListener dataSourceListener = (DataSourceListener)this.listeners.get(i);
                if (dataSourceListener == null) continue;
                dataSourceListener.DataSourceIndexRangeChanged(this, l, l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListenersForInfoChange(DataInfo dataInfo) {
        ListenerManager listenerManager = this.listeners;
        synchronized (listenerManager) {
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                DataSourceListener dataSourceListener = (DataSourceListener)this.listeners.get(i);
                if (dataSourceListener == null) continue;
                dataSourceListener.DataSourceInfoChanged(this, dataInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListenersForValueRangeChange() {
        ListenerManager listenerManager = this.listeners;
        synchronized (listenerManager) {
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                DataSourceListener dataSourceListener = (DataSourceListener)this.listeners.get(i);
                if (dataSourceListener == null) continue;
                dataSourceListener.DataSourceValueRangeChanged(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListenersForOrderChange(int n) {
        ListenerManager listenerManager = this.listeners;
        synchronized (listenerManager) {
            int n2 = this.listeners.size();
            for (int i = 0; i < n2; ++i) {
                DataSourceListener dataSourceListener = (DataSourceListener)this.listeners.get(i);
                if (dataSourceListener == null) continue;
                dataSourceListener.DataSourceOrderChanged(this, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEndNotificationListeners() {
        ListenerManager listenerManager = this.endNotificationListeners;
        synchronized (listenerManager) {
            int n = this.endNotificationListeners.size();
            for (int i = 0; i < n; ++i) {
                EndNotificationListener endNotificationListener = (EndNotificationListener)this.endNotificationListeners.get(i);
                if (endNotificationListener == null) continue;
                endNotificationListener.notificationEnd(this);
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof DataSource)) {
            return false;
        }
        if (object instanceof BufferedDataSource) {
            return this.equals(((BufferedDataSource)object).dataSource);
        }
        return super.equals(object);
    }

    public boolean isCompound() {
        return false;
    }

    public Collection getAuxiliarySources() {
        return null;
    }
}

