/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import jsynoptic.builtin.Abstract2DShape;
import jsynoptic.builtin.ui.RectanglePropertiesPanel;
import simtools.data.DataException;
import simtools.data.DataSource;
import simtools.data.DataSourcePool;
import simtools.data.UnsupportedOperation;
import simtools.shapes.AbstractShape;
import simtools.ui.JPropertiesPanel;

public class RectangleShape
extends Abstract2DShape {
    protected transient Rectangle2D.Double rec;
    protected transient Rectangle2D.Double fillrec;
    protected double min;
    protected double max;
    protected transient DataSource progressSource;
    protected transient long progressSourceIndex;
    protected transient double progressValue;
    protected transient boolean dirtyProgress = false;

    public RectangleShape(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.ratio = (double)this._w / (double)this._h;
        this.allowResize = true;
        this.fixedRatio = false;
        this.rec = new Rectangle2D.Double(n, n2 - this._h, n3 - 1, n4 - 1);
        this.fillrec = new Rectangle2D.Double();
        this.min = 0.0;
        this.max = 1.0;
        this.progressValue = 0.0;
    }

    protected Shape getDelegateShape() {
        return this.rec;
    }

    public void translate(int n, int n2) {
        super.translate(n, n2);
        this.rec.x += (double)n;
        this.rec.y += (double)n2;
    }

    public void setAnchor(int n, int n2) {
        super.setAnchor(n, n2);
        this.rec.x = n;
        this.rec.y = n2 - this._h;
    }

    public void resize(int n, int n2) {
        super.resize(n, n2);
        this.rec.x = this._ox;
        this.rec.y = this._oy - this._h;
        this.rec.height = this._h - 1;
        this.rec.width = this._w - 1;
    }

    protected void fillHook(Graphics2D graphics2D) {
        if (this.progressSource == null) {
            super.fillHook(graphics2D);
        } else {
            Color color;
            Color color2 = color = this.fillDynamicColor != null ? this.fillDynamicColor : this.fillColor;
            if (color != null) {
                graphics2D.setColor(color);
                if (this._h < this._w) {
                    this.fillrec.y = this.rec.y;
                    this.fillrec.height = this.rec.height;
                    if (this.max > this.min) {
                        this.fillrec.width = this.computeLength(this.rec.width);
                        this.fillrec.x = this.rec.x;
                    } else {
                        this.fillrec.width = this.computeLength(this.rec.width);
                        this.fillrec.x = this.rec.x + this.rec.width - this.fillrec.width;
                    }
                } else {
                    this.fillrec.x = this.rec.x;
                    this.fillrec.width = this.rec.width;
                    if (this.max > this.min) {
                        this.fillrec.height = this.computeLength(this.rec.height);
                        this.fillrec.y = this.rec.y;
                    } else {
                        this.fillrec.height = this.computeLength(this.rec.height);
                        this.fillrec.y = this.rec.y + this.rec.height - this.fillrec.height;
                    }
                }
                graphics2D.fill(this.fillrec);
            }
        }
    }

    protected double computeLength(double d) {
        double d2 = d;
        if (this.max > this.min) {
            d2 = (this.progressValue - this.min) / (this.max - this.min) * d2;
        } else if (this.max < this.min) {
            d2 = (this.progressValue - this.max) / (this.min - this.max) * d2;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d2 > d) {
            d2 = d;
        }
        return d2;
    }

    public JPropertiesPanel createPanel() {
        return new RectanglePropertiesPanel();
    }

    protected boolean updateProgress() {
        double d;
        if (this.progressSource != null) {
            try {
                d = this.progressSource.getDoubleValue(this.progressSourceIndex);
            }
            catch (DataException dataException) {
                d = this.progressValue;
            }
        } else {
            d = this.progressValue;
        }
        boolean bl = d != this.progressValue;
        this.progressValue = d;
        return bl;
    }

    public void notificationEnd(Object object) {
        if (this.dirtyProgress) {
            this.dirty |= this.updateProgress();
            this.dirtyProgress = false;
        }
        super.notificationEnd(object);
    }

    public void DataSourceValueChanged(DataSource dataSource, long l, long l2) {
        if (dataSource.equals(this.progressSource) && this.progressSourceIndex >= l && this.progressSourceIndex <= l2) {
            this.dirtyProgress = true;
        }
        super.DataSourceValueChanged(dataSource, l, l2);
    }

    public void DataSourceIndexRangeChanged(DataSource dataSource, long l, long l2) {
        if (dataSource.equals(this.progressSource)) {
            this.progressSourceIndex = l2;
            this.dirtyProgress = true;
        }
        super.DataSourceIndexRangeChanged(dataSource, l, l2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        DataSourcePool.global.writeDataSource(objectOutputStream, this.progressSource);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.rec = new Rectangle2D.Double(this._ox, this._oy - this._h, this._w - 1, this._h - 1);
        this.fillrec = new Rectangle2D.Double();
        this.progressSource = DataSourcePool.global.readDataSource(objectInputStream);
        if (this.progressSource != null) {
            try {
                this.progressSource.addListener(this);
                this.progressSource.addEndNotificationListener(this);
                this.progressSourceIndex = this.progressSource.getLastIndex();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.progressSourceIndex = 0L;
            }
        }
    }

    protected AbstractShape cloneShape() {
        RectangleShape rectangleShape = (RectangleShape)super.cloneShape();
        rectangleShape.rec = (Rectangle2D.Double)this.rec.clone();
        rectangleShape.fillrec = (Rectangle2D.Double)this.fillrec.clone();
        if (rectangleShape.progressSource != null) {
            rectangleShape.progressSource.addEndNotificationListener(rectangleShape);
            rectangleShape.progressSource.addListener(rectangleShape);
        }
        return rectangleShape;
    }

    public void setPropertyValue(String string, Object object) {
        super.setPropertyValue(string, object);
        if (string.equalsIgnoreCase("PROGRESS_MIN")) {
            if (object instanceof Double) {
                this.min = (Double)object;
            }
        } else if (string.equalsIgnoreCase("PROGRESS_MAX")) {
            if (object instanceof Double) {
                this.max = (Double)object;
            }
        } else if (string.equalsIgnoreCase("PROGRESS_SOURCE")) {
            if (this.progressSource != null) {
                this.progressSource.removeListener(this);
                this.progressSource.removeEndNotificationListener(this);
                this.progressSource = null;
            }
            if (object instanceof DataSource) {
                this.progressSource = (DataSource)object;
                try {
                    this.progressSourceIndex = this.progressSource.getLastIndex();
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    this.progressSourceIndex = 0L;
                }
                try {
                    this.progressValue = this.progressSource.getDoubleValue(this.progressSourceIndex);
                }
                catch (DataException dataException) {
                    // empty catch block
                }
                this.progressSource.addListener(this);
                this.progressSource.addEndNotificationListener(this);
            }
        }
    }

    public Object getPropertyValue(String string) {
        Object object = super.getPropertyValue(string);
        if (string.equalsIgnoreCase("PROGRESS_MIN")) {
            object = new Double(this.min);
        } else if (string.equalsIgnoreCase("PROGRESS_MAX")) {
            object = new Double(this.max);
        } else if (string.equalsIgnoreCase("PROGRESS_SOURCE")) {
            object = this.progressSource;
        }
        return object;
    }
}

