--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

with trace;
use trace;

package body listes is

  ----------------------------------------
  -- Gere les commentaires de debuggage --
  profMax : integer := 1;
  procedure tracer(prof : positive ; chaine : string) is
  begin
    if prof <= profMax then
      tracerDebug(prof, chaine);
    end if;
  end tracer;
  ----------------------------------------

  --------------------------- Liste chainee classique --------------
  
  procedure ajouteTete(o : objet ; l : in out liste) is
  begin
    l := new st_liste'(o, l);
  end ajouteTete;

  procedure ajouteQueue(o : objet ; l : in out liste) is
  begin
    if estVide(l) then
      l := new st_liste'(o, Nil);
    else
      queue(l).suiv := new st_liste'(
        cell => o,
        suiv => listeVide
      );
    end if;
  end ajouteQueue;
  
  function queue(l : liste) return liste is
  begin
    if estVide(suite(l)) then
      return l;
    else
      return queue(suite(l));
    end if;
  end queue;

  function tete(l : liste) return objet is
  begin
    return l.cell;
  end tete;

  function suite(l : liste) return liste is
  begin
    return l.suiv;
  end suite;

  function suiteDestructive(l : liste) return liste is
    t : liste := l;
    s : liste := suite(l);
  begin
    supprime(t);
    return s;
  end suiteDestructive;

  function listeVide return liste is
  begin
    return Nil;
  end listeVide;

  function estVide(l : liste) return boolean is
  begin
    return (l = Nil);
  end estVide;

  ---------------------------- Liste chainee dont le dernier element est accessible en temps O(1) ---------

  procedure ajouteTete(o : objet ; l : in out dliste) is
  begin
    ajouteTete(o, l.premier);
    if estVide(suite(l)) then -- La liste etait vide
      l.dernier := l.premier;
    end if;
  end ajouteTete;
  -- Ajout d'un element en queue
  procedure ajouteQueue(o : objet ; l : in out dliste) is
  begin
    if estVide(l) then
      ajouteTete(o, l);
    else
      l.dernier.suiv := new st_liste'(
        cell => o,
        suiv => listeVide
      );
      l.dernier := suite(l.dernier);
    end if;
  end ajouteQueue;
    
  -- Renvoie le premier element de la liste
  function tete(l : dliste) return objet is
  begin
    return tete(l.premier);
  end tete;
  -- Renvoie la suite de la liste (sans le premier element)
  function suite(l : dliste) return dliste is
    ll : dliste := l;
  begin
    if estVide(suite(ll.premier)) then -- La liste n'a qu'un element
      ll.premier := listeVide;
      ll.dernier := listeVide;
    else
      ll.premier := suite(ll.premier);
    end if;
    return ll;
  end suite;
  -- Renvoie la suite de la liste (sans le premier element), et detruit le premier element
  function suiteDestructive(l : dliste) return dliste is
    ll : dliste := l;
    t : liste := l.premier;
    s : liste := suite(l.premier);
  begin
    ll.premier := s;
    supprime(t);
    return ll;
  end;
  

  -- Renvoie le dernier element de la liste
  function queue(l : dliste) return dliste is
  begin
    return dliste'(premier => l.dernier, dernier => l.dernier);
  end queue;

  -- Renvoie une liste vide
  function listeVide return dliste is
  begin
    return dliste'(premier => listeVide, dernier => listeVide);
  end listeVide;

  -- Renvoie 'true' ssi la liste est vide
  function estVide(l : dliste) return boolean is
  begin
    return estVide(l.premier);
  end estVide;

end listes;
