--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

with erreurs, options, arguments, texte, trace, generation, coherence;
use erreurs, options, arguments, texte, trace, generation, coherence;

package body plan is

  ----------------------------------------
  -- Gere les commentaires de debuggage --
  profMax : integer := 1;
  procedure tracer(prof : positive ; chaine : string) is
  begin
    if prof <= profMax then
      tracerDebug(prof, chaine);
    end if;
  end tracer;
  ----------------------------------------


	function etapeSuivante return boolean is
	begin
		etape_courante := etape'Succ(etape_courante);
		case etape_courante is
			when initialisation => lanceInitialisation;
			when analyse => lanceAnalyse;
			when metaInformations => return lanceMeta; -- Si qq chose est affiche, on s'arrete.
      when coherence => lanceCoherence;
      when generation => lanceGeneration;
      when fin => return true;
		end case;
    return false;
	end etapeSuivante;

	procedure lanceInitialisation is
	begin
		progressionInit;
		initoptions;
	end lanceInitialisation;

	procedure lanceAnalyse is
	begin
		progressionAnalyse;
		analyseArguments;
    defautOptions;
	end lanceAnalyse;

	function lanceMeta return boolean is
	begin
		progressionMeta;
		if (afficheAide) then
			metaAide;
		elsif (afficheVersion) then
			metaVersion;
		elsif (afficheDiacritiques) then
			metaDiacritiques;
		else
			return false;
		end if;
		return  true;
	end lanceMeta;

  procedure lanceCoherence is
  begin
    progressionCoherence;
    if (not estCoherent) then
      txtErreurCoherence;
      raise erreurCoherence;
    end if;
  end lanceCoherence;

  procedure lanceGeneration is
  begin
    progressionGeneration;
    generationDocument;
  end;

end plan ;
