--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

----------------------------------------------
--
-- Gestion des erreurs : definition des erreur, et renvoie du code de retour approprie
--
-- L'affichage du texte correspondant aux erreurs n'est pas fait ici car :
--   il depend parfois du contexte (et en rattrapant l'exception ici, le contexte serait perdu)
--   il est fait dans le paquetage 'texte' pour y regrouper tous les textes
--
-----------------------------------------------

package erreurs is

  -- Erreur qui, si elle est levee, temoigne d'un bug dans le programme
  erreurImpossible : exception;

	-- Erreur lexicale ou syntaxique dans les argument entres par l'utilisateur
	erreurArg : exception;

  -- Erreur lors de la creation de la structure du fichier LaTeX
  erreurCreation : exception;

	-- Option inconnue
	erreurOptionInconnue : exception;

	-- Numero de section invalide (par exemple argument "--album9=")
	erreurNumeroSectionInvalide : exception;

	-- Erreur syntaxique "generale"
	erreurSyntaxique : exception;

	-- Erreur lors de l'ouverture d'un fichier
	erreurOuvertureFichier : exception;

  -- Erreur lors de l'analyse de l'album
  erreurAlbum : exception;

  -- Erreur lors de l'analyse d'une liste de fichiers
  erreurlisteFichiers : exception;

  -- Erreur de coherence des options
  erreurCoherence : exception;

  -- Erreur dans la chaine definissant la dimension des photos
  erreurTaille : exception;

  -- L'unite demandee n'existe pas
  erreurUnite : exception;


	-- Renvoie un code de sortie signifiant l'erreur
	-- Le texte d'explication de l'erreur devra avoir ete affiche avant
	procedure raiseErreur;

end erreurs ;
