--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

----------------------------------------------------------------
--
-- Gere les entrees-sorties, ainsi que l'ouverture des fichiers
--
---------------------------------------------------------------
with Ada.Text_IO;
use Ada.Text_IO;

package fichier is

	-- Ouvre le fichier 'nom' en lecture
	-- Peut lever une erreur si l'ouverture s'avere impossible
  procedure ouvrirLecture(nom : string ; f : out File_Type);

  -- Cree le fichier 'f'
  -- Si 'nom'="" alors l'ecriture se fera dans la sortie standard : 'stdOut' est vrai
  -- sinon,  dans le fichier 'f'
  procedure creer(nom : string ; stdOut : out boolean ; f : out File_Type);

  -- Ferme le fichier 'f'
  procedure fermer(f : in out File_Type);

  private

  -- Ne constitue qu'un appel a la finction 'open', mais gere les exceptions
  -- Cette function n'est utile que pour analyser les erreurs : si elle se termine correctement, c'est que le fichier a ete ouvert sans erreurs.
  procedure ouvrir(nom : string ; f : out File_Type ; mode : File_Mode);

end fichier;
