--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

with accent, html, erreurs, trace;
use accent, html, erreurs, trace;

package body diacritiques is

  ----------------------------------------
  -- Gere les commentaires de debuggage --
  profMax : integer := 1;
  procedure tracer(prof : positive ; chaine : string) is
  begin
    if prof <= profMax then
      tracerDebug(prof, chaine);
    end if;
  end tracer;
  ----------------------------------------

  function versLatex(chaine : unbounded_string) return string is
  begin
    return versLatex(to_string(chaine));
  end versLatex;
  function versLatex(chaine : string) return string is
  begin
    indiceCourant := 0;
    chaineAnalysee := to_unbounded_string(chaine);
    carSuivant;
    return axiome;
  end versLatex;

  -- Analyse de la grammaire LL1 decrite dans le fichier "doc/grammaire/diacritiques.txt"

  -- Passe au caractere suivant
  procedure carSuivant is
  begin
    indiceCourant := indiceCourant + 1;
    if (indiceCourant > to_string(chaineAnalysee)'length) then
      courant := finDeLigne;
    else
      caractere := to_string(chaineAnalysee)(indiceCourant);
      if (caractere = '-') then
        courant := tiret;
      elsif (caractere = '_') then
        courant := tiretBas;
      elsif protege(caractere) then
        courant := protege;
      elsif accent(caractere) then
        courant := accent;
      elsif alphaNum(caractere) then
        courant := alphaNum;
      end if;
    end if;
  end carSuivant;

  -- Regles de la grammaire
  function axiome return string is
    prec : character := caractere;
    debut : unbounded_string;
  begin
    if (courant = alphaNum) then
      carSuivant;
      return prec & axiome;
    elsif (courant = protege) then
      carSuivant;
      return '\' & prec & axiome;
    elsif (courant = accent) then
      carSuivant;
      return accentVersLatex(prec) & axiome;
    elsif (courant = tiretBas) then
      carSuivant;
      return " " & axiome;
    elsif (courant = tiret) then
      carSuivant;
      debut := to_unbounded_string(htmlVersLatex("-" & entreTirets));
      return  to_string(debut & axiome);
    elsif (courant = finDeLigne) then
      return "";
    end if;
    raise erreurImpossible;
  end;

  function entreTirets return string is
    prec : character := caractere;
  begin
    if (courant = alphaNum) then
      carSuivant;
      return prec & entreTirets;
    elsif (courant = tiret) then
      carSuivant;
      return "-";
    elsif (courant = protege or courant = tiretBas or courant = accent or courant = finDeLigne) then
      return "";
    end if;
    raise erreurImpossible;
  end;


  -- Renvoie vrai ssi le caractere est un caractere protege en LaTeX
  function protege(car : character) return boolean is
  begin
    -- Liste a complete. Je n'avais pas internet sous la main pour chercher la liste exhaustive lorsque j'ai ecrit cette partie.
    return
      car = '\' or
      car = '&'
    ;
  end;

  -- Renvoie vrai ssi le caractere est un caractere alphanumerique
  function alphanum(car : character) return boolean is
  begin
    return (car in 'a'..'z') or (car in 'A'..'Z') or (car in '0'..'9') or (car = ' ') or (car = ''');
  end;

  -- Renvoie vrai ssi le caractere est un caractere avec accent
  function accent(car : character) return boolean is
  begin
    return not (protege(car) or alphanum(car) or car='-');
  end;

end diacritiques ;
