--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

with fichier, trace, taillecourante;
use fichier, trace, taillecourante;

package body generation is

  ----------------------------------------
  -- Gere les commentaires de debuggage --
  profMax : integer := 1;
  procedure tracer(prof : positive ; chaine : string) is
  begin
    if prof <= profMax then
      tracerDebug(prof, chaine);
    end if;
  end tracer;
  ----------------------------------------


  procedure generationDocument is
  begin
    creer(getNomSortie, stdOut, f);

    entete;
    preambule;
    begin_document;
    corps;
    end_document;

    fermer(f);
  end generationDocument;

  -- Ecrit la chaine dans le fichier.
  procedure ecrire(chaine : string) is
  begin
    if stdOut then
      put(Standard_Output, chaine);
    else
      put(f, chaine);
    end if;
  end ecrire;

  -- Idem en sautant une ligne apres
  procedure ecrire_rl(chaine : string) is
  begin
    if stdOut then
      put_line(Standard_Output, chaine);
    else
      put_line(f, chaine);
    end if;
  end ecrire_rl;
  procedure ecrire_rl is
  begin
    if stdOut then
      put_line(Standard_Output, "");
    else
      put_line(f, "");
    end if;
  end ecrire_rl;

  --Ecrit l'en-tete (la ligne "\documentclass{...}")
  procedure entete is
  begin
    ecrire_rl("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
    ecrire_rl("%");
    ecrire_rl("% Ce fichier a ete genere en utilisant le logiciel 'trombi'.");
    ecrire_rl("%");
    ecrire_rl("% Ce logiciel est distribue sous licence GPL3 ou superieure.");
    ecrire_rl("% Vous pouvez le telecharger librement et gratuitement sur le site: //Mettre ici l'adresse du site quand il y en aura une//");
    ecrire_rl("%");
    ecrire_rl("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
    ecrire_rl("");
    if (niveauMin < 3) then
      ecrire_rl("\documentclass{report}");
    else
      ecrire_rl("\documentclass{article}");
    end if;
  end entete;

  --Ecrit le preambule du fichier
  procedure preambule is
  begin
    ecrire_rl("\usepackage{graphicx}");
    if afficheTitre then
      ecrire_rl("\title{" & getTitre & "}");
      ecrire_rl("\date{}");
      ecrire_rl("% \author{Cr\'e\'e avec le logiciel libre ``trombi''.\\\emph{Mettre ici l'adresse du site quand il en aura une\ldots}}");
  end if;
  end preambule;

  --Ecrit la ligne "\begin{document}
  -- et eventuellement "maketitle"
  procedure begin_document is
  begin
    ecrire_rl("\begin{document}");
    if afficheTitre then
      ecrire_rl("\maketitle");
    end if;
  end begin_document;

  -- Ecrit le corps du fichier
  procedure corps is
  begin
    while not fini loop
      if estPhoto then
        photo(photoLegende, photoChemin);
      end if;
      if estTitre then
        titre(titreTexte, titreNiveau);
      end if;
      if estTaille then
        setTailleCourante(tailleHori, tailleVert);
      end if;
      suivant;
    end loop;
  end corps;

  -- Ecrit la derniere ligne du fichier
  procedure end_document is
  begin
    ecrire_rl("\end{document}");
  end end_document;

  procedure photo(legende, chemin : string) is
  begin
    if getNombre = 0 then
    -- Nous ne nous soucions pas du nombre de photos par page
      ecrire_rl("\begin{tabular}{c}");
      ecrire_rl("\includegraphics" & getTailleCourante & "{" & chemin & "}\\");
      ecrire_rl(legende);
      ecrire_rl("\end{tabular}");
    else
    -- Attention au nombre de photos par page
      null;
    end if;
  end photo;

  procedure titre(texte : string ; niveau : niveauDeTitre) is
  begin
    if getNombre /= 0 then
    -- Attention au nombre de photos par page, il faut peut-etre fermer un tableau avant de finir
      null;
    end if;
    case niveau is
      when part => ecrire_rl("\part{" & texte & "}");
      when chapter => ecrire_rl("\chapter{" & texte & "}");
      when section => ecrire_rl("\section{" & texte & "}");
      when subsection => ecrire_rl("\subsection{" & texte & "}");
      when subsubsection => ecrire_rl("\subsubsection{" & texte & "}");
      when paragraph => ecrire_rl("\paragraph{" & texte & "}");
      when subparagraph => ecrire_rl("\subparagraph{" & texte & "}");
    end case;
  end titre;
end generation ;
