----------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
----------------------------------------------------------------------

----------------------------------------------------------------------
--
-- Ce paquetage realise l'analyse de la chaine decrivant la taille des photos.
-- C'est l'analyse d'une grammaire LL(1).
--
-- Ladite grammaire se trouve dans le fichier doc/grammaire/taille.txt
--
----------------------------------------------------------------------

with Ada.strings.unbounded;
use Ada.strings.unbounded;

package taille is

  procedure analyseTaille(chaine : string ; horizontal, vertical : out unbounded_string );

private

  -- Regles de la grammaire
  procedure axiome(largeur, hauteur : out unbounded_string);
  procedure auto;
  procedure croix;
  function verticalOptionnel return string;
  function vertical return string;
  function horizontal return string;
  function unite return string;
  function lettre return character;
  function nombre return string;
  function suitenombre return string;
  function entier return string;
  function entierSuite return string;
  procedure point;
  function chiffre return string;

  -- Chaine a analyser
  chaineAnalysee : unbounded_string;
  -- Indice du Caractere courant
  indiceCourant : integer;
  -- Type token
  type token is (
    chiffre, -- 0 1 2 3 4 5 6 7 8 9
    point, -- .
    minuscule, -- a b c d...
    croix, -- X (simplement un "x" majuscule)
    finDeLigne
  );
  -- Caractere courant
  courant : token;
  caractereCourant : character;
  -- Passe au caractere suivant
  procedure carSuivant;

  -- Renvoie true ssi la chaine est une unite de mesure LaTeX valide
  function est_unite(chaine : string) return boolean;

end taille;

