--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

with Ada.strings.unbounded;
use Ada.strings.unbounded;

with trace, erreurs, texte;
use trace, erreurs, texte;

package body listeFichiers is


  ----------------------------------------
  -- Gere les commentaires de debuggage --
  profMax : integer := 1;
  procedure tracer(prof : positive ; chaine : string) is
  begin
    if prof <= profMax then
      tracerDebug(prof, chaine);
    end if;
  end tracer;
  ----------------------------------------

  -- Utile uniquement au debuggage
  procedure afficheEtat(n : integer) is
  begin
    tracer(n, "typ " & fichier'image(typ)); 
    tracer(n, "liste " & to_string(liste)); 
    tracer(n, "carac " & token'image(carac)); 
    tracer(n, "carLu " & carLu); 
    tracer(n, "indice " & integer'image(indice)); 
  end afficheEtat;

	-- Cette procedure est executee lorsqu'un mot a ete trouve
	-- Ce mot peut eventuellement etre vide ; dans ce cas il est ignore
	procedure motTrouve(m : string) is
    etatCourant_typ : fichier;
    etatCourant_liste : unbounded_string;
    etatCourant_carac : token;
    etatCourant_carLu : character;
    etatCourant_indice : integer;
	begin
  	if (m = "") then
			return;
    end if;
    -- Empile les variables globales du paquetage, pour que la fonction principale puisse etre appelee recursivement
    etatCourant_typ := typ;
    etatCourant_liste := liste;
    etatCourant_carac := carac;
    etatCourant_carLu := carLu;
    etatCourant_indice := indice;

    fichierTrouve(typ, m);

    -- Depile les variables globlales du paquetage
    typ := etatCourant_typ;
    liste := etatCourant_liste;
    carac := etatCourant_carac;
    carLu := etatCourant_carLu;
    indice := etatCourant_indice;
	end motTrouve;

  procedure carSuivant is
  begin
    if (to_string(liste)'length = indice) then
      carac := FinDeLigne;
    else
      carLu := to_string(liste)(to_string(liste)'First + indice);
      indice := indice + 1;
      case carLu is
        when '"' => carac := Guillemet;
        when ''' => carac := Apostrophe;
        when '\' => carac := Antislash;
        when ' ' => carac := Espace;
        when others => carac := Normal;
      end case;
    end if;
  end carSuivant;

  procedure M(mot : string) is
    res : unbounded_string;
    car : character;
  begin
    tracer(7, "Entree dans M ; caractere lu : '" & carLu & "'.");
    case carac is
      when Guillemet =>
        carSuivant;
        G(res);
        if (carac /= Guillemet) then
          raise erreurlisteFichiers;
        end if;
        carSuivant;
        M(mot & to_string(res));
      when Apostrophe =>
        carSuivant;
        A(res);
        if (carac /= Apostrophe) then
          raise erreurlisteFichiers;
        end if;
        carSuivant;
        M(mot & to_string(res));
      when Antislash =>
        carSuivant;
        C(res);
        M(mot & to_string(res));
      when Espace =>
        carSuivant;
        motTrouve(mot);
        M("");
      when FinDeLigne =>
        motTrouve(mot);
      when Normal =>
        L(car);
        M(mot & car);
      when others =>
        raise erreurlisteFichiers;
    end case;
  end M;

  procedure G(mot : out unbounded_string) is
    res, res2 : unbounded_string;
    car : character;
  begin
    tracer(7, "Entree dans G ; caractere lu : '" & carLu & "'.");
    case carac is
      when Apostrophe => 
        carSuivant;
        G(res);
        mot := to_unbounded_string("'") & res;
      when Antislash =>
        carSuivant;
        C(res);
        G(res2);
        mot := res & res2;
      when Espace =>
        carSuivant;
        G(res);
        mot := to_unbounded_string(" ") & res;
      when Guillemet =>
        mot := to_unbounded_string("");
      when Normal =>
        L(car);
        G(res);
        mot := car & res;
      when others =>
        raise erreurlisteFichiers;
    end case;
  end G;

  procedure A(mot : out unbounded_string) is
    res : unbounded_string;
    car : character;
  begin
    tracer(7, "Entree dans A ; caractere lu : '" & carLu & "'.");
    case carac is
      when Guillemet =>
        carSuivant;
        A(res);
        mot := '"' & res;
      when Apostrophe =>
        mot := to_unbounded_string("");
      when Antislash =>
        carSuivant;
        A(res);
        mot := to_unbounded_string("\") & res;
      when Espace =>
        carSuivant;
        A(res);
        mot := to_unbounded_string(" ") & res;
      when Normal =>
        L(car);
        A(res);
        mot := car & res;
      when others =>
        raise erreurlisteFichiers;
    end case;
  end A;

  procedure C(car : out unbounded_string) is
  begin
    tracer(7, "Entree dans C ; caractere lu : '" & carLu & "'.");
    case carac is
      when Guillemet =>
        car := to_unbounded_String("" & carLu);
      when Apostrophe =>
        car := to_unbounded_String("" & carLu);
      when Antislash =>
        car := to_unbounded_String("" & carLu);
      when Espace =>
        car := to_unbounded_String("" & carLu);
      when Normal =>
        car := to_unbounded_String("" & carLu);
      when FinDeLigne =>
        car := to_unbounded_String("");
      when others =>
        raise erreurlisteFichiers;
    end case;
    carSuivant;
  end C;

  procedure L(car : out character) is
  begin
    tracer(7, "Entree dans L ; caractere lu : '" & carLu & "'.");
    case carac is
      when Normal =>
        car := carLu;
      when others =>
        raise erreurlisteFichiers;
    end case;
    carSuivant;
  end L;

  procedure analyselisteFichiers(l : string ; t : fichier) is
	begin
    -- Initialisation des variables
    typ := t;
    carac := normal;
    indice := 0;
    liste := to_unbounded_string(l);
    carSuivant;
    -- C'est parti pour l'analyse
    M("");
	exception
    when erreurlisteFichiers =>
      txtErreurlisteFichiers(carLu);
      raise erreurArg;
	end analyselisteFichiers;

end listeFichiers;
