--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

------------------------------------------------------------------
-- Ce paquetage realise l'analyse de la ligne de commande.
-----------------------------------------------------------------

with lexical, structure;
use lexical, structure;

package arguments is

	-- Analyse des arguments
	procedure analyseArguments;

private

  -- Analyse LL1 de la grammaire decrite dans le fichier doc/grammaires/ligneDeCommande.txt
	procedure axiome;
	procedure sortie;
	procedure option;
  procedure photos;
  procedure section;
  procedure album;
  procedure titre;
  procedure aide;
  procedure version;
  procedure diacritiques;
  procedure bavard;
  procedure dimensions;
  procedure nombre;
  procedure omettre;
  procedure repertoire;
	procedure listeFichiers(t : fichier);
	procedure verifier;
  procedure debug;

end arguments;
