--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

---------------------------------------------------
--
-- Ce paquetage definit un type contenant une chaine et un entier.
-- La chaine correspnd au repertoire courant, et l'entier au niveau de section courant.
--
-----------------------------------------------------
with Ada.strings.unbounded;
use Ada.strings.unbounded;

package sectionrepertoire is

  type sectoire is private;

  -- Retourne le sectoire courant
  function sectoireCourant return sectoire;

  -- Retourne le repertoire courant
  function repertoireCourant return string;

  -- Retourne la section courante
  function sectionCourante return positive;

  -- Place le sectoire courant
  procedure setSectoire(s : sectoire);

  -- Ajoute un chemin au repertoire courant
  procedure ajouteRepertoire(rep : string);

  -- Ajoute des niveaux a la section courante
  procedure ajouteSection(n : positive := 1);

  -- Definit la section courante
  procedure setSection(n : positive);

  -- Definit le repertoire courant
  procedure setRepertoire(rep : string);

  private
  
  type sectoire is record
    repertoire : unbounded_string;
    section : positive;
  end record;

  -- Objet courant
  courant : sectoire;

end sectionrepertoire;
