--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

with texte, sectionrepertoire, trace, diacritiques, erreurs, taillecourante;
use texte, sectionrepertoire, trace, diacritiques, erreurs, taillecourante;

package body options is

  ----------------------------------------
  -- Gere les commentaires de debuggage --
  profMax : integer := 1;
  procedure tracer(prof : positive ; chaine : string) is
  begin
    if prof <= profMax then
      tracerDebug(prof, chaine);
    end if;
  end tracer;
  ----------------------------------------

  ----------- Initialisation des options, et options par defaut
	procedure initoptions is
	begin
    -- Definit la section et le repertoire courants
    setSection(3);
    setRepertoire(".");
    setNomSortie("-");
	end initoptions;

  procedure defautOptions is
  begin
    -- Taille des photos
    if not tailleModifiee then
      -- La taille des photos n'a pas ete modifiee
      setTailleCourante("", "");
    elsif not tailleVariable then
      -- Une seule taille a ete donnee : elle s'applique partout
      setTailleCourante(horizontal, vertical);
    else
      -- Plusieurs taille donnees. Par defait, les tailles sont par defait, mais ca changera par la suite
      setTailleCourante("", "");
    end if;
  end defautOptions;

  --------------------------------------------------------------
  ------------ Affichage  d'informations -----------------------
  ------------ aide version diacritiques -----------------------
  --------------------------------------------------------------

	-- Gestion de l'affichage de l'aide
	procedure demandeAide is
	begin
		aideDemande := true;
	end demandeAide;
	function afficheAide return boolean is
	begin
		return aideDemande;
	end afficheAide;
	
	-- Gestion de l'affichage de la version
	procedure demandeVersion is
	begin
		versionDemande := true;
	end demandeVersion;
	function afficheVersion return boolean is
	begin
		return versionDemande;
	end afficheVersion;
	
	-- Gestion de l'affichage des diacritiques
	procedure demandeDiacritiques is
	begin
		diacritiquesDemande := true;
	end demandeDiacritiques;
	function afficheDiacritiques return boolean is
	begin
		return diacritiquesDemande;
	end afficheDiacritiques;

  --------------------------------------------------------------
  ----------- Nom du fichier de sortie -------------------------
  --------------------------------------------------------------
  
  -- Definit le nom du fichier de sortie
  procedure setNomSortie(n : string) is
  begin
    if n="-" then
      nom := to_unbounded_string("");
    else
      nom := to_unbounded_string(n);
    end if;
  end setNomSortie;

  -- Retourne le nom du fichier de sortie
  function getNomSortie return string is
  begin
    return to_string(nom);
  end getNomSortie;

  --------------------------------------------------------------
  ----------- Nombre de photos par ligne -----------------------
  --------------------------------------------------------------
  -- Definit le nombre de photos par ligne
  procedure setNombre(n : integer) is
  begin
    nombre := n;
  end setNombre;

  -- Retourne le nombre de photos par ligne
  function getNombre return integer is
  begin
    return nombre;
  end getNombre;


  --------------------------------------------------------------
  ----------- Titre --------------------------------------------
  --------------------------------------------------------------
  -- Definit le titre
  procedure setTitre(t : string) is
  begin
    if sansTitre then
      txtTitreSansTitre(t);
    else
      titre := to_unbounded_string(versLatex(t));
      avecTitre := true;
    end if;
  end setTitre;

  -- Specifie que l'on ne veut pas de titre
  procedure pasDeTitre is
  begin
    sansTitre := true;
  end pasDeTitre;

  -- Demande si le titre doit etre affiche ou nom
  function afficheTitre return boolean is
  begin
    return avecTitre and not sansTitre;
  end afficheTitre;

  -- Renvoie le titre
  function getTitre return string is
  begin
    return to_string(titre);
  end getTitre;

  --------------------------------------------------------------
  ----------- Statistiques sur les photos ----------------------
  --------------------------------------------------------------
  -- Verifie le niveau d'une section
  procedure verifieNiveau(niveau : positive) is
  begin
    if ((niveau > 7) or (niveau < 1)) then
      raise erreurNumeroSectionInvalide;
    end if;
    if (niveau < niveauSectionMin) then
      niveauSectionMin := niveau;
    end if;
  end verifieNiveau;

  function niveauMin return positive is
  begin
    return niveauSectionMin;
  end niveauMin;

  --------------------------------------------------------------
  ----------- Taille des photos --------------------------------
  --------------------------------------------------------------
  -- Définit la taille horizontale et verticale des photos.
  -- Une chaine vide signifie : taille automatique
  procedure setTaille(hori, vert : unbounded_string) is
  begin
    if not tailleModifiee then
    -- Premiere definition de la taille
    -- La taille des photos est valables pour TOUTES les photos
      tailleModifiee := true;
      horizontal := hori;
      vertical := vert;
    else
    -- Deuxieme definition de la taille
    -- La taille des photos est variable
      tailleVariable := true;
    end if;
  end setTaille;

end options ;
