--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

with Ada.Text_IO, Ada.strings.unbounded, Ada.IO_Exceptions;
use Ada.Text_IO, Ada.strings.unbounded;

with listefichiers, trace;
use listefichiers, trace;

package body entreeStandard is

  ----------------------------------------
  -- Gere les commentaires de debuggage --
  profMax : integer := 1;
  procedure tracer(prof : positive ; chaine : string) is
  begin
    if prof <= profMax then
      tracerDebug(prof, chaine);
    end if;
  end tracer;
  ----------------------------------------

  procedure analyseEntreeStandard(t : fichier) is
	begin
		Set_Input(Standard_Input);
		while (not End_Of_File)
    -- Pour chaque ligne de l'entree standard, faire :
		loop
      analyseListeFichiers(get_line, t);
		end loop;

	exception
		when ADA.IO_EXCEPTIONS.END_ERROR => null; -- Arrive lorsque l'entree standard se termine par deux lignes vides.
	end analyseEntreeStandard;

end entreeStandard;
