----------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
----------------------------------------------------------------------

----------------------------------------------------------------------
--
-- Ce paquetage gere la taille des images durant la generation du document final,
-- en tenant compte de la taille demandee (option "dim") et du nombre de photos par
-- ligne (option "nombre")
--
----------------------------------------------------------------------

with Ada.strings.unbounded;
use Ada.strings.unbounded;

package tailleCourante is

  -- Définit la taille courante
  procedure setTailleCourante(hori, vert : unbounded_string);
  procedure setTailleCourante(hori, vert : string);
  -- Définit le nombre courant
  procedure setNombreCourant(n : integer);

  -- Retourne la taille courante
  procedure getTailleCourante(hori, vert : out unbounded_string);
  -- Retourne le nombre courant
  function getNombreCourant return integer;

  -- Retourne la chaine LaTeX correspondant a la taille courante
  function getTailleCourante return string;

  private

  -- Taille courante
  -- Une chaine vide correspond a une taille automatique
  horizontal, vertical : unbounded_string;

  -- Nombre courant
  -- Une valeur nulle correspond a un nombre de photos par ligre automatique
  nombre : integer;

end tailleCourante;
