--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

with trace, texte, erreurs, sectionrepertoire, structure;
use trace, texte, erreurs, sectionrepertoire, structure;

package body repertoire is

  ----------------------------------------
  -- Gere les commentaires de debuggage --
  profMax : integer := 1;
  procedure tracer(prof : positive ; chaine : string) is
  begin
    if prof <= profMax then
      tracerDebug(prof, chaine);
    end if;
  end tracer;
  ----------------------------------------

  procedure analyseRepertoire(nom : string) is
  begin
    rechercher(nom, Ordinary_File);
    rechercher(nom, Directory);
  end analyseRepertoire;

  procedure rechercher(nom : string ; Genre : File_Kind) is
    Current_Dir : constant String := Current_Directory;
    Search      : Search_Type;
    Dir_Ent     : Directory_Entry_Type;
    Critere     : Filter_Type;
  begin
    Set_Directory (nom);
    case Genre is
      when Directory => Critere := (Directory => True, others => False);
      when Ordinary_File => Critere := (Ordinary_File => True, others => False);
      when Special_File => Critere := (Special_File => True, others => False);
    end case;
    Start_Search (Search, ".", "", critere);
    while More_Entries (Search) loop
      Get_Next_Entry (Search, Dir_Ent);
      if (Simple_Name(Dir_Ent)/="." and Simple_Name(Dir_Ent)/="..") then
        if (Genre = Directory) then
          repertoireTrouve(Simple_Name(Dir_Ent));
        else
          photoTrouvee(Simple_Name(Dir_Ent));
        end if;
      end if;
    end loop;
    Set_Directory (Current_Dir);
    End_Search (Search);
  exception
    when USE_ERROR =>
      txtErreurOuvertureRepertoire(nom);
      raise erreurArg;
    when Name_Error =>
      txtErreurOuvertureRepertoire(nom);
      raise erreurArg;
  end rechercher;

end repertoire;
