--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

with Ada.Command_Line;
use Ada.Command_Line;

with erreurs, texte, trace;
use erreurs, texte, trace;

package body lexical is

  ----------------------------------------
  -- Gere les commentaires de debuggage --
  profMax : integer := 1;
  procedure tracer(prof : positive ; chaine : string) is
  begin
    if prof <= profMax then
      tracerDebug(prof, chaine);
    end if;
  end tracer;
  ----------------------------------------

	-- Indice du prochain argument a analyser
	nArg : integer := 0;

	function courtArg(s : string) return token is
	begin
		if (s'length = 1) then
		-- Mots "invariables"
			case s(s'first) is
				when '?' => return Aide;
				when 'a' => return Album;
				when 'd' => return Dimensions;
				when 'h' => return Aide;
				when 'l' => return Diacritiques;
				when 'n' => return Nombre;
				when 'o' => return Sortie;
				when 'O' => return Omettre;
				when 'p' => return Photos;
				when 'q' => return Silencieux;
				when 'r' => return Repertoire;
				when 's' => return Section;
				when 't' => return Titre;
				when 'T' => return SansTitre;
				when 'V' => return Bavard;
				when 'v' => return Verifier;
				when others => raise erreurOptionInconnue;
			end case;
		elsif (s'length = 2) then
		-- Mots parametres
			case s(s'First) is
				when 's' => 
					valeur := s(s'First + 1);
					if Section(valeur) then
            return Section;
          else
            raise erreurOptionInconnue;
          end if;
				when 'a' =>
					valeur := s(s'First + 1);
          if Section(valeur) then
            return Album;
          else
            raise erreurOptionInconnue;
          end if;
				when 'r' =>
					valeur := s(s'First + 1);
          if section(valeur) then
            return Repertoire;
          else
            raise erreurOptionInconnue;
          end if;
				when others => raise erreurOptionInconnue;
			end case;
		else
			raise erreurOptionInconnue; 
		end if;
	end courtArg;

	function section(c : character) return boolean is
	-- Verifie si le charactere donne definit bien une section.
	-- Ou encore, verifie qu'il est contenu entre '1' et '7'
	begin
		return character'pos(c) >= character'pos('1') and character'pos(c) <= character'pos('7');
	end section;


	function longArg(s : string) return token is
	begin
		if (s = "album") then
			return Album;
		end if;
		if (s'length = 6 and then s(s'First..s'First + 4) = "album") then
			valeur := s(s'First + 5);
      if section(valeur) then
        return Album;
      else
        raise erreurOptionInconnue;
      end if;
		end if;
    if (s = "debug") then
      return Debug;
    end if;
		if (s = "dim") then
			return Dimensions;
		end if;
		if (s = "help") then
			return Aide;
		end if;
		if (s = "listeDiac") then
			return Diacritiques;
		end if;
		if (s = "nombre") then
			return Nombre;
		end if;
		if (s = "omettre") then
			return Omettre;
		end if;
    if (s = "out") then
      return Sortie;
    end if;
		if (s = "photos") then
			return Photos;
		end if;
    if (s = "quiet") then
      return Silencieux;
    end if;
		if (s = "rep") then
			return Repertoire;
		end if;
		if (s'length = 4 and then s(s'First..s'First + 2) = "rep") then
			valeur := s(s'First + 3);
      if section(valeur) then
        return Repertoire;
      else
        raise erreurOptionInconnue;
      end if;
		end if;
		if (s = "sanstitre") then
			return SansTitre;
		end if;
		if (s = "section") then
			return section;
		end if;
		if (s'length = 8 and then s(s'First..s'First + 6) = "section") then
			valeur := s(s'First + 7);
			if Section(valeur) then
        return Section;
      else
        raise erreurOptionInconnue;
      end if;
		end if;
		if (s = "titre") then
			return Titre;
		end if;
		if (s = "verbose") then
			return Bavard;
		end if;
		if (s = "verifier") then
			return Verifier;
		end if;
		if (s = "version") then
			return Version;
		end if;
		raise erreurOptionInconnue;
	end longArg;

	function motSuivant return token is
	begin
		nArg := nArg + 1;


		if (nArg = Argument_Count + 1) then
		-- Fin de la ligne de commande
			return Fin;
		end if;

		motBrut := to_unbounded_string(Argument(nArg));
		-- Valeur par defaut des effets de bord :
		valeur := '3';

		if (Argument(nArg)'length > 1 and then Argument(nArg)(1..2) = "--") then
			-- Option "longue"
			tracer(5, "Mot lu : '" & tokenToString(longArg(Argument(nArg)(3..Argument(nArg)'length))) & "'");
			return longArg(Argument(nArg)(3..Argument(nArg)'length));
		elsif (Argument(nArg)'length > 1 and then Argument(nArg)(1) = '-') then
			-- Option "courte"
			tracer(5, "Mot lu : '" & tokenToString(CourtArg(Argument(nArg)(2..Argument(nArg)'length))) & "'");
			return CourtArg(Argument(nArg)(2..Argument(nArg)'length));
		else
			-- Chaine de caracteres
			Tracer(5, "Mot lu : '" & tokenToString(Chaine) & "'");
			return Chaine;
		end if;

		exception
			when erreurOptionInconnue =>
				txtErreurOptionInconnue(Argument(nArg));
				raise erreurArg;
			when erreurNumeroSectionInvalide =>
				txtErreurNumeroSectionInvalideArgument(Argument(nArg));
				raise erreurArg;

	end motSuivant;

	function tokenToString(t : token) return string is
	-- Transforme un token en string
	begin
		case t is
			when Aide => return "Aide";
			when Album => return "Album";
			when Chaine => return "Chaine";
			when Diacritiques => return "Diacritiques";
			when Dimensions => return "Dimensions";
			when Fin => return "Fin";
			when Bavard => return "Bavard";
			when Omettre => return "Omettre";
			when Nombre => return "Nombre";
			when Photos => return "Photos";
			when Repertoire => return "Repertoire";
			when SansTitre => return "SansTitre";
			when Silencieux => return "Silencieux";
			when Section => return "Section";
			when Titre => return "Titre";
			when Verifier => return "Verifier";
			when Version => return "Version";
			when others => return "Token inconnu";
		end case;
	end tokenToString;
end lexical;
