--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

-------------------------------------------------------
--
-- Realise l'analyse d'un fichier album
--
-------------------------------------------------------

with Ada.Text_IO, Ada.strings.unbounded;
use Ada.Text_IO, Ada.strings.unbounded;

package albumdesc is

	-- Effectue l'analyse du fichier ayant pour nom 'f'
	-- Ce fichier peut ne pas exister
	procedure analyseAlbum(nom : string);

private

  -- Niveau courant de la section
  section : positive;

  -- Lit une ligne
  procedure litLigne(f : File_Type);

	-- Analyse du fichier
	procedure axiome(f : File_Type);
  procedure Titre1(f : File_Type);
  procedure Titre2(f : File_Type);
  procedure Titre3(f : File_Type);
  procedure Titre4(f : File_Type);
  procedure Titre5(f : File_Type);
  procedure Titre6(f : File_Type);
  procedure Titre7(f : File_Type);
  procedure Album(f : File_Type);
  procedure Repertoire(f : File_Type);
  procedure Photo(f : File_Type);

  -- Types de lignes possibles
  type token is (
    Titre1,
    Titre2,
    Titre3,
    Titre4,
    Titre5,
    Titre6,
    Titre7,
    Album,
    Repertoire,
    Photo,
    Fin -- Fin du fichier atteinte
  );

  -- Ligne courante
  ligneBrute : unbounded_string; -- Ligne telle qu'elle a ete lue
  ligne : token; -- Type de ligne reconnu
  suite : unbounded_string; -- Ligne amputee des premiers caractere la caracterisant

end albumdesc;
