--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

with trace, affichageDiac;
use trace, affichageDiac;

package body texte is

----------------------------meta--------------------------------------------
   procedure metaAide is
   -- Affiche de l'aide
	 begin
      tracerAide("* Intro");
      tracerAide("Le but de ce programme est de realiser des trombinoscopes, aussi simplement que possible.");
      tracerAide("Le programme prends en arguments une liste de fichiers (que l'on considere comme des photos) ");
		tracerAide("et renvoie le code LaTeX correspondant a un trombinoscope des images donnees en argument. La legende d'une image est le nom du ficher correspondant.");
      tracerAide("Les photos peuvent etres organisees avec sept niveaux de sections (qui correspondent aux section LaTeX, de 'chapter' a 'subparagraph').");
      tracerAide("");
      tracerAide("* Appel");
      tracerAide("trombi OPTIONS");
      tracerAide("");
      tracerAide("* Options");
      tracerAide("Toutes les options sont optionnelles.");
      tracerAide("");
      tracerAide("--album fichiers, --album[1-7] fichiers, -a fichiers, -a[1-7] fichiers");
      tracerAide("  Ajoute les photos decrites dans les albums 'fichiers' au trombinoscope.");
      tracerAide("  Si un nombre est precise, il definit le niveau de section de base de l'album (une section de niveau 1 dans un album importe avec -a2 sera une section de niveau 1+2-1=2 (toujours -1).");
      tracerAide("  Plus de details sur les albums plus bas.");
      tracerAide("");
      tracerAide("--dim taille, -d taille");
      tracerAide("  Specifie la taille des photos. 'taille' est de la forme 'largeurxhauteur' (ex : '2x3'). Les photos sont redimensionnees a 'largeur' par 'hauteur' centimetres.");
      tracerAide("  Si la taille ou la hauteur est omise, la proportion des photos est conservee.");
      tracerAide("  Si la taille est 'auto', le logiciel choisit lui meme la taille des photos.");
      tracerAide("  Voir plus bas pour plus de precisions.");
      tracerAide("");
      tracerAide("--debug niveau");
      tracerAide("  Uniquement pour la deboggage du programme.");
      tracerAide("  Definit le niveau de trace pour afficher ou cacher des informations inutiles sur le deroulement du programme.");
      tracerAide("");
      tracerAide("--help, -h, -?");
      tracerAide("  Affiche cette aide.");
      tracerAide("");
      tracerAide("--listeDiac, -l");
      tracerAide("  Affiche la liste de toutes les diacritiques supportees par le programme.");
      tracerAide("  Voir plus bas pour plus de details.");
      tracerAide("");
      tracerAide("--nombre chaine, -n chaine");
      tracerAide("  Nombre de photos par ligne, ou 'auto' pour un comportement automatique decrit plus bas.");
      tracerAide("  PAS ENCORE IMPLEMENTE");
      tracerAide("");
      tracerAide("--out fichier, -o fichier");
      tracerAide("  Nom du fichier de sortie.");
      tracerAide("  Si cette option est absente, ou si le nom du fichier est '-', la sortie se fait sur la sortie standard.");
      tracerAide("");
      tracerAide("--omettre, -O");
      tracerAide("  Supprime automatiquement les sections vides.");
      tracerAide("  PAS ENCORE IMPLEMENTE");
      tracerAide("");
      tracerAide("--photos fichiers, -p fichiers");
      tracerAide("  Ajoute les photos donnees a la liste de fichiers.");
      tracerAide("  Par defaut, les fichiers correspondant peuvent ne pas exister.");
      tracerAide("");
      tracerAide("--quiet, -q");
      tracerAide("  Aucune sortie d'erreur (meme pas les avertissements).");
      tracerAide("  PAS ENCORE IMPLEMENTE");
      tracerAide("");
      tracerAide("--rep repertoire, --rep[1-7] repertoire, -r repertoire, -r[1-7] repertoire");
      tracerAide("  Ajoute un repertoire au trombinoscope. Cela signifie :");
      tracerAide("    creation d'une section portant le nom du repertoire");
      tracerAide("    ajout de toutes les photos (eps) du repertoire");
      tracerAide("    puis meme traitement recursif sur tous les sous repertoires");
      tracerAide("");
      tracerAide("--section titre, --section[1-7] titre, -s titre, -s[1-7] titre");
      tracerAide("  Ajoute une section, par defaut de niveau 3.");
      tracerAide("");
      tracerAide("--titre chaine, -t chaine");
      tracerAide("  Definit le titre du document.");
      tracerAide("  Si plusieurs titres sont definis, seul le dernier est pris en compte.");
      tracerAide("");
      tracerAide("--sanstitre, -T");
      tracerAide("  Specifie que le document n'a pas de titre.");
      tracerAide("  Prioritaire sur l'option ci-dessus.");
      tracerAide("");
      tracerAide("--verifier, -v");
      tracerAide("  Verifie, pour chaque photo ajoutee, que le fichier correspondant existe, et leve une erreur si ce n'est pas le cas.");
      tracerAide("  PAS ENCORE IMPLEMENTE");
      tracerAide("");
      tracerAide("--verbose, -V");
      tracerAide("  Donne plein d'informations inutiles et ennuyeuses.");
      tracerAide("  PAS ENCORE IMPLEMENTE");
      tracerAide("");
      tracerAide("--version");
      tracerAide("  Affiche la version.");
      tracerAide("");
      tracerAide("* Gestion des diacritiques");
      tracerAide("  Chaque legende de photo, chaque section, et le titre ne sont pas integres directement, mais des operations sont appliquees avant:");
      tracerAide("  - Chaque tiret bas est remplace par une espace");
      tracerAide("  - Chaque chaine entre tirets est remplacee par la diacritique correspondant au code html.");
      tracerAide("    Par exemple, le nom de fichier 'R-eacute-mi' est traduit en LaTeX en 'R\'emi', qui donnera dans le document final : 'Rémi'.");
      tracerAide("  - Deux tirets sont remplaces par un tiret.");
      tracerAide("  - Les autres carcteres speciaux en LaTeX sont echappes : 'Pere_&_Fils' devient 'Pere \& Fils'.");
      tracerAide("  - Les diacritiques donnees telles quelles sont remplacees de la meme maniere que le code html. Cependant, ce comportement n'est pas garanti : moins je m'interesserai a l'encodage des caracteres, mieux je me porterai.");
      tracerAide("");
      tracerAide("  C'est bien complique, je suis d'accord. Voici les raisons de ce choix.");
      tracerAide("  - J'aime bien ne pas avoir les informations correspondant a un fichier dispersees a cinquante endroits. La legende du fichier est ainsi contenue dans le fichier.");
      tracerAide("    L'utilisateur n'aura donc pas a se poser la question, en deplacant le fichier par exemple, s'il deplace aussi la legende.");
      tracerAide("  - L'utilisateur peut respecter l'integrite des noms (en conservant les diacritiques) tout en ayant des fichiers dont le nom ne contient que des caracteres alphanumeriques, le tiret et le tiret bas.");
      tracerAide("  - Les diacritiques LaTeX ne sont pas directement utilisee, car certains caracteres ne sont pas 'standards' pour un nom de fichier.");
      tracerAide("    Par exemple, a-t-on l'envie ou le droit de nommer un fichier 'R\'emi' ?");
      tracerAide("  - Il fallait donc un autre code pour decrire les diacritiques. Le code html existe, autant ne pas reinventer la roue.");
      tracerAide("");
      tracerAide("* Description d'un fichier album");
      tracerAide("  Un fichier album contient des informations pour integrer des images et des sections a un trombinoscope.");
      tracerAide("  Il permet de ne pas avoir a ecrire a chaque fois la ligne de commande complete si l'on fait souvent le meme trombinoscope.");
      tracerAide("  Les lignes commencant par #, A, R, ou P sont interpretees de la sorte :");
      tracerAide("    A : la suite de la ligne est une liste d'albums a integrer.");
      tracerAide("    R : la suite de la ligne est use liste de repertoires a integrer.");
      tracerAide("    P : la suite de la ligne est use liste de photos a integrer.");
      tracerAide("    # : la suite de la ligne est le titre d'une section de niveau (relatif) 1");
      tracerAide("    ## : la suite de la ligne est le titre d'une section de niveau (relatif) 2");
      tracerAide("    ...");
      tracerAide("    ####### : la suite de la ligne est le titre d'une section de niveau (relatif) 7");
      tracerAide("  Si les premiers caracteres de la ligne ne correspondent a aucun de ces signes, la ligne est interpretee comme etant une liste de photos.");
      tracerAide("");
      tracerAide("  Le niveau d'une section est egal au niveau relatif PLUS le niveau avec lequel a ete appele l'album (ex : --album4 fichier) MOINS un.");
      tracerAide("");
      tracerAide("* Taille et nombre de photos par ligne");
      tracerAide("  Par defaut, le programme place les photos les unes a la suite des autres dans le document final, sans modifier leur taille.");
		tracerAide("Ceci n'est neanmoins pas conseille. L'utilisateur peut choisir la taille et le nombre de photos par ligne, ou bien les mettre en automatique.");
      tracerAide("  Les comportements possibles sont alors :");
      tracerAide("  taille auto + nombre auto : comportement par defaut decrit juste au dessus.");
      tracerAide("  taille auto + nombre fixe : la taille est calculee de telle sorte que les photos soient aussi grosses que possible, mais respectent le nombre de photos par ligne donne.");
      tracerAide("  hauteur fixe + nombre auto : le nombre par ligne est calcule pour mettre autant de photos que possible sur une ligne.");
      tracerAide("  hauteur fixe + nombre fixe : les deux contraintes sont respectees. Deconseille, car cela peut donner des resultats etranges (comme des lignes trop grandes).");
      tracerAide("");
      tracerAide("  De plus, si une seule taille est donnee dans toute la commande, elle est appliquee a TOUTES les photos.");
      tracerAide("  Si plusieurs sont donnees, chacune d'elle ne s'applique qu'aux photos qui suivent, jusqu'a la prochaine definition de taille.");
      tracerAide("  Par exemple :");
      tracerAide("    trombi a.eps -d 1x1 b.eps c.eps -d auto d.eps e.eps f.eps g.eps -d 2x2 h.eps");
      tracerAide("    Dans cet exemple, les photos ont les tailles suivantes :");
      tracerAide("      a.eps : automatique");
      tracerAide("      b.eps c.eps : 1cm par 1cm");
      tracerAide("      d.eps e.eps f.eps g.eps : automatique");
      tracerAide("      h.eps : 2cm par 2cm");
      tracerAide("");
      tracerAide("  Cette regle s'applique aussi pour le nombre de photos par ligne.");
      tracerAide("");
      tracerAide("* A faire ?");
      tracerAide("Une liste de choses qui pourraient etre ajoutees, mais auxquelles je n'ai pas vraiment reflechit.");
      tracerAide("");
      tracerAide("  ** Sera-t-il possible de modifer l'unite donnee pour la taille des photos ?");
      tracerAide("");
      tracerAide("  ** LaTeX n'accepte par defaut que les photos 'eps', et pour le moment, notre programme aussi.");
      tracerAide("    Faut-il autoriser d'autres formats de photos, quitte a ce que l'utilisateur modifie ensuite le fichier LaTeX pour ajouter par exemple le paquetage permettant de gerer le format en question ?");
      tracerAide("");
      tracerAide("  ** Les photos sont affichee dans le dossier LaTeX relativement au repertoire courant.");
      tracerAide("    Faut-il que l'utilisateur puisse choisir le repertoire de reference ?");
      tracerAide("");
      tracerAide("  ** Ajoute-t-on la gestion de la taille et du nombre de photos par ligne dans l'album ?");
      tracerAide("    Par exemple, que les lignes suivantes changent respectivement la taille des photos a 4 par 4 centimetres, ou le nombne de photos par ligne a 5 :");
      tracerAide("      T 4x4");
      tracerAide("      N 5");
      tracerAide("");
      tracerAide("  ** Faut-il que l'utilisateur puisse mettre des commentaires dans un album ?");
      tracerAide("    Par exemple, les lignes commencant par % peuvent etre ignorees.");
   end metaAide;

   procedure metaVersion is
   -- Affiche la version
	 begin
      tracerAide("Trombi - Copyright 2007-2008 Louis Paternault");
      tracerAide("   Version 0.1");
      tracerAide("");
      tracerAide("");
      tracerAide("This file is part of Trombi.");
      tracerAide("");
      tracerAide("Trombi is free software: you can redistribute it and/or modify");
      tracerAide("it under the terms of the GNU General Public License as published by");
      tracerAide("the Free Software Foundation, either version 3 of the License, or");
      tracerAide("(at your option) any later version.");
      tracerAide("");
      tracerAide("Trombi is distributed in the hope that it will be useful,");
      tracerAide("but WITHOUT ANY WARRANTY; without even the implied warranty of");
      tracerAide("MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the");
      tracerAide("GNU General Public License for more details.");
      tracerAide("");
      tracerAide("You should have received a copy of the GNU General Public License");
      tracerAide("along with Trombi.  If not, see <http://www.gnu.org/licenses/>.");
   end metaVersion;

   procedure metaDiacritiques is
   -- Affiche la liste des diacritiques
	 begin
      tracerAide( "Voici la liste des diacritiques, en iso-8859-1, HTML et LaTeX.");
      tracerAide( "Pour utiliser une diacritique dans un nom de fichier, utilisez le codage HTML, entouré de '-'");
      listeDiacritiques;
   end metaDiacritiques;

--------------------------progression---------------------------------------

	procedure progressionInit is
	-- Affiche l'etape : progression
	begin
		tracerCommentaire( "Initialisation des variables");
	end progressionInit;

	procedure progressionAnalyse is
	-- Affiche l'etape : analyse
	begin
		tracerCommentaire( "Analyse des arguments");
	end progressionAnalyse;

	procedure progressionMeta is
	-- Affiche l'etape : affichage des informations (aide, version...)
	begin
		tracerCommentaire( "Affichage des informations");
	end progressionMeta;

  procedure progressionCoherence is
  -- Affiche l'etape : verification de la coherence des options
  begin
    tracerCommentaire( "Verification de la coherence des options");
  end progressionCoherence;

  procedure progressionGeneration is
    -- Affiche l'etape : generation
  begin
    tracerCommentaire( "Generation du document");
  end progressionGeneration;

----------------------------------todo--------------------------------------

	procedure todo(t : string) is
	-- Affiche que quelque chose n'est pas termine
	-- Utilise uniquement lors de la creation finale. Ne devrait jamais etre affiche lors d'une utilisation normale
	begin
		tracerErreur( "La fonction suivante n'a pas encore ete programmee : " & t);
	end todo;

-----------------------------------erreurs-----------------------------

	procedure txtProposeAide is
	-- Affiche une proposition d'aide
	begin
		tracerErreur( "Pour en savoir davantage, faites : " & '"' & "trombi --help" & '"');
	end txtProposeAide;

	procedure usage is
	-- Affiche l'aide concernant la syntaxe d'appel
	begin
		tracerErreur( "Usage : trombi OPTIONS");
		tracerErreur( "        trombi [-h -? --help -v -l -listeDiac]");
	end usage;
		
  procedure txtErreurImpossible is
  -- Cette erreur ne doit jamais etre levee
  begin
    tracerErreur( "Une erreur interne s'est produite.");
    tracerErreur( "Cette erreur est due a une erreur de conception du logiciel, et non pas a une mauvaise utilisation.");
    tracerErreur( "Merci de contacter les concepteurs de ce programme afin de signaler un bug, en precisant le contexte dans lequel l'erreur s'est produite.");
  end txtErreurImpossible;

	procedure txtErreurOptionInconnue(o : string) is
	-- Une option inconnue a ete passee en argument
	begin
		tracerErreur( "trombi : option invalide : " & o);
		usage;
	end txtErreurOptionInconnue;
	
	procedure txtErreurNumeroSectionInvalideArgument(o : string) is
	-- Section invalide dans les arguments
	begin
		tracerErreur( "trombi : argument '" & o & "' invalide.");
		tracerErreur( "Le numero de section doit etre compris entre 1 et 7 (defaut 3).");
	end txtErreurNumeroSectionInvalideArgument;
	
	procedure txtErreurNumeroSectionInvalideAlbumRep(o : string) is
	-- Section invalide lors de l'analyse d'un album ou d'un repertoire
	begin
		tracerErreur( "trombi : section '" & o & "' invalide.");
		tracerErreur( "Le numero de section doit etre compris entre 1 et 7 (defaut 3).");
	end txtErreurNumeroSectionInvalideAlbumRep;

	procedure txtErreurSyntaxique(o : string) is
	-- Erreur syntaxique
	begin
		tracerErreur( "trombi : Argument '" & o & "' inattendu.");
	end txtErreurSyntaxique;

	procedure txtErreurOuvertureImpossible(f : string) is
	-- Le fichier ne peut pas etre ouvert (mais a priori, il existe)
	begin
		tracerErreur( "trombi : ouverture du fichier '" & f & "' impossible.");
	end;

	procedure txtErreurFichierInexistant(f : string) is
	-- Fichier introuvable
	begin
		tracerErreur( "trombi : le fichier '" & f & "' est introuvable.");
	end;

  procedure txtErreurListeFichiers(c : character) is
  -- Erreur lors de la lecture d'une liste de fichiers
  begin
    tracerErreur( "trombi : caractere '" & c & "' inattendu dans l'entree standard.");
  end;

  procedure txtErreurOuvertureFichier(nom : string) is
  -- Erreur lors de l'ouverture du fichier
  begin
    tracerErreur( "trombi : impossible d'ouvrir le fichier '" & nom & "'.");
  end txtErreurOuvertureFichier;

  procedure txtErreurOuvertureRepertoire(nom : string) is 
  -- Erreur lors de l'ouverture d'un repertoire
  begin
    tracerErreur( "trombi : impossible d'ouvrir le repertoire '" & nom & "'.");
  end txtErreurOuvertureRepertoire;

  procedure txtErreurCoherence is
  -- Certaines options donnees ne sont pas coherentes entre elles
  begin
    tracerErreur( "trombi : certaines options sont incoherentes entre elles :");
  end txtErreurCoherence;

  -- Erreur dans la chaine definissant la dimension des photos
  procedure txtErreurTaille(arg : string) is
  begin
    tracerErreur("trombi : la dimension '" & arg & "' n'est pas valide.");
  end txtErreurTaille;

  -- L'unite demandee n'existe pas
  procedure txtErreurUnite(arg : string) is
  begin
    tracerErreur("trombi : une unite proposee dans la chaine '" & arg & "' n'existe pas.");
    tracerErreur("Les unites acceptees sont : in cm mm pt sp bp pc dd cc.");
    -- Consulter le fichier doc/grammaire/taille.txt pour savoir d'ou je sort cette liste
  end txtErreurUnite;

  -- La chaine attendue devrait etre un entier
  procedure txtErreurEntierInvalide(arg : string) is
  begin
    tracerErreur("trombi : l'argument suivant aurait du etre un entier : '" & arg & "'");
  end txtErreurEntierInvalide;

-----------------------------------avertissements-------------------------
  
  procedure txtFichierNonEpsIgnore(nom : string) is
  -- Une photo qui n'est pas au format eps a ete ignoree.
  begin
    tracerAvertissement( "Le fichier '" & nom & "' n'est pas une image eps, et a donc ete ignore.");
  end txtFichierNonEpsIgnore;

  procedure txtTitreSansTitre(titre : string) is
  -- Un titre est definit alors que l'option sans-titre a deja ete appelee.
  begin
    tracerAvertissement( "L'option 'sans titre' a deja ete appelee. Le titre '" & titre & "' sera ignore." );
  end txtTitreSansTitre;

  -- Un code html utilise est inconnu.
  procedure txtCodeHtmlInconnu(code : string) is
  begin
    tracerAvertissement( "Le code html '" & code & "' n'est pas valide." );
  end txtCodeHtmlInconnu;

  -- Un accent utilise est inconnu.
  procedure txtAccentInconnu(accent : character) is
  begin
    tracerAvertissement( "L'accent '" & accent & "' est inconnu et ne sera donc pas converti en LaTeX." );
  end txtAccentInconnu;

end texte;
