#!/bin/bash

# Copyright (C) 2016, 2018, 2021  Stefan Vargyas
# 
# This file is part of Trie-Gen.
# 
# Trie-Gen is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Trie-Gen is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Trie-Gen.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ gen-test -T help
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L help.old <(echo \
'$ print() { printf '\''%s\n'\'' "$@"; }
$ ../src/trie -?
usage: trie [OPTION]...
where the options are:
  -t|--node-type=NODE      use the specified node type; any of: i[nt], f[loat] or
                             s[tr[ing]]; the default is string
  -T|--trie-type=TRIE      use the specified trie type: any of array or ternary;
                             the default is ternary
  -o|--output-type=OUT     generate output of the specified type: o[bj[ect]],
                             c[-code], t[rie] or e[xpr]; the default is object
  -g|--gen-type=GEN        when printing output of type c-code, trie or expr, generate
                             it according to the specification: c[omp[act]] or w[ide];
                             the default is wide
  -P|--path-type=PATH      when printing output of type compact c-code, produce the trie
                             path matching code of specified type: either e[xpanded] or
                             f[unction]; the default is expanded
  -p|--prefix-func=NAME    when printing output of type compact c-code with path code of
                             type function, use the given name for the prefix function;
                             the default name is prefix
  -q|--equal-func=NAME     when printing output of type compact c-code with path code of
                             type function, use the given name for the equal function;
                             the default name is equal
  -u|--[no-]unique-prefix  when printing output of type compact c-code, generate it such
                             that to accept unique -- i.e. non-ambiguous -- prefixes of
                             input keywords; `--no-unique-prefix'\'' specifies the code
                             to accept only complete keywords (default)
  -z|--[no-]zero-start     when trie node type is numeric, start keyword indexing at 0,
                             or otherwise at 1 (default at 1)
  -c|--escape-chars=STR    when printing output of type expr, escape the specified chars
  -e|--expr-type=EXPR      when printing output of type expr, generate the expression of
                             given type: any of c[xxpy], p[erl] or b[ash]; the default
                             is cxxpy
  -D|--[expr-]depth=NUM    use the specified maximum depth for the generated expression
                             when printing output of type expr
  -a|--[no-][print-]attrs  put annotation attributes in structure print outs
                             or otherwise do not (default not)
  -s|--[no-][print-]stats  print out some statistics information
                             or otherwise do not (default not)
  -d|--[no-][print-]dots   put indenting dots in structure print outs
                             or otherwise do not (default not)
     --debug[=LEVEL]       do print some debugging output; LEVEL is [0-9], default 1;
     --no-debug            do not print debugging output at all (default)
     --dump-opt[ion]s      print options and exit
  -V|--[no-]verbose        be verbose (cumulative) or not (default not)
  -v|--version             print version numbers and exit
     --help                display this help info and exit'
) -L help.new <(
echo '$ print() { printf '\''%s\n'\'' "$@"; }'
print() { printf '%s\n' "$@"; } 2>&1 ||
echo 'command failed: print() { printf '\''%s\n'\'' "$@"; }'

echo '$ ../src/trie -?'
../src/trie -? 2>&1 ||
echo 'command failed: ../src/trie -?'
)

