#!/bin/bash

# Copyright (C) 2016, 2018  Stefan Vargyas
# 
# This file is part of Trie-Gen.
# 
# Trie-Gen is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Trie-Gen is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Trie-Gen.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ gen-test -w64 -R
#

w=64
c=""
q=""

if [[ "$1" =~ ^-w[1-9][0-9]*$ ]]; then
    w="${1:2}"
    shift
fi
if [ "$1" == "-c" ]; then
    c="c"
    shift
fi
if [ "$1" == "-q" ]; then
    q="q"
fi

p=0
f=0

for t in \
    help \
    opts \
    base \
    dup \
    print-obj-base0-array \
    print-obj-base0-ternary \
    print-obj-base \
    print-obj-base-array \
    print-obj-base-ternary \
    print-obj-alphabets-array \
    print-obj-alphabets-ternary \
    print-obj-filenames-array \
    print-obj-filenames-ternary \
    gen-wide-c-code-base0-array \
    gen-wide-c-code-base0-ternary \
    gen-wide-c-code-base \
    gen-wide-c-code-base-array \
    gen-wide-c-code-base-ternary \
    gen-wide-c-code-alphabets-array \
    gen-wide-c-code-alphabets-ternary \
    gen-wide-c-code-filenames-array \
    gen-wide-c-code-filenames-ternary \
    gen-compact-c-code-base0-array \
    gen-compact-c-code-base0-ternary \
    gen-compact-c-code-base \
    gen-compact-c-code-base-array \
    gen-compact-c-code-base-ternary \
    gen-compact-c-code-alphabets-array \
    gen-compact-c-code-alphabets-ternary \
    gen-compact-c-code-filenames-array \
    gen-compact-c-code-filenames-ternary \
    gen-compact-c-code-unique-prefix-base0-array \
    gen-compact-c-code-unique-prefix-base0-ternary \
    gen-compact-c-code-unique-prefix-base \
    gen-compact-c-code-unique-prefix-base-array \
    gen-compact-c-code-unique-prefix-base-ternary \
    gen-compact-c-code-unique-prefix-alphabets-array \
    gen-compact-c-code-unique-prefix-alphabets-ternary \
    gen-compact-c-code-unique-prefix-filenames-array \
    gen-compact-c-code-unique-prefix-filenames-ternary \
    gen-compact-c-code-path-function-base0-array \
    gen-compact-c-code-path-function-base0-ternary \
    gen-compact-c-code-path-function-base-array \
    gen-compact-c-code-path-function-base-ternary \
    gen-compact-c-code-path-function-alphabets-array \
    gen-compact-c-code-path-function-alphabets-ternary \
    gen-compact-c-code-path-function-filenames-array \
    gen-compact-c-code-path-function-filenames-ternary \
    gen-compact-c-code-path-function-unique-prefix-base0-array \
    gen-compact-c-code-path-function-unique-prefix-base0-ternary \
    gen-compact-c-code-path-function-unique-prefix-base-array \
    gen-compact-c-code-path-function-unique-prefix-base-ternary \
    gen-compact-c-code-path-function-unique-prefix-alphabets-array \
    gen-compact-c-code-path-function-unique-prefix-alphabets-ternary \
    gen-compact-c-code-path-function-unique-prefix-filenames-array \
    gen-compact-c-code-path-function-unique-prefix-filenames-ternary \
    gen-wide-trie-base0-array \
    gen-wide-trie-base0-ternary \
    gen-wide-trie-base \
    gen-wide-trie-base-array \
    gen-wide-trie-base-ternary \
    gen-wide-trie-alphabets-array \
    gen-wide-trie-alphabets-ternary \
    gen-wide-trie-filenames-array \
    gen-wide-trie-filenames-ternary \
    gen-compact-trie-base0-array \
    gen-compact-trie-base0-ternary \
    gen-compact-trie-base \
    gen-compact-trie-base-array \
    gen-compact-trie-base-ternary \
    gen-compact-trie-alphabets-array \
    gen-compact-trie-alphabets-ternary \
    gen-compact-trie-filenames-array \
    gen-compact-trie-filenames-ternary \
    gen-wide-expr-cxxpy-depth-0-base0-array \
    gen-wide-expr-cxxpy-depth-0-base0-ternary \
    gen-wide-expr-cxxpy-depth-0-base \
    gen-wide-expr-cxxpy-depth-0-base-array \
    gen-wide-expr-cxxpy-depth-0-base-ternary \
    gen-wide-expr-cxxpy-depth-0-alphabets-array \
    gen-wide-expr-cxxpy-depth-0-alphabets-ternary \
    gen-wide-expr-cxxpy-depth-0-filenames-array \
    gen-wide-expr-cxxpy-depth-0-filenames-ternary \
    gen-compact-expr-cxxpy-depth-0-base0-array \
    gen-compact-expr-cxxpy-depth-0-base0-ternary \
    gen-compact-expr-cxxpy-depth-0-base \
    gen-compact-expr-cxxpy-depth-0-base-array \
    gen-compact-expr-cxxpy-depth-0-base-ternary \
    gen-compact-expr-cxxpy-depth-0-alphabets-array \
    gen-compact-expr-cxxpy-depth-0-alphabets-ternary \
    gen-compact-expr-cxxpy-depth-0-filenames-array \
    gen-compact-expr-cxxpy-depth-0-filenames-ternary \
    gen-wide-expr-cxxpy-depth-1-base0-array \
    gen-wide-expr-cxxpy-depth-1-base0-ternary \
    gen-wide-expr-cxxpy-depth-1-base \
    gen-wide-expr-cxxpy-depth-1-base-array \
    gen-wide-expr-cxxpy-depth-1-base-ternary \
    gen-wide-expr-cxxpy-depth-1-alphabets-array \
    gen-wide-expr-cxxpy-depth-1-alphabets-ternary \
    gen-wide-expr-cxxpy-depth-1-filenames-array \
    gen-wide-expr-cxxpy-depth-1-filenames-ternary \
    gen-compact-expr-cxxpy-depth-1-base0-array \
    gen-compact-expr-cxxpy-depth-1-base0-ternary \
    gen-compact-expr-cxxpy-depth-1-base \
    gen-compact-expr-cxxpy-depth-1-base-array \
    gen-compact-expr-cxxpy-depth-1-base-ternary \
    gen-compact-expr-cxxpy-depth-1-alphabets-array \
    gen-compact-expr-cxxpy-depth-1-alphabets-ternary \
    gen-compact-expr-cxxpy-depth-1-filenames-array \
    gen-compact-expr-cxxpy-depth-1-filenames-ternary \
    gen-wide-expr-cxxpy-depth-2-base0-array \
    gen-wide-expr-cxxpy-depth-2-base0-ternary \
    gen-wide-expr-cxxpy-depth-2-base \
    gen-wide-expr-cxxpy-depth-2-base-array \
    gen-wide-expr-cxxpy-depth-2-base-ternary \
    gen-wide-expr-cxxpy-depth-2-alphabets-array \
    gen-wide-expr-cxxpy-depth-2-alphabets-ternary \
    gen-wide-expr-cxxpy-depth-2-filenames-array \
    gen-wide-expr-cxxpy-depth-2-filenames-ternary \
    gen-compact-expr-cxxpy-depth-2-base0-array \
    gen-compact-expr-cxxpy-depth-2-base0-ternary \
    gen-compact-expr-cxxpy-depth-2-base \
    gen-compact-expr-cxxpy-depth-2-base-array \
    gen-compact-expr-cxxpy-depth-2-base-ternary \
    gen-compact-expr-cxxpy-depth-2-alphabets-array \
    gen-compact-expr-cxxpy-depth-2-alphabets-ternary \
    gen-compact-expr-cxxpy-depth-2-filenames-array \
    gen-compact-expr-cxxpy-depth-2-filenames-ternary \
    gen-wide-expr-perl-depth-0-base0-array \
    gen-wide-expr-perl-depth-0-base0-ternary \
    gen-wide-expr-perl-depth-0-base \
    gen-wide-expr-perl-depth-0-base-array \
    gen-wide-expr-perl-depth-0-base-ternary \
    gen-wide-expr-perl-depth-0-alphabets-array \
    gen-wide-expr-perl-depth-0-alphabets-ternary \
    gen-wide-expr-perl-depth-0-filenames-array \
    gen-wide-expr-perl-depth-0-filenames-ternary \
    gen-compact-expr-perl-depth-0-base0-array \
    gen-compact-expr-perl-depth-0-base0-ternary \
    gen-compact-expr-perl-depth-0-base \
    gen-compact-expr-perl-depth-0-base-array \
    gen-compact-expr-perl-depth-0-base-ternary \
    gen-compact-expr-perl-depth-0-alphabets-array \
    gen-compact-expr-perl-depth-0-alphabets-ternary \
    gen-compact-expr-perl-depth-0-filenames-array \
    gen-compact-expr-perl-depth-0-filenames-ternary \
    gen-wide-expr-perl-depth-1-base0-array \
    gen-wide-expr-perl-depth-1-base0-ternary \
    gen-wide-expr-perl-depth-1-base \
    gen-wide-expr-perl-depth-1-base-array \
    gen-wide-expr-perl-depth-1-base-ternary \
    gen-wide-expr-perl-depth-1-alphabets-array \
    gen-wide-expr-perl-depth-1-alphabets-ternary \
    gen-wide-expr-perl-depth-1-filenames-array \
    gen-wide-expr-perl-depth-1-filenames-ternary \
    gen-compact-expr-perl-depth-1-base0-array \
    gen-compact-expr-perl-depth-1-base0-ternary \
    gen-compact-expr-perl-depth-1-base \
    gen-compact-expr-perl-depth-1-base-array \
    gen-compact-expr-perl-depth-1-base-ternary \
    gen-compact-expr-perl-depth-1-alphabets-array \
    gen-compact-expr-perl-depth-1-alphabets-ternary \
    gen-compact-expr-perl-depth-1-filenames-array \
    gen-compact-expr-perl-depth-1-filenames-ternary \
    gen-wide-expr-perl-depth-2-base0-array \
    gen-wide-expr-perl-depth-2-base0-ternary \
    gen-wide-expr-perl-depth-2-base \
    gen-wide-expr-perl-depth-2-base-array \
    gen-wide-expr-perl-depth-2-base-ternary \
    gen-wide-expr-perl-depth-2-alphabets-array \
    gen-wide-expr-perl-depth-2-alphabets-ternary \
    gen-wide-expr-perl-depth-2-filenames-array \
    gen-wide-expr-perl-depth-2-filenames-ternary \
    gen-compact-expr-perl-depth-2-base0-array \
    gen-compact-expr-perl-depth-2-base0-ternary \
    gen-compact-expr-perl-depth-2-base \
    gen-compact-expr-perl-depth-2-base-array \
    gen-compact-expr-perl-depth-2-base-ternary \
    gen-compact-expr-perl-depth-2-alphabets-array \
    gen-compact-expr-perl-depth-2-alphabets-ternary \
    gen-compact-expr-perl-depth-2-filenames-array \
    gen-compact-expr-perl-depth-2-filenames-ternary \
    gen-wide-expr-bash-depth-0-base0-array \
    gen-wide-expr-bash-depth-0-base0-ternary \
    gen-wide-expr-bash-depth-0-base \
    gen-wide-expr-bash-depth-0-base-array \
    gen-wide-expr-bash-depth-0-base-ternary \
    gen-wide-expr-bash-depth-0-alphabets-array \
    gen-wide-expr-bash-depth-0-alphabets-ternary \
    gen-wide-expr-bash-depth-0-filenames-array \
    gen-wide-expr-bash-depth-0-filenames-ternary \
    gen-compact-expr-bash-depth-0-base0-array \
    gen-compact-expr-bash-depth-0-base0-ternary \
    gen-compact-expr-bash-depth-0-base \
    gen-compact-expr-bash-depth-0-base-array \
    gen-compact-expr-bash-depth-0-base-ternary \
    gen-compact-expr-bash-depth-0-alphabets-array \
    gen-compact-expr-bash-depth-0-alphabets-ternary \
    gen-compact-expr-bash-depth-0-filenames-array \
    gen-compact-expr-bash-depth-0-filenames-ternary \
    gen-wide-expr-bash-depth-1-base0-array \
    gen-wide-expr-bash-depth-1-base0-ternary \
    gen-wide-expr-bash-depth-1-base \
    gen-wide-expr-bash-depth-1-base-array \
    gen-wide-expr-bash-depth-1-base-ternary \
    gen-wide-expr-bash-depth-1-alphabets-array \
    gen-wide-expr-bash-depth-1-alphabets-ternary \
    gen-wide-expr-bash-depth-1-filenames-array \
    gen-wide-expr-bash-depth-1-filenames-ternary \
    gen-compact-expr-bash-depth-1-base0-array \
    gen-compact-expr-bash-depth-1-base0-ternary \
    gen-compact-expr-bash-depth-1-base \
    gen-compact-expr-bash-depth-1-base-array \
    gen-compact-expr-bash-depth-1-base-ternary \
    gen-compact-expr-bash-depth-1-alphabets-array \
    gen-compact-expr-bash-depth-1-alphabets-ternary \
    gen-compact-expr-bash-depth-1-filenames-array \
    gen-compact-expr-bash-depth-1-filenames-ternary \
    gen-wide-expr-bash-depth-2-base0-array \
    gen-wide-expr-bash-depth-2-base0-ternary \
    gen-wide-expr-bash-depth-2-base \
    gen-wide-expr-bash-depth-2-base-array \
    gen-wide-expr-bash-depth-2-base-ternary \
    gen-wide-expr-bash-depth-2-alphabets-array \
    gen-wide-expr-bash-depth-2-alphabets-ternary \
    gen-wide-expr-bash-depth-2-filenames-array \
    gen-wide-expr-bash-depth-2-filenames-ternary \
    gen-compact-expr-bash-depth-2-base0-array \
    gen-compact-expr-bash-depth-2-base0-ternary \
    gen-compact-expr-bash-depth-2-base \
    gen-compact-expr-bash-depth-2-base-array \
    gen-compact-expr-bash-depth-2-base-ternary \
    gen-compact-expr-bash-depth-2-alphabets-array \
    gen-compact-expr-bash-depth-2-alphabets-ternary \
    gen-compact-expr-bash-depth-2-filenames-array \
    gen-compact-expr-bash-depth-2-filenames-ternary \
    gen-func \
    gen-func2 \
    gen-func3 \
    gen-func4 \
    bugs
do
    test -z "$q" &&
    printf >&2 "%-$((w + 6))s " "test: $t"
    if ! ./test-$t.sh &>/dev/null; then
        (( f ++ ))

        test -n "$q" &&
        echo >&2 -n "test: $t "
        echo >&2 failed
    else
        (( p ++ ))

        test -z "$q" &&
        echo >&2 OK
    fi
done

if [ -z "$c" ]; then
    [ -z "$q" -o "$f" -gt 0 ] &&
    echo >&2
    echo "tests passed: $p"
    echo "tests failed: $f"
else
    echo "$p"
    echo "$f"
fi

exit $(( f != 0 ))

