#!/bin/bash

# Copyright (C) 2016, 2018  Stefan Vargyas
# 
# This file is part of Trie-Gen.
# 
# Trie-Gen is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Trie-Gen is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Trie-Gen.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ gen-test -T print-obj-base-ternary
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L print-obj-base-ternary.old <(echo \
'$ print() { printf '\''%s\n'\'' "$@"; }
$ trie() { ../src/trie --output=object --attrs --dots --trie=ternary "$@"; }
$ print|trie
trie: error: tries cannot contain empty keys
command failed: print|trie
$ print a|trie
[1,'\''a'\'']
[0] {
.   .ch: '\''a'\''
.   .eq [0] {
.   .   .val: "a"
.   }
}
$ print a b|trie
[2,'\''b'\'']
[0] {
.   .ch: '\''a'\''
.   .eq [0] {
.   .   .val: "a"
.   }
.   .hi [0] {
.   .   .ch: '\''b'\''
.   .   .eq [0] {
.   .   .   .val: "b"
.   .   }
.   }
}
$ print a b c|trie
[3,'\''c'\'']
[0] {
.   .ch: '\''a'\''
.   .eq [0] {
.   .   .val: "a"
.   }
.   .hi [0] {
.   .   .ch: '\''b'\''
.   .   .eq [0] {
.   .   .   .val: "b"
.   .   }
.   .   .hi [0] {
.   .   .   .ch: '\''c'\''
.   .   .   .eq [0] {
.   .   .   .   .val: "c"
.   .   .   }
.   .   }
.   }
}
$ print a ab abc|trie
[1,'\''a'\'']
[1,'\''b'\''] {
.   .ch: '\''a'\''
.   .eq [0] {
.   .   .val: "a"
.   .   .hi [1,'\''c'\''] {
.   .   .   .ch: '\''b'\''
.   .   .   .eq [0] {
.   .   .   .   .val: "ab"
.   .   .   .   .hi [0] {
.   .   .   .   .   .ch: '\''c'\''
.   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .val: "abc"
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
$ print a ab ac|trie
[1,'\''a'\'']
[2,'\''c'\''] {
.   .ch: '\''a'\''
.   .eq [0] {
.   .   .val: "a"
.   .   .hi [0] {
.   .   .   .ch: '\''b'\''
.   .   .   .eq [0] {
.   .   .   .   .val: "ab"
.   .   .   }
.   .   .   .hi [0] {
.   .   .   .   .ch: '\''c'\''
.   .   .   .   .eq [0] {
.   .   .   .   .   .val: "ac"
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
$ print a ab ac ad|trie
[1,'\''a'\'']
[3,'\''d'\''] {
.   .ch: '\''a'\''
.   .eq [0] {
.   .   .val: "a"
.   .   .hi [0] {
.   .   .   .ch: '\''b'\''
.   .   .   .eq [0] {
.   .   .   .   .val: "ab"
.   .   .   }
.   .   .   .hi [0] {
.   .   .   .   .ch: '\''c'\''
.   .   .   .   .eq [0] {
.   .   .   .   .   .val: "ac"
.   .   .   .   }
.   .   .   .   .hi [0] {
.   .   .   .   .   .ch: '\''d'\''
.   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .val: "ad"
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
$ print a abd ac|trie
[1,'\''a'\'']
[2,'\''c'\''] {
.   .ch: '\''a'\''
.   .eq [0] {
.   .   .val: "a"
.   .   .hi [1,'\''d'\''] {
.   .   .   .ch: '\''b'\''
.   .   .   .eq [0] {
.   .   .   .   .ch: '\''d'\''
.   .   .   .   .eq [0] {
.   .   .   .   .   .val: "abd"
.   .   .   .   }
.   .   .   }
.   .   .   .hi [0] {
.   .   .   .   .ch: '\''c'\''
.   .   .   .   .eq [0] {
.   .   .   .   .   .val: "ac"
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
$ print a ab ac acd|trie
[1,'\''a'\'']
[2,'\''c'\''] {
.   .ch: '\''a'\''
.   .eq [0] {
.   .   .val: "a"
.   .   .hi [0] {
.   .   .   .ch: '\''b'\''
.   .   .   .eq [0] {
.   .   .   .   .val: "ab"
.   .   .   }
.   .   .   .hi [1,'\''d'\''] {
.   .   .   .   .ch: '\''c'\''
.   .   .   .   .eq [0] {
.   .   .   .   .   .val: "ac"
.   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .ch: '\''d'\''
.   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .val: "acd"
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
$ print a bb ba ccc|trie
[3,'\''c'\'']
[0] {
.   .ch: '\''a'\''
.   .eq [0] {
.   .   .val: "a"
.   }
.   .hi [2,'\''b'\''] {
.   .   .ch: '\''b'\''
.   .   .eq [0] {
.   .   .   .ch: '\''b'\''
.   .   .   .lo [0] {
.   .   .   .   .ch: '\''a'\''
.   .   .   .   .eq [0] {
.   .   .   .   .   .val: "ba"
.   .   .   .   }
.   .   .   }
.   .   .   .eq [0] {
.   .   .   .   .val: "bb"
.   .   .   }
.   .   }
.   .   .hi [1,'\''c'\''] {
.   .   .   .ch: '\''c'\''
.   .   .   .eq [1,'\''c'\''] {
.   .   .   .   .ch: '\''c'\''
.   .   .   .   .eq [0] {
.   .   .   .   .   .ch: '\''c'\''
.   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .val: "ccc"
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
$ print a bb ccc|trie
[3,'\''c'\'']
[0] {
.   .ch: '\''a'\''
.   .eq [0] {
.   .   .val: "a"
.   }
.   .hi [1,'\''b'\''] {
.   .   .ch: '\''b'\''
.   .   .eq [0] {
.   .   .   .ch: '\''b'\''
.   .   .   .eq [0] {
.   .   .   .   .val: "bb"
.   .   .   }
.   .   }
.   .   .hi [1,'\''c'\''] {
.   .   .   .ch: '\''c'\''
.   .   .   .eq [1,'\''c'\''] {
.   .   .   .   .ch: '\''c'\''
.   .   .   .   .eq [0] {
.   .   .   .   .   .ch: '\''c'\''
.   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .val: "ccc"
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
$ print a bb ba ccc|trie
[3,'\''c'\'']
[0] {
.   .ch: '\''a'\''
.   .eq [0] {
.   .   .val: "a"
.   }
.   .hi [2,'\''b'\''] {
.   .   .ch: '\''b'\''
.   .   .eq [0] {
.   .   .   .ch: '\''b'\''
.   .   .   .lo [0] {
.   .   .   .   .ch: '\''a'\''
.   .   .   .   .eq [0] {
.   .   .   .   .   .val: "ba"
.   .   .   .   }
.   .   .   }
.   .   .   .eq [0] {
.   .   .   .   .val: "bb"
.   .   .   }
.   .   }
.   .   .hi [1,'\''c'\''] {
.   .   .   .ch: '\''c'\''
.   .   .   .eq [1,'\''c'\''] {
.   .   .   .   .ch: '\''c'\''
.   .   .   .   .eq [0] {
.   .   .   .   .   .ch: '\''c'\''
.   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .val: "ccc"
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
$ print abc abd acde|trie
[1,'\''a'\'']
[2,'\''c'\''] {
.   .ch: '\''a'\''
.   .eq [2,'\''d'\''] {
.   .   .ch: '\''b'\''
.   .   .eq [0] {
.   .   .   .ch: '\''c'\''
.   .   .   .eq [0] {
.   .   .   .   .val: "abc"
.   .   .   }
.   .   .   .hi [0] {
.   .   .   .   .ch: '\''d'\''
.   .   .   .   .eq [0] {
.   .   .   .   .   .val: "abd"
.   .   .   .   }
.   .   .   }
.   .   }
.   .   .hi [1,'\''d'\''] {
.   .   .   .ch: '\''c'\''
.   .   .   .eq [1,'\''e'\''] {
.   .   .   .   .ch: '\''d'\''
.   .   .   .   .eq [0] {
.   .   .   .   .   .ch: '\''e'\''
.   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .val: "acde"
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
$ print abc abd acde ac|trie
[1,'\''a'\'']
[2,'\''c'\''] {
.   .ch: '\''a'\''
.   .eq [2,'\''d'\''] {
.   .   .ch: '\''b'\''
.   .   .eq [0] {
.   .   .   .ch: '\''c'\''
.   .   .   .eq [0] {
.   .   .   .   .val: "abc"
.   .   .   }
.   .   .   .hi [0] {
.   .   .   .   .ch: '\''d'\''
.   .   .   .   .eq [0] {
.   .   .   .   .   .val: "abd"
.   .   .   .   }
.   .   .   }
.   .   }
.   .   .hi [1,'\''d'\''] {
.   .   .   .ch: '\''c'\''
.   .   .   .eq [1,'\''e'\''] {
.   .   .   .   .ch: '\''d'\''
.   .   .   .   .lo [0] {
.   .   .   .   .   .val: "ac"
.   .   .   .   }
.   .   .   .   .eq [0] {
.   .   .   .   .   .ch: '\''e'\''
.   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .val: "acde"
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
$ print abc abd acde acfg|trie
[1,'\''a'\'']
[2,'\''c'\''] {
.   .ch: '\''a'\''
.   .eq [2,'\''d'\''] {
.   .   .ch: '\''b'\''
.   .   .eq [0] {
.   .   .   .ch: '\''c'\''
.   .   .   .eq [0] {
.   .   .   .   .val: "abc"
.   .   .   }
.   .   .   .hi [0] {
.   .   .   .   .ch: '\''d'\''
.   .   .   .   .eq [0] {
.   .   .   .   .   .val: "abd"
.   .   .   .   }
.   .   .   }
.   .   }
.   .   .hi [2,'\''f'\''] {
.   .   .   .ch: '\''c'\''
.   .   .   .eq [1,'\''e'\''] {
.   .   .   .   .ch: '\''d'\''
.   .   .   .   .eq [0] {
.   .   .   .   .   .ch: '\''e'\''
.   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .val: "acde"
.   .   .   .   .   }
.   .   .   .   }
.   .   .   .   .hi [1,'\''g'\''] {
.   .   .   .   .   .ch: '\''f'\''
.   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .ch: '\''g'\''
.   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .val: "acfg"
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
$ print cde cfg cfgx cfgxy cfgxyz cfgxzzz|trie
[1,'\''c'\'']
[2,'\''f'\''] {
.   .ch: '\''c'\''
.   .eq [1,'\''e'\''] {
.   .   .ch: '\''d'\''
.   .   .eq [0] {
.   .   .   .ch: '\''e'\''
.   .   .   .eq [0] {
.   .   .   .   .val: "cde"
.   .   .   }
.   .   }
.   .   .hi [1,'\''g'\''] {
.   .   .   .ch: '\''f'\''
.   .   .   .eq [1,'\''x'\''] {
.   .   .   .   .ch: '\''g'\''
.   .   .   .   .eq [0] {
.   .   .   .   .   .val: "cfg"
.   .   .   .   .   .hi [2,'\''z'\''] {
.   .   .   .   .   .   .ch: '\''x'\''
.   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .val: "cfgx"
.   .   .   .   .   .   .   .hi [1,'\''z'\''] {
.   .   .   .   .   .   .   .   .ch: '\''y'\''
.   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .val: "cfgxy"
.   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .ch: '\''z'\''
.   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .val: "cfgxyz"
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .hi [1,'\''z'\''] {
.   .   .   .   .   .   .   .   .   .ch: '\''z'\''
.   .   .   .   .   .   .   .   .   .eq [1,'\''z'\''] {
.   .   .   .   .   .   .   .   .   .   .ch: '\''z'\''
.   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .ch: '\''z'\''
.   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .val: "cfgxzzz"
.   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
$ print cge cfg cfgx cfgxy cfgxyz cfgxzzz|trie
[1,'\''c'\'']
[2,'\''g'\''] {
.   .ch: '\''c'\''
.   .eq [1,'\''e'\''] {
.   .   .ch: '\''g'\''
.   .   .lo [1,'\''g'\''] {
.   .   .   .ch: '\''f'\''
.   .   .   .eq [1,'\''x'\''] {
.   .   .   .   .ch: '\''g'\''
.   .   .   .   .eq [0] {
.   .   .   .   .   .val: "cfg"
.   .   .   .   .   .hi [2,'\''z'\''] {
.   .   .   .   .   .   .ch: '\''x'\''
.   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .val: "cfgx"
.   .   .   .   .   .   .   .hi [1,'\''z'\''] {
.   .   .   .   .   .   .   .   .ch: '\''y'\''
.   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .val: "cfgxy"
.   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .ch: '\''z'\''
.   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .val: "cfgxyz"
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .hi [1,'\''z'\''] {
.   .   .   .   .   .   .   .   .   .ch: '\''z'\''
.   .   .   .   .   .   .   .   .   .eq [1,'\''z'\''] {
.   .   .   .   .   .   .   .   .   .   .ch: '\''z'\''
.   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .ch: '\''z'\''
.   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .val: "cfgxzzz"
.   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   .   .eq [0] {
.   .   .   .ch: '\''e'\''
.   .   .   .eq [0] {
.   .   .   .   .val: "cge"
.   .   .   }
.   .   }
.   }
}
$ print a abcd abcdefg h hijk|trie
[2,'\''h'\'']
[1,'\''b'\''] {
.   .ch: '\''a'\''
.   .eq [0] {
.   .   .val: "a"
.   .   .hi [1,'\''c'\''] {
.   .   .   .ch: '\''b'\''
.   .   .   .eq [1,'\''d'\''] {
.   .   .   .   .ch: '\''c'\''
.   .   .   .   .eq [1,'\''e'\''] {
.   .   .   .   .   .ch: '\''d'\''
.   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .val: "abcd"
.   .   .   .   .   .   .hi [1,'\''f'\''] {
.   .   .   .   .   .   .   .ch: '\''e'\''
.   .   .   .   .   .   .   .eq [1,'\''g'\''] {
.   .   .   .   .   .   .   .   .ch: '\''f'\''
.   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .ch: '\''g'\''
.   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .val: "abcdefg"
.   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
.   .hi [1,'\''i'\''] {
.   .   .ch: '\''h'\''
.   .   .eq [0] {
.   .   .   .val: "h"
.   .   .   .hi [1,'\''j'\''] {
.   .   .   .   .ch: '\''i'\''
.   .   .   .   .eq [1,'\''k'\''] {
.   .   .   .   .   .ch: '\''j'\''
.   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .ch: '\''k'\''
.   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .val: "hijk"
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
$ print a abcd abcdefg abcdxyz h hijk|trie
[2,'\''h'\'']
[1,'\''b'\''] {
.   .ch: '\''a'\''
.   .eq [0] {
.   .   .val: "a"
.   .   .hi [1,'\''c'\''] {
.   .   .   .ch: '\''b'\''
.   .   .   .eq [1,'\''d'\''] {
.   .   .   .   .ch: '\''c'\''
.   .   .   .   .eq [2,'\''x'\''] {
.   .   .   .   .   .ch: '\''d'\''
.   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .val: "abcd"
.   .   .   .   .   .   .hi [1,'\''f'\''] {
.   .   .   .   .   .   .   .ch: '\''e'\''
.   .   .   .   .   .   .   .eq [1,'\''g'\''] {
.   .   .   .   .   .   .   .   .ch: '\''f'\''
.   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .ch: '\''g'\''
.   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .val: "abcdefg"
.   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .hi [1,'\''y'\''] {
.   .   .   .   .   .   .   .   .ch: '\''x'\''
.   .   .   .   .   .   .   .   .eq [1,'\''z'\''] {
.   .   .   .   .   .   .   .   .   .ch: '\''y'\''
.   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .ch: '\''z'\''
.   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .val: "abcdxyz"
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
.   .hi [1,'\''i'\''] {
.   .   .ch: '\''h'\''
.   .   .eq [0] {
.   .   .   .val: "h"
.   .   .   .hi [1,'\''j'\''] {
.   .   .   .   .ch: '\''i'\''
.   .   .   .   .eq [1,'\''k'\''] {
.   .   .   .   .   .ch: '\''j'\''
.   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .ch: '\''k'\''
.   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .val: "hijk"
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
$ print a abcd abcdefg abcdxyz h hijk hlm|trie
[2,'\''h'\'']
[1,'\''b'\''] {
.   .ch: '\''a'\''
.   .eq [0] {
.   .   .val: "a"
.   .   .hi [1,'\''c'\''] {
.   .   .   .ch: '\''b'\''
.   .   .   .eq [1,'\''d'\''] {
.   .   .   .   .ch: '\''c'\''
.   .   .   .   .eq [2,'\''x'\''] {
.   .   .   .   .   .ch: '\''d'\''
.   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .val: "abcd"
.   .   .   .   .   .   .hi [1,'\''f'\''] {
.   .   .   .   .   .   .   .ch: '\''e'\''
.   .   .   .   .   .   .   .eq [1,'\''g'\''] {
.   .   .   .   .   .   .   .   .ch: '\''f'\''
.   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .ch: '\''g'\''
.   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .val: "abcdefg"
.   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .hi [1,'\''y'\''] {
.   .   .   .   .   .   .   .   .ch: '\''x'\''
.   .   .   .   .   .   .   .   .eq [1,'\''z'\''] {
.   .   .   .   .   .   .   .   .   .ch: '\''y'\''
.   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .ch: '\''z'\''
.   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .val: "abcdxyz"
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
.   .hi [2,'\''l'\''] {
.   .   .ch: '\''h'\''
.   .   .eq [0] {
.   .   .   .val: "h"
.   .   .   .hi [1,'\''j'\''] {
.   .   .   .   .ch: '\''i'\''
.   .   .   .   .eq [1,'\''k'\''] {
.   .   .   .   .   .ch: '\''j'\''
.   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .ch: '\''k'\''
.   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .val: "hijk"
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   .   .hi [1,'\''m'\''] {
.   .   .   .   .   .ch: '\''l'\''
.   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .ch: '\''m'\''
.   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .val: "hlm"
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}'
) -L print-obj-base-ternary.new <(
echo '$ print() { printf '\''%s\n'\'' "$@"; }'
print() { printf '%s\n' "$@"; } 2>&1 ||
echo 'command failed: print() { printf '\''%s\n'\'' "$@"; }'

echo '$ trie() { ../src/trie --output=object --attrs --dots --trie=ternary "$@"; }'
trie() { ../src/trie --output=object --attrs --dots --trie=ternary "$@"; } 2>&1 ||
echo 'command failed: trie() { ../src/trie --output=object --attrs --dots --trie=ternary "$@"; }'

echo '$ print|trie'
print|trie 2>&1 ||
echo 'command failed: print|trie'

echo '$ print a|trie'
print a|trie 2>&1 ||
echo 'command failed: print a|trie'

echo '$ print a b|trie'
print a b|trie 2>&1 ||
echo 'command failed: print a b|trie'

echo '$ print a b c|trie'
print a b c|trie 2>&1 ||
echo 'command failed: print a b c|trie'

echo '$ print a ab abc|trie'
print a ab abc|trie 2>&1 ||
echo 'command failed: print a ab abc|trie'

echo '$ print a ab ac|trie'
print a ab ac|trie 2>&1 ||
echo 'command failed: print a ab ac|trie'

echo '$ print a ab ac ad|trie'
print a ab ac ad|trie 2>&1 ||
echo 'command failed: print a ab ac ad|trie'

echo '$ print a abd ac|trie'
print a abd ac|trie 2>&1 ||
echo 'command failed: print a abd ac|trie'

echo '$ print a ab ac acd|trie'
print a ab ac acd|trie 2>&1 ||
echo 'command failed: print a ab ac acd|trie'

echo '$ print a bb ba ccc|trie'
print a bb ba ccc|trie 2>&1 ||
echo 'command failed: print a bb ba ccc|trie'

echo '$ print a bb ccc|trie'
print a bb ccc|trie 2>&1 ||
echo 'command failed: print a bb ccc|trie'

echo '$ print a bb ba ccc|trie'
print a bb ba ccc|trie 2>&1 ||
echo 'command failed: print a bb ba ccc|trie'

echo '$ print abc abd acde|trie'
print abc abd acde|trie 2>&1 ||
echo 'command failed: print abc abd acde|trie'

echo '$ print abc abd acde ac|trie'
print abc abd acde ac|trie 2>&1 ||
echo 'command failed: print abc abd acde ac|trie'

echo '$ print abc abd acde acfg|trie'
print abc abd acde acfg|trie 2>&1 ||
echo 'command failed: print abc abd acde acfg|trie'

echo '$ print cde cfg cfgx cfgxy cfgxyz cfgxzzz|trie'
print cde cfg cfgx cfgxy cfgxyz cfgxzzz|trie 2>&1 ||
echo 'command failed: print cde cfg cfgx cfgxy cfgxyz cfgxzzz|trie'

echo '$ print cge cfg cfgx cfgxy cfgxyz cfgxzzz|trie'
print cge cfg cfgx cfgxy cfgxyz cfgxzzz|trie 2>&1 ||
echo 'command failed: print cge cfg cfgx cfgxy cfgxyz cfgxzzz|trie'

echo '$ print a abcd abcdefg h hijk|trie'
print a abcd abcdefg h hijk|trie 2>&1 ||
echo 'command failed: print a abcd abcdefg h hijk|trie'

echo '$ print a abcd abcdefg abcdxyz h hijk|trie'
print a abcd abcdefg abcdxyz h hijk|trie 2>&1 ||
echo 'command failed: print a abcd abcdefg abcdxyz h hijk|trie'

echo '$ print a abcd abcdefg abcdxyz h hijk hlm|trie'
print a abcd abcdefg abcdxyz h hijk hlm|trie 2>&1 ||
echo 'command failed: print a abcd abcdefg abcdxyz h hijk hlm|trie'
)

