#!/bin/bash

# Copyright (C) 2016, 2018  Stefan Vargyas
# 
# This file is part of Trie-Gen.
# 
# Trie-Gen is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Trie-Gen is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Trie-Gen.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ gen-test -T gen-wide-c-code-base-array
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L gen-wide-c-code-base-array.old <(echo \
'$ print() { printf '\''%s\n'\'' "$@"; }
$ trie() { ../src/trie --gen=wide --output=c-code --attrs --dots --trie=array "$@"; }
$ print|trie
trie: error: tries cannot contain empty keys
command failed: print|trie
$ print a|trie
.   // [1,'\''a'\'']
.   // '\''a'\'' [0]
.   if (*p ++ == '\''a'\'') {
.   .   if (*p == 0)
.   .   .   return "a";
.   }
.   return error;
$ print a b|trie
.   // [2,'\''b'\'']
.   switch (*p ++) {
.   // '\''a'\'' [0]
.   case '\''a'\'':
.   .   if (*p == 0)
.   .   .   return "a";
.   .   return error;
.   // '\''b'\'' [0]
.   case '\''b'\'':
.   .   if (*p == 0)
.   .   .   return "b";
.   }
.   return error;
$ print a b c|trie
.   // [3,'\''c'\'']
.   switch (*p ++) {
.   // '\''a'\'' [0]
.   case '\''a'\'':
.   .   if (*p == 0)
.   .   .   return "a";
.   .   return error;
.   // '\''b'\'' [0]
.   case '\''b'\'':
.   .   if (*p == 0)
.   .   .   return "b";
.   .   return error;
.   // '\''c'\'' [0]
.   case '\''c'\'':
.   .   if (*p == 0)
.   .   .   return "c";
.   }
.   return error;
$ print a ab abc|trie
.   // [1,'\''a'\'']
.   // '\''a'\'' [1,'\''b'\'']
.   if (*p ++ == '\''a'\'') {
.   .   if (*p == 0)
.   .   .   return "a";
.   .   // '\''b'\'' [1,'\''c'\'']
.   .   if (*p ++ == '\''b'\'') {
.   .   .   if (*p == 0)
.   .   .   .   return "ab";
.   .   .   // '\''c'\'' [0]
.   .   .   if (*p ++ == '\''c'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "abc";
.   .   .   }
.   .   }
.   }
.   return error;
$ print a ab ac|trie
.   // [1,'\''a'\'']
.   // '\''a'\'' [2,'\''c'\'']
.   if (*p ++ == '\''a'\'') {
.   .   if (*p == 0)
.   .   .   return "a";
.   .   switch (*p ++) {
.   .   // '\''b'\'' [0]
.   .   case '\''b'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ab";
.   .   .   return error;
.   .   // '\''c'\'' [0]
.   .   case '\''c'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ac";
.   .   }
.   }
.   return error;
$ print a ab ac ad|trie
.   // [1,'\''a'\'']
.   // '\''a'\'' [3,'\''d'\'']
.   if (*p ++ == '\''a'\'') {
.   .   if (*p == 0)
.   .   .   return "a";
.   .   switch (*p ++) {
.   .   // '\''b'\'' [0]
.   .   case '\''b'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ab";
.   .   .   return error;
.   .   // '\''c'\'' [0]
.   .   case '\''c'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ac";
.   .   .   return error;
.   .   // '\''d'\'' [0]
.   .   case '\''d'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ad";
.   .   }
.   }
.   return error;
$ print a abd ac|trie
.   // [1,'\''a'\'']
.   // '\''a'\'' [2,'\''c'\'']
.   if (*p ++ == '\''a'\'') {
.   .   if (*p == 0)
.   .   .   return "a";
.   .   switch (*p ++) {
.   .   // '\''b'\'' [1,'\''d'\'']
.   .   case '\''b'\'':
.   .   .   // '\''d'\'' [0]
.   .   .   if (*p ++ == '\''d'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "abd";
.   .   .   }
.   .   .   return error;
.   .   // '\''c'\'' [0]
.   .   case '\''c'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ac";
.   .   }
.   }
.   return error;
$ print a ab ac acd|trie
.   // [1,'\''a'\'']
.   // '\''a'\'' [2,'\''c'\'']
.   if (*p ++ == '\''a'\'') {
.   .   if (*p == 0)
.   .   .   return "a";
.   .   switch (*p ++) {
.   .   // '\''b'\'' [0]
.   .   case '\''b'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ab";
.   .   .   return error;
.   .   // '\''c'\'' [1,'\''d'\'']
.   .   case '\''c'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ac";
.   .   .   // '\''d'\'' [0]
.   .   .   if (*p ++ == '\''d'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "acd";
.   .   .   }
.   .   }
.   }
.   return error;
$ print a bb ba ccc|trie
.   // [3,'\''c'\'']
.   switch (*p ++) {
.   // '\''a'\'' [0]
.   case '\''a'\'':
.   .   if (*p == 0)
.   .   .   return "a";
.   .   return error;
.   // '\''b'\'' [2,'\''b'\'']
.   case '\''b'\'':
.   .   switch (*p ++) {
.   .   // '\''a'\'' [0]
.   .   case '\''a'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ba";
.   .   .   return error;
.   .   // '\''b'\'' [0]
.   .   case '\''b'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "bb";
.   .   }
.   .   return error;
.   // '\''c'\'' [1,'\''c'\'']
.   case '\''c'\'':
.   .   // '\''c'\'' [1,'\''c'\'']
.   .   if (*p ++ == '\''c'\'') {
.   .   .   // '\''c'\'' [0]
.   .   .   if (*p ++ == '\''c'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "ccc";
.   .   .   }
.   .   }
.   }
.   return error;
$ print a bb ccc|trie
.   // [3,'\''c'\'']
.   switch (*p ++) {
.   // '\''a'\'' [0]
.   case '\''a'\'':
.   .   if (*p == 0)
.   .   .   return "a";
.   .   return error;
.   // '\''b'\'' [1,'\''b'\'']
.   case '\''b'\'':
.   .   // '\''b'\'' [0]
.   .   if (*p ++ == '\''b'\'') {
.   .   .   if (*p == 0)
.   .   .   .   return "bb";
.   .   }
.   .   return error;
.   // '\''c'\'' [1,'\''c'\'']
.   case '\''c'\'':
.   .   // '\''c'\'' [1,'\''c'\'']
.   .   if (*p ++ == '\''c'\'') {
.   .   .   // '\''c'\'' [0]
.   .   .   if (*p ++ == '\''c'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "ccc";
.   .   .   }
.   .   }
.   }
.   return error;
$ print a bb ba ccc|trie
.   // [3,'\''c'\'']
.   switch (*p ++) {
.   // '\''a'\'' [0]
.   case '\''a'\'':
.   .   if (*p == 0)
.   .   .   return "a";
.   .   return error;
.   // '\''b'\'' [2,'\''b'\'']
.   case '\''b'\'':
.   .   switch (*p ++) {
.   .   // '\''a'\'' [0]
.   .   case '\''a'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ba";
.   .   .   return error;
.   .   // '\''b'\'' [0]
.   .   case '\''b'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "bb";
.   .   }
.   .   return error;
.   // '\''c'\'' [1,'\''c'\'']
.   case '\''c'\'':
.   .   // '\''c'\'' [1,'\''c'\'']
.   .   if (*p ++ == '\''c'\'') {
.   .   .   // '\''c'\'' [0]
.   .   .   if (*p ++ == '\''c'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "ccc";
.   .   .   }
.   .   }
.   }
.   return error;
$ print abc abd acde|trie
.   // [1,'\''a'\'']
.   // '\''a'\'' [2,'\''c'\'']
.   if (*p ++ == '\''a'\'') {
.   .   switch (*p ++) {
.   .   // '\''b'\'' [2,'\''d'\'']
.   .   case '\''b'\'':
.   .   .   switch (*p ++) {
.   .   .   // '\''c'\'' [0]
.   .   .   case '\''c'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "abc";
.   .   .   .   return error;
.   .   .   // '\''d'\'' [0]
.   .   .   case '\''d'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "abd";
.   .   .   }
.   .   .   return error;
.   .   // '\''c'\'' [1,'\''d'\'']
.   .   case '\''c'\'':
.   .   .   // '\''d'\'' [1,'\''e'\'']
.   .   .   if (*p ++ == '\''d'\'') {
.   .   .   .   // '\''e'\'' [0]
.   .   .   .   if (*p ++ == '\''e'\'') {
.   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   return "acde";
.   .   .   .   }
.   .   .   }
.   .   }
.   }
.   return error;
$ print abc abd acde ac|trie
.   // [1,'\''a'\'']
.   // '\''a'\'' [2,'\''c'\'']
.   if (*p ++ == '\''a'\'') {
.   .   switch (*p ++) {
.   .   // '\''b'\'' [2,'\''d'\'']
.   .   case '\''b'\'':
.   .   .   switch (*p ++) {
.   .   .   // '\''c'\'' [0]
.   .   .   case '\''c'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "abc";
.   .   .   .   return error;
.   .   .   // '\''d'\'' [0]
.   .   .   case '\''d'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "abd";
.   .   .   }
.   .   .   return error;
.   .   // '\''c'\'' [1,'\''d'\'']
.   .   case '\''c'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ac";
.   .   .   // '\''d'\'' [1,'\''e'\'']
.   .   .   if (*p ++ == '\''d'\'') {
.   .   .   .   // '\''e'\'' [0]
.   .   .   .   if (*p ++ == '\''e'\'') {
.   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   return "acde";
.   .   .   .   }
.   .   .   }
.   .   }
.   }
.   return error;
$ print abc abd acde acfg|trie
.   // [1,'\''a'\'']
.   // '\''a'\'' [2,'\''c'\'']
.   if (*p ++ == '\''a'\'') {
.   .   switch (*p ++) {
.   .   // '\''b'\'' [2,'\''d'\'']
.   .   case '\''b'\'':
.   .   .   switch (*p ++) {
.   .   .   // '\''c'\'' [0]
.   .   .   case '\''c'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "abc";
.   .   .   .   return error;
.   .   .   // '\''d'\'' [0]
.   .   .   case '\''d'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "abd";
.   .   .   }
.   .   .   return error;
.   .   // '\''c'\'' [2,'\''f'\'']
.   .   case '\''c'\'':
.   .   .   switch (*p ++) {
.   .   .   // '\''d'\'' [1,'\''e'\'']
.   .   .   case '\''d'\'':
.   .   .   .   // '\''e'\'' [0]
.   .   .   .   if (*p ++ == '\''e'\'') {
.   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   return "acde";
.   .   .   .   }
.   .   .   .   return error;
.   .   .   // '\''f'\'' [1,'\''g'\'']
.   .   .   case '\''f'\'':
.   .   .   .   // '\''g'\'' [0]
.   .   .   .   if (*p ++ == '\''g'\'') {
.   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   return "acfg";
.   .   .   .   }
.   .   .   }
.   .   }
.   }
.   return error;
$ print cde cfg cfgx cfgxy cfgxyz cfgxzzz|trie
.   // [1,'\''c'\'']
.   // '\''c'\'' [2,'\''f'\'']
.   if (*p ++ == '\''c'\'') {
.   .   switch (*p ++) {
.   .   // '\''d'\'' [1,'\''e'\'']
.   .   case '\''d'\'':
.   .   .   // '\''e'\'' [0]
.   .   .   if (*p ++ == '\''e'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "cde";
.   .   .   }
.   .   .   return error;
.   .   // '\''f'\'' [1,'\''g'\'']
.   .   case '\''f'\'':
.   .   .   // '\''g'\'' [1,'\''x'\'']
.   .   .   if (*p ++ == '\''g'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "cfg";
.   .   .   .   // '\''x'\'' [2,'\''z'\'']
.   .   .   .   if (*p ++ == '\''x'\'') {
.   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   return "cfgx";
.   .   .   .   .   switch (*p ++) {
.   .   .   .   .   // '\''y'\'' [1,'\''z'\'']
.   .   .   .   .   case '\''y'\'':
.   .   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   .   return "cfgxy";
.   .   .   .   .   .   // '\''z'\'' [0]
.   .   .   .   .   .   if (*p ++ == '\''z'\'') {
.   .   .   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   .   .   return "cfgxyz";
.   .   .   .   .   .   }
.   .   .   .   .   .   return error;
.   .   .   .   .   // '\''z'\'' [1,'\''z'\'']
.   .   .   .   .   case '\''z'\'':
.   .   .   .   .   .   // '\''z'\'' [1,'\''z'\'']
.   .   .   .   .   .   if (*p ++ == '\''z'\'') {
.   .   .   .   .   .   .   // '\''z'\'' [0]
.   .   .   .   .   .   .   if (*p ++ == '\''z'\'') {
.   .   .   .   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   .   .   .   return "cfgxzzz";
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
.   return error;
$ print cge cfg cfgx cfgxy cfgxyz cfgxzzz|trie
.   // [1,'\''c'\'']
.   // '\''c'\'' [2,'\''g'\'']
.   if (*p ++ == '\''c'\'') {
.   .   switch (*p ++) {
.   .   // '\''f'\'' [1,'\''g'\'']
.   .   case '\''f'\'':
.   .   .   // '\''g'\'' [1,'\''x'\'']
.   .   .   if (*p ++ == '\''g'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "cfg";
.   .   .   .   // '\''x'\'' [2,'\''z'\'']
.   .   .   .   if (*p ++ == '\''x'\'') {
.   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   return "cfgx";
.   .   .   .   .   switch (*p ++) {
.   .   .   .   .   // '\''y'\'' [1,'\''z'\'']
.   .   .   .   .   case '\''y'\'':
.   .   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   .   return "cfgxy";
.   .   .   .   .   .   // '\''z'\'' [0]
.   .   .   .   .   .   if (*p ++ == '\''z'\'') {
.   .   .   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   .   .   return "cfgxyz";
.   .   .   .   .   .   }
.   .   .   .   .   .   return error;
.   .   .   .   .   // '\''z'\'' [1,'\''z'\'']
.   .   .   .   .   case '\''z'\'':
.   .   .   .   .   .   // '\''z'\'' [1,'\''z'\'']
.   .   .   .   .   .   if (*p ++ == '\''z'\'') {
.   .   .   .   .   .   .   // '\''z'\'' [0]
.   .   .   .   .   .   .   if (*p ++ == '\''z'\'') {
.   .   .   .   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   .   .   .   return "cfgxzzz";
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   .   return error;
.   .   // '\''g'\'' [1,'\''e'\'']
.   .   case '\''g'\'':
.   .   .   // '\''e'\'' [0]
.   .   .   if (*p ++ == '\''e'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "cge";
.   .   .   }
.   .   }
.   }
.   return error;
$ print a abcd abcdefg h hijk|trie
.   // [2,'\''h'\'']
.   switch (*p ++) {
.   // '\''a'\'' [1,'\''b'\'']
.   case '\''a'\'':
.   .   if (*p == 0)
.   .   .   return "a";
.   .   // '\''b'\'' [1,'\''c'\'']
.   .   if (*p ++ == '\''b'\'') {
.   .   .   // '\''c'\'' [1,'\''d'\'']
.   .   .   if (*p ++ == '\''c'\'') {
.   .   .   .   // '\''d'\'' [1,'\''e'\'']
.   .   .   .   if (*p ++ == '\''d'\'') {
.   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   return "abcd";
.   .   .   .   .   // '\''e'\'' [1,'\''f'\'']
.   .   .   .   .   if (*p ++ == '\''e'\'') {
.   .   .   .   .   .   // '\''f'\'' [1,'\''g'\'']
.   .   .   .   .   .   if (*p ++ == '\''f'\'') {
.   .   .   .   .   .   .   // '\''g'\'' [0]
.   .   .   .   .   .   .   if (*p ++ == '\''g'\'') {
.   .   .   .   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   .   .   .   return "abcdefg";
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   .   return error;
.   // '\''h'\'' [1,'\''i'\'']
.   case '\''h'\'':
.   .   if (*p == 0)
.   .   .   return "h";
.   .   // '\''i'\'' [1,'\''j'\'']
.   .   if (*p ++ == '\''i'\'') {
.   .   .   // '\''j'\'' [1,'\''k'\'']
.   .   .   if (*p ++ == '\''j'\'') {
.   .   .   .   // '\''k'\'' [0]
.   .   .   .   if (*p ++ == '\''k'\'') {
.   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   return "hijk";
.   .   .   .   }
.   .   .   }
.   .   }
.   }
.   return error;
$ print a abcd abcdefg abcdxyz h hijk|trie
.   // [2,'\''h'\'']
.   switch (*p ++) {
.   // '\''a'\'' [1,'\''b'\'']
.   case '\''a'\'':
.   .   if (*p == 0)
.   .   .   return "a";
.   .   // '\''b'\'' [1,'\''c'\'']
.   .   if (*p ++ == '\''b'\'') {
.   .   .   // '\''c'\'' [1,'\''d'\'']
.   .   .   if (*p ++ == '\''c'\'') {
.   .   .   .   // '\''d'\'' [2,'\''x'\'']
.   .   .   .   if (*p ++ == '\''d'\'') {
.   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   return "abcd";
.   .   .   .   .   switch (*p ++) {
.   .   .   .   .   // '\''e'\'' [1,'\''f'\'']
.   .   .   .   .   case '\''e'\'':
.   .   .   .   .   .   // '\''f'\'' [1,'\''g'\'']
.   .   .   .   .   .   if (*p ++ == '\''f'\'') {
.   .   .   .   .   .   .   // '\''g'\'' [0]
.   .   .   .   .   .   .   if (*p ++ == '\''g'\'') {
.   .   .   .   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   .   .   .   return "abcdefg";
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   .   return error;
.   .   .   .   .   // '\''x'\'' [1,'\''y'\'']
.   .   .   .   .   case '\''x'\'':
.   .   .   .   .   .   // '\''y'\'' [1,'\''z'\'']
.   .   .   .   .   .   if (*p ++ == '\''y'\'') {
.   .   .   .   .   .   .   // '\''z'\'' [0]
.   .   .   .   .   .   .   if (*p ++ == '\''z'\'') {
.   .   .   .   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   .   .   .   return "abcdxyz";
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   .   return error;
.   // '\''h'\'' [1,'\''i'\'']
.   case '\''h'\'':
.   .   if (*p == 0)
.   .   .   return "h";
.   .   // '\''i'\'' [1,'\''j'\'']
.   .   if (*p ++ == '\''i'\'') {
.   .   .   // '\''j'\'' [1,'\''k'\'']
.   .   .   if (*p ++ == '\''j'\'') {
.   .   .   .   // '\''k'\'' [0]
.   .   .   .   if (*p ++ == '\''k'\'') {
.   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   return "hijk";
.   .   .   .   }
.   .   .   }
.   .   }
.   }
.   return error;
$ print a abcd abcdefg abcdxyz h hijk hlm|trie
.   // [2,'\''h'\'']
.   switch (*p ++) {
.   // '\''a'\'' [1,'\''b'\'']
.   case '\''a'\'':
.   .   if (*p == 0)
.   .   .   return "a";
.   .   // '\''b'\'' [1,'\''c'\'']
.   .   if (*p ++ == '\''b'\'') {
.   .   .   // '\''c'\'' [1,'\''d'\'']
.   .   .   if (*p ++ == '\''c'\'') {
.   .   .   .   // '\''d'\'' [2,'\''x'\'']
.   .   .   .   if (*p ++ == '\''d'\'') {
.   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   return "abcd";
.   .   .   .   .   switch (*p ++) {
.   .   .   .   .   // '\''e'\'' [1,'\''f'\'']
.   .   .   .   .   case '\''e'\'':
.   .   .   .   .   .   // '\''f'\'' [1,'\''g'\'']
.   .   .   .   .   .   if (*p ++ == '\''f'\'') {
.   .   .   .   .   .   .   // '\''g'\'' [0]
.   .   .   .   .   .   .   if (*p ++ == '\''g'\'') {
.   .   .   .   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   .   .   .   return "abcdefg";
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   .   return error;
.   .   .   .   .   // '\''x'\'' [1,'\''y'\'']
.   .   .   .   .   case '\''x'\'':
.   .   .   .   .   .   // '\''y'\'' [1,'\''z'\'']
.   .   .   .   .   .   if (*p ++ == '\''y'\'') {
.   .   .   .   .   .   .   // '\''z'\'' [0]
.   .   .   .   .   .   .   if (*p ++ == '\''z'\'') {
.   .   .   .   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   .   .   .   return "abcdxyz";
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   .   return error;
.   // '\''h'\'' [2,'\''l'\'']
.   case '\''h'\'':
.   .   if (*p == 0)
.   .   .   return "h";
.   .   switch (*p ++) {
.   .   // '\''i'\'' [1,'\''j'\'']
.   .   case '\''i'\'':
.   .   .   // '\''j'\'' [1,'\''k'\'']
.   .   .   if (*p ++ == '\''j'\'') {
.   .   .   .   // '\''k'\'' [0]
.   .   .   .   if (*p ++ == '\''k'\'') {
.   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   return "hijk";
.   .   .   .   }
.   .   .   }
.   .   .   return error;
.   .   // '\''l'\'' [1,'\''m'\'']
.   .   case '\''l'\'':
.   .   .   // '\''m'\'' [0]
.   .   .   if (*p ++ == '\''m'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "hlm";
.   .   .   }
.   .   }
.   }
.   return error;'
) -L gen-wide-c-code-base-array.new <(
echo '$ print() { printf '\''%s\n'\'' "$@"; }'
print() { printf '%s\n' "$@"; } 2>&1 ||
echo 'command failed: print() { printf '\''%s\n'\'' "$@"; }'

echo '$ trie() { ../src/trie --gen=wide --output=c-code --attrs --dots --trie=array "$@"; }'
trie() { ../src/trie --gen=wide --output=c-code --attrs --dots --trie=array "$@"; } 2>&1 ||
echo 'command failed: trie() { ../src/trie --gen=wide --output=c-code --attrs --dots --trie=array "$@"; }'

echo '$ print|trie'
print|trie 2>&1 ||
echo 'command failed: print|trie'

echo '$ print a|trie'
print a|trie 2>&1 ||
echo 'command failed: print a|trie'

echo '$ print a b|trie'
print a b|trie 2>&1 ||
echo 'command failed: print a b|trie'

echo '$ print a b c|trie'
print a b c|trie 2>&1 ||
echo 'command failed: print a b c|trie'

echo '$ print a ab abc|trie'
print a ab abc|trie 2>&1 ||
echo 'command failed: print a ab abc|trie'

echo '$ print a ab ac|trie'
print a ab ac|trie 2>&1 ||
echo 'command failed: print a ab ac|trie'

echo '$ print a ab ac ad|trie'
print a ab ac ad|trie 2>&1 ||
echo 'command failed: print a ab ac ad|trie'

echo '$ print a abd ac|trie'
print a abd ac|trie 2>&1 ||
echo 'command failed: print a abd ac|trie'

echo '$ print a ab ac acd|trie'
print a ab ac acd|trie 2>&1 ||
echo 'command failed: print a ab ac acd|trie'

echo '$ print a bb ba ccc|trie'
print a bb ba ccc|trie 2>&1 ||
echo 'command failed: print a bb ba ccc|trie'

echo '$ print a bb ccc|trie'
print a bb ccc|trie 2>&1 ||
echo 'command failed: print a bb ccc|trie'

echo '$ print a bb ba ccc|trie'
print a bb ba ccc|trie 2>&1 ||
echo 'command failed: print a bb ba ccc|trie'

echo '$ print abc abd acde|trie'
print abc abd acde|trie 2>&1 ||
echo 'command failed: print abc abd acde|trie'

echo '$ print abc abd acde ac|trie'
print abc abd acde ac|trie 2>&1 ||
echo 'command failed: print abc abd acde ac|trie'

echo '$ print abc abd acde acfg|trie'
print abc abd acde acfg|trie 2>&1 ||
echo 'command failed: print abc abd acde acfg|trie'

echo '$ print cde cfg cfgx cfgxy cfgxyz cfgxzzz|trie'
print cde cfg cfgx cfgxy cfgxyz cfgxzzz|trie 2>&1 ||
echo 'command failed: print cde cfg cfgx cfgxy cfgxyz cfgxzzz|trie'

echo '$ print cge cfg cfgx cfgxy cfgxyz cfgxzzz|trie'
print cge cfg cfgx cfgxy cfgxyz cfgxzzz|trie 2>&1 ||
echo 'command failed: print cge cfg cfgx cfgxy cfgxyz cfgxzzz|trie'

echo '$ print a abcd abcdefg h hijk|trie'
print a abcd abcdefg h hijk|trie 2>&1 ||
echo 'command failed: print a abcd abcdefg h hijk|trie'

echo '$ print a abcd abcdefg abcdxyz h hijk|trie'
print a abcd abcdefg abcdxyz h hijk|trie 2>&1 ||
echo 'command failed: print a abcd abcdefg abcdxyz h hijk|trie'

echo '$ print a abcd abcdefg abcdxyz h hijk hlm|trie'
print a abcd abcdefg abcdxyz h hijk hlm|trie 2>&1 ||
echo 'command failed: print a abcd abcdefg abcdxyz h hijk hlm|trie'
)

