#!/bin/bash

# Copyright (C) 2016, 2018  Stefan Vargyas
# 
# This file is part of Trie-Gen.
# 
# Trie-Gen is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Trie-Gen is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Trie-Gen.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ gen-test -T bugs
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L bugs.old <(echo \
'$ print() { printf '\''%s\n'\'' "$@"; }
$ print aef ae abg a abc ab abd|../src/trie -gc -ot -ti
{
    "a": 4 {
        "b": 6 {
            "c": 5
            "d": 7
            "g": 3
        }
        "e": 2 {
            "f": 1
        }
    }
}
$ print abg a abc ab abd|../src/trie -gc -ot -ti
{
    "a": 2 {
        "b": 4 {
            "c": 3
            "d": 5
            "g": 1
        }
    }
}
$ print $'\''\x80'\''|../src/trie -gc -oc -Ta
    if (*p ++ == '\''\x80'\'' &&
        *p == 0)
        return "\x80";
    return error;
$ print $'\''\x80'\''|../src/trie -gc -oc -Tt
    if (*p ++ == '\''\x80'\'' &&
        *p == 0)
        return "\x80";
    return error;
$ print $'\''\x80'\''|../src/trie -gw -oc -Ta
    if (*p ++ == '\''\x80'\'') {
        if (*p == 0)
            return "\x80";
    }
    return error;
$ print $'\''\x80'\''|../src/trie -gw -oc -Tt
    if (*p ++ == '\''\x80'\'') {
        if (*p == 0)
            return "\x80";
    }
    return error;'
) -L bugs.new <(
echo '$ print() { printf '\''%s\n'\'' "$@"; }'
print() { printf '%s\n' "$@"; } 2>&1 ||
echo 'command failed: print() { printf '\''%s\n'\'' "$@"; }'

echo '$ print aef ae abg a abc ab abd|../src/trie -gc -ot -ti'
print aef ae abg a abc ab abd|../src/trie -gc -ot -ti 2>&1 ||
echo 'command failed: print aef ae abg a abc ab abd|../src/trie -gc -ot -ti'

echo '$ print abg a abc ab abd|../src/trie -gc -ot -ti'
print abg a abc ab abd|../src/trie -gc -ot -ti 2>&1 ||
echo 'command failed: print abg a abc ab abd|../src/trie -gc -ot -ti'

echo '$ print $'\''\x80'\''|../src/trie -gc -oc -Ta'
print $'\x80'|../src/trie -gc -oc -Ta 2>&1 ||
echo 'command failed: print $'\''\x80'\''|../src/trie -gc -oc -Ta'

echo '$ print $'\''\x80'\''|../src/trie -gc -oc -Tt'
print $'\x80'|../src/trie -gc -oc -Tt 2>&1 ||
echo 'command failed: print $'\''\x80'\''|../src/trie -gc -oc -Tt'

echo '$ print $'\''\x80'\''|../src/trie -gw -oc -Ta'
print $'\x80'|../src/trie -gw -oc -Ta 2>&1 ||
echo 'command failed: print $'\''\x80'\''|../src/trie -gw -oc -Ta'

echo '$ print $'\''\x80'\''|../src/trie -gw -oc -Tt'
print $'\x80'|../src/trie -gw -oc -Tt 2>&1 ||
echo 'command failed: print $'\''\x80'\''|../src/trie -gw -oc -Tt'
)

