/*
 * util.h:
 * Global utility stuff for tpop3d
 *
 * Copyright (c) 2001 Chris Lightfoot. All rights reserved.
 *
 * $Id: util.h,v 1.12 2001/04/24 14:25:34 chris Exp $
 *
 */

#ifndef __UTIL_H_ /* include guard */
#define __UTIL_H_

#ifdef HAVE_CONFIG_H
#include "configuration.h"
#endif /* HAVE_CONFIG_H */

#include <sys/types.h>

#ifndef TPOP3D_VERSION
#   define TPOP3D_VERSION   "(unknown)"
#endif

#define PAGESIZE        getpagesize()

/* Function for substituting $(...) in strings. */
struct sverr {
    char *msg;
    off_t offset;
};

char *substitute_variables(const char *spec, struct sverr *err, const int nvars, ...);

/* Replacement logging function. */
void print_log(int priority, const char *fmt, ...);

/* Restarting write(2). */
ssize_t xwrite(int fd, const void *buf, size_t count);
#define try_write(a, b, c)      (xwrite((a), (b), (c)) == (c))

/* Become a daemon. */
int daemon(int nochdir, int noclose);

int write_file(int fd, int sck, size_t msgoffset, size_t skip, size_t msglength, int n);

/* Look up group or user ids. */
int parse_uid(const char *user, uid_t *u);
gid_t parse_gid(const char *group, gid_t *g);

/* Some systems do not have inet_aton. */
#ifndef HAVE_INET_ATON
int inet_aton(const char *s, struct in_addr *ip);
#endif /* HAVE_INET_ATON */

/* We use strtok_r, but not all systems have it. */
#ifndef HAVE_STRTOK_R
char *strtok_r(char *s, const char *delim, char **saveptr);     /* GNU implementation in strtok_r.c */
#endif

/* Optional internationalisation support. */
#ifdef WITH_I18N
#   include <gettext.h>
#   define _(String) gettext(String)
#else
#   define _(String) String
#endif /* WITH_I18N */

#endif /* __UTIL_H_ */
