/* tpb - program to use the IBM ThinkPad(tm) special keys
 * Copyright (C) 2002 Markus Braun <markus.braun@krawel.de>
 *
 * This file is part of tpb.
 *
 * tpb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * tpb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with tpb; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __CFG_H__
#define __CFG_H__

#if ENABLE_NLS
#include <libintl.h>
#define _(String) gettext (String)
#else
#define _(String) (String)
#endif

enum state {UNDEFINED = -1, STATE_OFF, STATE_ON, STATE_AUTO};
enum mode {MODE_COMMENT, MODE_INDENT, MODE_KEYWORD, MODE_SEPARATOR, MODE_ARGUMENT, MODE_END};

/* configuration defaults */
#define DEFAULT_APM STATE_OFF
#define DEFAULT_POWERMGT STATE_AUTO
#define DEFAULT_VERBOSE STATE_OFF
#define DEFAULT_POLLTIME 1000
#define DEFAULT_NVRAMDEV "/dev/nvram"
#define DEFAULT_MIXER STATE_OFF
#define DEFAULT_MIXERSTEPS 14
#define DEFAULT_MIXERDEV "/dev/mixer"
#ifdef HAVE_LIBXOSD
#define DEFAULT_OSD STATE_ON
#define DEFAULT_OSDLINES 2
#define DEFAULT_OSDFONT "10x20"
#define DEFAULT_OSDCOLOR "BLUE"
#define DEFAULT_OSDTIMEOUT 3
#define DEFAULT_OSDSHADOW 2
#define DEFAULT_OSDVERTICAL 25
#define DEFAULT_OSDHORIZONTAL 25
#define DEFAULT_OSDPOS XOSD_bottom
#define DEFAULT_OSDALIGN XOSD_left
#endif /* HAVE_LIBXOSD */

/* configuration files */
#ifdef SYSCONFDIR
#define GLOBAL_CONFIG_FILE SYSCONFDIR "/tpbrc"
#else
#define GLOBAL_CONFIG_FILE "/etc/tpbrc"
#endif
#define PRIVATE_CONFIG_FILE ".tpbrc"

/* Keywords in configuration file */
#define CFG_APM "apm"
#define CFG_APM_ON "on"
#define CFG_APM_OFF "off"
#define CFG_POWERMGT "powermgt"
#define CFG_POWERMGT_ON "on"
#define CFG_POWERMGT_OFF "off"
#define CFG_POWERMGT_AUTO "auto"
#define CFG_NVRAM "nvram"
#define CFG_POLLTIME "polltime"
#define CFG_THINKPAD "thinkpad"
#define CFG_HOME "home"
#define CFG_SEARCH "search"
#define CFG_MAIL "mail"
#define CFG_CALLBACK "callback"
#define CFG_MIXER "mixer"
#define CFG_MIXER_ON "on"
#define CFG_MIXER_OFF "off"
#define CFG_MIXERSTEPS "mixersteps"
#define CFG_MIXERDEV "mixerdevice"
#ifdef HAVE_LIBXOSD
#define CFG_OSDFONT "osdfont"
#define CFG_OSDCOLOR "osdcolor"
#define CFG_OSDTIMEOUT "osdtimeout"
#define CFG_OSDOFFSET "osdoffset"
#define CFG_OSDSHADOW "osdshadow"
#define CFG_OSDVERTICAL "osdvertical"
#define CFG_OSDHORIZONTAL "osdhorizontal"
#define CFG_OSDPOS "osdpos"
#define CFG_OSDPOS_TOP "top"
#define CFG_OSDPOS_MIDDLE "middle"
#define CFG_OSDPOS_BOTTOM "bottom"
#define CFG_OSDALIGN "osdalign"
#define CFG_OSDALIGN_LEFT "left"
#define CFG_OSDALIGN_CENTER "center"
#define CFG_OSDALIGN_RIGHT "right"
#define CFG_OSD "osd"
#define CFG_OSD_ON "on"
#define CFG_OSD_OFF "off"
#endif /* HAVE_LIBXOSD */

#define BUFFER_SIZE 256

typedef struct {
	int daemon;
	int apm;
	int powermgt;
	char *nvram;
	int polltime;
	char *tpbcmd;
	char *homecmd;
	char *searchcmd;
	char *mailcmd;
	char *callback;
	int mixer;
	int mixersteps;
	char *mixerdev;
	int verbose;
#ifdef HAVE_LIBXOSD
	int osd;
	char *osdfont;
	char *osdcolor;
	int osdtimeout;
	int osdshadow;
	int osdvertical;
	int osdhorizontal;
	xosd_pos osdpos;
#ifndef HAVE_LIBXOSD0
	xosd_align osdalign;
#endif /* HAVE_LIBXOSD0 */
#endif /* HAVE_LIBXOSD */
} config;

int parse_cfg_file(char *name);
void init_cfg(void);
void clear_cfg(config *cfg);
void override_cfg(config *master);
void set_value(char *key, char *arg, config *cfg);
void parse_option(int argc, char **argv);
void print_usage(const char *prog);

#endif /* __CFG_H__ */

/* vim:set sw=2:set ts=2: */
/* vim600:set fen:set fdm=marker:set fdl=0: */
