dnl-----------------------------------------------------------------------
dnl Checks for LIBXOSD (>= 1.0.0)
dnl-----------------------------------------------------------------------
AC_DEFUN(AM_CHECK_LIBXOSD,
[
    if test ! x$xosd_libdir = x; then
        LIBS="$LIBS -L$xosd_libdir"
    fi
    if test ! x$xosd_incdir = x; then
        CPPFLAGS="$CPPFLAGS -I$xosd_incdir"
    fi

    if test "x$enable_xosd" = "xyes"
    then
        dnl
        dnl Check its version
        dnl
        AC_MSG_CHECKING(for version of libxosd)
        LIBS="-lxosd $LIBS"
				dnl Check for version >= 0.7.0 and < 1.0.0
        AC_TRY_LINK(
					[
						#include <xosd.h>
					],
					[
						void test()
						{
							xosd* t = xosd_init("font", "colour", 0, XOSD_top, 0, 0);
						}
					],
					[
						AC_MSG_RESULT([>= 0.7.0, ok])
						AC_DEFINE(HAVE_LIBXOSD0)
						CFLAGS="$CFLAGS $LIBXOSD_CFLAGS"
						LIBS="$LIBS $LIBXOSD_LIBS"
					],
					[
						dnl Check for version >= 2.0.0
						dnl first 2.0.0, because 2.0.0 has the same xosd_init as 1.x.x
						AC_TRY_LINK(                                                        
							[                                                                 
								#include <xosd.h>                                               
							],                                                                
							[                                                                 
								void test()                                                     
								{                                                               
									xosd* t = xosd_create(0);  
								}                                                               
							],                                                                
							[                                                                 
								AC_MSG_RESULT([>= 2.0.0, ok])                                   
								AC_DEFINE(HAVE_LIBXOSD2)                                         
								CFLAGS="$CFLAGS $LIBXOSD_CFLAGS"                                
								LIBS="$LIBS $LIBXOSD_LIBS"                                      
							],                                                                
							[                                                                 
								dnl Check for version >= 1.0.0 and < 2.0.0
								AC_TRY_LINK(                                                        
									[                                                                 
										#include <xosd.h>                                               
									],                                                                
									[                                                                 
										void test()                                                     
										{                                                               
											xosd* t = xosd_init("font", "colour", 0, XOSD_top, 0, 0, 0);  
										}                                                               
									],                                                                
									[                                                                 
										AC_MSG_RESULT([>= 1.0.0, ok])                                   
										AC_DEFINE(HAVE_LIBXOSD1)                                         
										CFLAGS="$CFLAGS $LIBXOSD_CFLAGS"                                
										LIBS="$LIBS $LIBXOSD_LIBS"                                      
									],                                                                
									[                                                                 
										AC_MSG_RESULT([< 0.7.0, failed])                                
										echo "*** The version of XOSD library installed is not 0.7.0 or"
										echo "*** above, make sure the correct version is installed."   
										exit 1                                                          
									]                                                                 
								 )                                                                   
							]                                                                 
						 )                                                                   
					]
        )
    fi
])
