/* tpb - program to use the IBM ThinkPad(tm) special keys
 * Copyright (C) 2002 Markus Braun <markus.braun@krawel.de>
 *
 * This file is part of tpb.
 *
 * tpb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * tpb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with tpb; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __TPB_H__
#define __TPB_H__

#define MAXVOLUME 100
#define CALLBACKCMDLENGTH 256

typedef struct {
	char thinkpad_toggle;   /* ThinkPad button */
	char zoom_toggle;       /* zoom toggle */
	char display_toggle;    /* display toggle */
	char home_toggle;       /* Home button */
	char search_toggle;     /* Search button */
	char mail_toggle;       /* Mail button */
	char thinklight_toggle; /* ThinkLight */
	char hibernate_toggle;  /* hibernation/suspend toggle */
	char display_state;     /* display state */
	char expand_toggle;     /* hv expansion state */
	char brightness_level;  /* brightness level */
	char brightness_toggle; /* brightness toggle */
	char volume_level;      /* volume level */
	char volume_toggle;     /* volume toggle */
	char mute_toggle;       /* mute toggle */
	char ac_state;          /* ac connected */
	char powermgt_ac;       /* power management mode ac */
	char powermgt_battery;  /* power management mode battery */
} t_nvram_state;

int get_state(t_nvram_state *nvram_state);
int fork_app(char *cmd);
void set_vl(void);
int set_mixer(int change);

#endif /* __TPB_H__*/

/* vim:set sw=2:set ts=2: */
/* vim600:set fen:set fdm=marker:set fdl=0: */
