/* tpb - program to use the IBM ThinkPad(tm) special keys
 * Copyright (C) 2002 Markus Braun <markus.braun@krawel.de>
 *
 * This file is part of tpb.
 *
 * tpb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * tpb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with tpb; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __TPB_H__
#define __TPB_H__

typedef struct {
	char tpb; /* ThinkPad button */
	char kt;  /* ThinkLight */
	char ht;  /* hibernation/suspend toggle */
	char ds;  /* display state */
	char bl;  /* brightness level */
	char bt;  /* brightness toggle */
	char vl;  /* volume level */
	char vt;  /* volume toggle */
	char mt;  /* mute toggle */
	char ac;  /* ac connected */
	char pma; /* power management mode ac */
	char pmb; /* power management mode battery */
} t_tpb;

int get_state(t_tpb *tpbs);
int fork_app(char *cmd);

#endif /* __TPB_H__*/

/* vim:set sw=2:set ts=2: */
/* vim600:set fen:set fdm=marker:set fdl=0: */
