/* tpb - program to use the IBM ThinkPad (tm) special keys
 * Copyright (C) 2002 Markus Braun <markus.braun@krawel.de>
 *
 * This file is part of tpb.
 *
 * tpb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * tpb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with tpb; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#define POLLTIME 1000

typedef struct {
	char tpb; /* ThinkPad Button */
	char kl;  /* KeyboardLight */
	char ds;  /* Display State */
	char bl;  /* Brightness Level */
	char vl;  /* Volume Level */
	char ms;  /* Mute State */
} t_tpb;

void print_usage(const char *prog);
int get_state(t_tpb *tpbs);
