// Sphere.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// A spherical solid

#ifndef TOVERO_MATH_SPHERE_HPP_
#define TOVERO_MATH_SPHERE_HPP_

#include <tovero/math/geometry/Ellipsoid_base.hpp>
#include <tovero/math/geometry/Distance.hpp>
#include <tovero/math/geometry/Point.hpp>
#include <tovero/math/geometry/Vector.hpp>
#include <string>

namespace Roan_trail
{
  namespace Tovero_support
  {
    class Error_param;
  }

  namespace Tovero_math
  {
    class Ellipsoid;

    class Sphere : public Ellipsoid_base
    {
    public:
      // constructor/copy
      //   defaults to a sphere of radius 1.0 centered at the origin
      Sphere(const std::string& name = "");
      Sphere(const Point& center,
             const Distance& radius,
             const std::string& name = "");
      virtual Solid* clone_solid() const { return new Sphere(*this); }
      //   Note: let compiler generate copy constructor and operator=
      // accessors/mutators
      const Point& center() const { return m_center; }
      void set_center(const Point& center) { m_center = center; }
      const Distance& radius() const { return m_radius; }
      void set_radius(const Distance& radius) { m_radius = radius; }
      // predicates
      virtual bool is_valid(const Geometric_tolerances& tolerances,
                            Roan_trail::Tovero_support::Error_param& return_error) const;
      // visitor
      virtual Solid_visitor::Visit_result accept(Solid_visitor& visitor) const { return visitor.visit(*this); }
      // other
      virtual std::string solid_class() const { return "Sphere"; }
      virtual Ellipsoid& generalize() const;
    protected:
      // destructor
      virtual ~Sphere() {}
    private:
      // solid parameters
      Point m_center;
      Distance m_radius;
    };
  }
}

#endif // TOVERO_MATH_SPHERE_HPP_
