// Solid_operand.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Class for representing an operand in an solid operation or solid combination

#ifndef TOVERO_MATH_SOLID_OPERAND_HPP_
#define TOVERO_MATH_SOLID_OPERAND_HPP_

#include <tovero/support/Reference_counting_base.hpp>

namespace Roan_trail
{
  namespace Tovero_math
  {
    class Solid;
    class Transformation;

    class Solid_operand : public Roan_trail::Tovero_support::Reference_counting_base
    {
    public:
      // constructors/copy
      explicit Solid_operand(Solid& solid, // Note: referenced, not const
                             Transformation* transformation = 0); // Note: referenced, not const
      Solid_operand(const Solid_operand& o);
      Solid_operand& operator=(const Solid_operand& o);
      // accessors/mutators
      Solid& solid() const { return *m_solid; }
      void set_solid(Solid& solid);
      // Note: referenced, not returned as const:
      Transformation* transformation() const { return m_transformation; }
      void set_transformation(Transformation* transformation);
    protected:
      // destructor
      virtual ~Solid_operand();
      // class invariant
      bool mf_invariant(bool check_base_class = true) const;
    private:
      Solid* m_solid;
      Transformation* m_transformation;
    };
  }
}

#endif // TOVERO_MATH_SOLID_OPERAND_HPP_
