// Solid_operand.cpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#include <tovero/math/geometry/Solid_operand.hpp>
#include <tovero/math/geometry/Solid.hpp>
#include <tovero/math/geometry/Transformation.hpp>
#include <tovero/support/common.hpp>
#include <tovero/support/Reference_counting_base.hpp>

using Roan_trail::Tovero_support::Reference_counting_base;
using namespace Roan_trail::Tovero_math;

//
// Constructors/copy
//

Solid_operand::Solid_operand(Solid& solid, Transformation* transformation)
  : Reference_counting_base(),
    m_solid(&solid),
    m_transformation(transformation)
{
  m_solid->reference();
  if (m_transformation)
  {
    m_transformation->reference();
  }

  postcondition(mf_invariant(false));
}

Solid_operand::Solid_operand(const Solid_operand& o)
  : Reference_counting_base(o)
{
  set_solid(*o.m_solid);
  set_transformation(o.m_transformation);

  postcondition(mf_invariant(false));
}

Solid_operand& Solid_operand::operator=(const Solid_operand& o)
{
  precondition(mf_invariant(false));

  if (this != &o)
  {
    Reference_counting_base::operator=(o);
    set_solid(*o.m_solid);
    set_transformation(o.m_transformation);
  }

  postcondition(mf_invariant(false));
  return *this;
}

//
// Accessors/mutators
//

void Solid_operand::set_solid(Solid& solid)
{
  precondition(mf_invariant());

  if (m_solid != &solid)
  {
    solid.reference();
    m_solid->unreference();
    m_solid = &solid;
  }

  postcondition(mf_invariant());
}

void Solid_operand::set_transformation(Transformation* transformation)
{
  precondition(mf_invariant());

  if (m_transformation != transformation)
  {
    if (transformation)
    {
      transformation->reference();
    }
    if (m_transformation)
    {
      m_transformation->unreference();
    }
    m_transformation = transformation;
  }

  postcondition(mf_invariant());
}

//
// Protected member functions
//

//
//   Destructor
//

Solid_operand::~Solid_operand()
{
  precondition(mf_invariant(false));

  if (m_transformation)
  {
    m_transformation->unreference();
  }
  m_solid->unreference();
}

//
//   Class invariant
//

bool Solid_operand::mf_invariant(bool check_base_class) const
{
  static_cast<void>(check_base_class); // avoid unused warning

  bool return_value = false;

  if (!m_solid)
  {
    goto exit_point;
  }

  return_value = (!check_base_class || Reference_counting_base::mf_invariant(check_base_class));
  goto exit_point;

 exit_point:
  return return_value;
}
