// Solid_member.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Class for representing a member of a solid combination, including
// an operand and an operation on it.

#ifndef TOVERO_MATH_SOLID_MEMBER_HPP_
#define TOVERO_MATH_SOLID_MEMBER_HPP_

#include <tovero/support/Reference_counting_base.hpp>
#include <tovero/math/geometry/Solid_operator.hpp>

namespace Roan_trail
{
  namespace Tovero_math
  {
    class Solid;
    class Solid_operand;

    class Solid_member : public Roan_trail::Tovero_support::Reference_counting_base
    {
    public:
      // constructors/copy
      explicit Solid_member(Solid_operand& operand, // Note: referenced, not const
                            Solid_operator::Solid_operator_type op
                            = Solid_operator::union_op); // (check_code_ignore)
      explicit Solid_member(Solid& solid, // Note: referenced, not const
                            Solid_operator::Solid_operator_type op
                            = Solid_operator::union_op); // (check_code_ignore)
      Solid_member(const Solid_member& o);
      Solid_member& operator=(const Solid_member& m);
      // accessors/mutators
      Solid_operand& operand() const { return *m_operand; } // Note: referenced, not returned as const
      void set_operand(Solid_operand& operand);
      Solid_operator::Solid_operator_type op() const { return m_op; }
      void set_op(Solid_operator::Solid_operator_type op) { m_op = op; }
    protected:
      // destructor
      virtual ~Solid_member();
      // class invariant
      bool mf_invariant(bool check_base_class = true) const;
    private:
      Solid_operand* m_operand;
      Solid_operator::Solid_operator_type m_op;
    };
  }
}

#endif // TOVERO_MATH_SOLID_MEMBER_HPP_
