// Solid.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Abstract solid class

#ifndef TOVERO_MATH_SOLID_HPP_
#define TOVERO_MATH_SOLID_HPP_

#include <tovero/support/Reference_counting_base.hpp>
#include <tovero/math/geometry/Solid_visitor.hpp>
#include <string>

namespace Roan_trail
{
  namespace Tovero_support
  {
    class Error_param;
  }

  namespace Tovero_math
  {
    class Geometric_tolerances;

    class Solid : public Roan_trail::Tovero_support::Reference_counting_base
    {
    public:
      // copy
      virtual Solid *clone_solid() const = 0;
      // predicates
      //   overload in non-primitive classes
      virtual bool is_primitive() const { return true; }
      //   overload in primitive classes
      virtual bool is_valid(const Geometric_tolerances& tolerances,
                            Roan_trail::Tovero_support::Error_param& error) const { return true; }
      // visitor
      virtual Solid_visitor::Visit_result accept(Solid_visitor& visitor) const = 0;
      // other
      virtual std::string solid_class() const = 0;
      //   return the more specialized case of this solid
      virtual Solid& specialize(const Geometric_tolerances& tolerances) const
      { return *const_cast<Solid*>(this); }
    protected:
      // constructor/destructor/copy
      explicit Solid(const std::string& name) : Reference_counting_base(name) {}
      Solid(const Solid& s) : Reference_counting_base(s.name()) {}
      inline Solid& operator=(const Solid& s);
      virtual ~Solid() {}
    };

    //
    // Inline definitions
    //

    inline Solid& Solid::operator=(const Solid& s)
    {
      if (&s != this)
      {
        Reference_counting_base::operator=(s);
      }
      return *this;
    }
  }
}

#endif // TOVERO_MATH_SOLID_HPP_
