// Matrix.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// 4x4 projection matrix

#ifndef TOVERO_MATH_MATRIX_HPP_
#define TOVERO_MATH_MATRIX_HPP_

#include <tovero/math/base/math.hpp>
#include <cstddef>

namespace Roan_trail
{
  namespace Tovero_math
  {
    class Angle;
    class Unit_vector;
    class Vector;

    class Matrix
    {
    public:
      // constructors
      Matrix();
      Matrix(double v_0_0, double v_0_1, double v_0_2, double v_0_3,
             double v_1_0, double v_1_1, double v_1_2, double v_1_3,
             double v_2_0, double v_2_1, double v_2_2, double v_2_3,
             double v_3_0, double v_3_1, double v_3_2, double v_3_3);
      Matrix(const Matrix& m);
      // operators
      Matrix& operator=(const Matrix& m);
      inline Matrix& operator*(const Matrix& m) { return this->multiply_right(m); }
      const double& operator[](size_t index) const { return m_matrix[index]; }
      double& operator[](size_t index) { return m_matrix[index]; }
      // functions
      void transpose();
      void set_rotation(const Unit_vector& axis, const Angle& a);
      void set_translation(double tx,
                           double ty,
                           double tz);
      void set_scale(double sx,
                     double sy,
                     double sz);
      void set_uniform_scale(double s);
      Matrix& multiply_right(const Matrix& m);
      Matrix& multiply_left(const Matrix& m);
      // predefined matrices
      static const Matrix I;
      //
    private:
      double m_matrix[16];
    };

    //
    //   Functions
    //
  }
}

#endif // TOVERO_MATH_MATRIX_HPP_
