// Elliptical_cylinder.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Right elliptical cylinder.  The perpendicular base a and base b
// vectors are added to the base point to form the elliptical base.
// The base is perpendicularly extruded to the height to create
// the cylinder.

#ifndef TOVERO_MATH_ELLIPTICAL_CYLINDER_HPP_
#define TOVERO_MATH_ELLIPTICAL_CYLINDER_HPP_

#include <tovero/math/geometry/General_cone_base.hpp>
#include <tovero/math/geometry/Distance.hpp>
#include <tovero/math/geometry/Point.hpp>
#include <tovero/math/geometry/Vector.hpp>
#include <string>

namespace Roan_trail
{
  namespace Tovero_math
  {
    class General_cone;

    class Elliptical_cylinder : public General_cone_base
    {
    public:
      // constructor/copy
      Elliptical_cylinder(const std::string& name = "");
      Elliptical_cylinder(const Point& base,
                          const Vector& base_a,
                          const Vector& base_b,
                          const Distance& height,
                          const std::string& name = "");
      virtual Solid* clone_solid() const { return new Elliptical_cylinder(*this); }
      //   Note: let compiler generate default copy constructor and operator=
      // accessors/mutators
      const Point& base() const { return m_base; }
      void set_base(const Point& base) { m_base = base; }
      const Vector& base_a() const { return m_base_a; }
      void set_base_a(const Vector& base_a) { m_base_a = base_a; }
      const Vector& base_b() const { return m_base_b; }
      void set_base_b(const Vector& base_b) { m_base_b = base_b; }
      const Distance& height() const { return m_height; }
      void set_height(const Distance& height) { m_height = height; }
      // predicates
      virtual bool is_valid(const Geometric_tolerances& tolerances,
                            Roan_trail::Tovero_support::Error_param& return_error) const;
      // visitor
      virtual Solid_visitor::Visit_result accept(Solid_visitor& visitor) const { return visitor.visit(*this); }
      // other
      virtual std::string solid_class() const { return "Elliptical_cylinder"; }
      virtual General_cone& generalize() const;
      virtual Solid& specialize(const Geometric_tolerances& tolerances) const;
    protected:
      // destructor
      virtual ~Elliptical_cylinder() {}
    private:
      // solid parameters
      Point m_base; // base center point
      Vector m_base_a;
      Vector m_base_b;
      Distance m_height;
    };
  }
}

#endif // TOVERO_MATH_ELLIPTICAL_CYLINDER_HPP_
