// Cylinder.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Right circular cylinder

#ifndef TOVERO_MATH_CYLINDER_HPP_
#define TOVERO_MATH_CYLINDER_HPP_

#include <tovero/math/geometry/General_cone_base.hpp>
#include <tovero/math/geometry/Distance.hpp>
#include <tovero/math/geometry/Geometric_tolerances.hpp>
#include <tovero/math/geometry/Point.hpp>
#include <tovero/math/geometry/Vector.hpp>
#include <string>

namespace Roan_trail
{
  namespace Tovero_support
  {
    class Error_param;
  }

  namespace Tovero_math
  {
    class General_cone;

    class Cylinder : public General_cone_base
    {
    public:
      // constructor/copy
      // Defaults to a cylinder of radius of 1.0 with the base centered at the origin
      Cylinder(const std::string& name = "");
      Cylinder(const Point& base,
               const Vector& height,
               const Distance& radius,
               const std::string& name = "");
      virtual Solid* clone_solid() const { return new Cylinder(*this); }
      //   Note: let compiler generate default constructor and operator=
      // accessors/mutators
      const Point& base() const { return m_base; }
      void set_base(const Point& base) { m_base = base; }
      const Vector& height() const { return m_height; }
      void set_height(const Vector& height) { m_height = height; }
      const Distance& radius() const { return m_radius; }
      void set_radius(const Distance& radius) { m_radius = radius; }
      // predicates
      virtual bool is_valid(const Geometric_tolerances& tolerances,
                            Roan_trail::Tovero_support::Error_param& return_error) const;
      // visitor
      virtual Solid_visitor::Visit_result accept(Solid_visitor& visitor) const { return visitor.visit(*this); }
      // other
      virtual std::string solid_class() const { return "Cylinder"; }
      virtual General_cone& generalize() const;
    protected:
      // destructor
      virtual ~Cylinder() {}
    private:
      // solid parameters
      Point m_base;    // base center point
      Vector m_height;
      Distance m_radius;
    };
  }
}

#endif // TOVERO_MATH_CYLINDER_HPP_
