// Axis_aligned_box.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Right parallelpiped, aligned to X, Y, Z axes
// specialized Polyhedron (8 vertex)

#ifndef TOVERO_MATH_AXIS_ALIGNED_BOX_HPP_
#define TOVERO_MATH_AXIS_ALIGNED_BOX_HPP_

#include <tovero/math/geometry/Polyhedron_base.hpp>
#include <tovero/math/geometry/Point.hpp>
#include <string>

namespace Roan_trail
{
  namespace Tovero_math
  {
    class Geometric_tolerances;
    class Polyhedron;

    class Axis_aligned_box : public Polyhedron_base
    {
    public:
      // constructor/copy
      Axis_aligned_box(const std::string& name = "");
      Axis_aligned_box(const Point& minimum,
                       const Point& maximum,
                       const std::string& name = "");
      virtual Solid* clone_solid() const { return new Axis_aligned_box(*this); }
      //   Note: let compiler generate default copy constructor and operator=
      // accessors/mutators
      const Point& minimum() const { return m_minimum; }
      void set_minimum(const Point& minimum) { m_minimum = minimum; }
      const Point& maximum() const { return m_maximum; }
      void set_maximum(const Point& maximum) { m_maximum = maximum; }
      // predicates
      virtual bool is_valid(const Geometric_tolerances& tolerances,
                            Roan_trail::Tovero_support::Error_param& return_error) const;
      // visitor
      virtual Solid_visitor::Visit_result accept(Solid_visitor& visitor) const { return visitor.visit(*this); }
      // other
      virtual std::string solid_class() const { return "Axis_aligned_box"; }
      virtual Polyhedron& generalize() const;
    protected:
      // destructor
      virtual ~Axis_aligned_box() {}
    private:
      // solid parameters
      Point m_minimum;
      Point m_maximum; // lower left corner
    };
  }
}

#endif // TOVERO_MATH_AXIS_ALIGNED_BOX_HPP_
