// math.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#ifndef TOVERO_MATH_MATH_HPP_
#define TOVERO_MATH_MATH_HPP_

#include <boost/concept/assert.hpp>
#include <boost/concept_check.hpp>

namespace Roan_trail
{
  namespace Tovero_math
  {
    // templatized max/min functions
    template <class T> const T& min(const T& a, const T& b)
    {
      BOOST_CONCEPT_ASSERT((boost::LessThanComparable<T>));
      return (b < a) ? b : a;
    }
    template <class T> const T& max(const T& a, const T& b)
    {
      BOOST_CONCEPT_ASSERT((boost::LessThanComparable<T>));
      return (b > a) ? b : a;
    }

    // to avoid warnings about equality comparisions of floating point values
    template <class T> bool exact_equal_fp(const T& a, const T& b)
    {
      BOOST_CONCEPT_ASSERT((boost::LessThanComparable<T>));
      return !((a < b) || (a > b));
    }

    template <class T> void exchange(T& a, T& b)
    {
      // TODO: Boost concept
      const T temporary = a;
      a = b;
      b = temporary;
    }
  }
}

#endif // TOVERO_MATH_MATH_HPP_
