#!/usr/local/bin/ruby
#
# Test_BC.rb
#
# Copyright 2012-2013 Roan Trail, Inc.
#
# This file is part of Tovero.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
#   (1) Redistributions of source code must retain the above copyright
#   notice, this list of conditions and the following disclaimer.
#
#   (2) Redistributions in binary form must reproduce the above copyright
#   notice, this list of conditions and the following disclaimer in
#   the documentation and/or other materials provided with the
#   distribution.
#
#   (3) The name of the author may not be used to
#   endorse or promote products derived from this software without
#   specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
# STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
# IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

# These load the extension libraries
require 'libtovero_support_rb_0'
require 'libtovero_math_rb_0'
require 'libtovero_graphics_rb_0'

# These are like "using namespace" in C++
include Libtovero_support_rb_0
include Libtovero_math_rb_0
include Libtovero_graphics_rb_0

arb8 = Polyhedron.new
arb8.name = "arb8"

combo = SolidCombination.new
combo.name = "combo"
combo.add_member(SolidMember.new(arb8))

p = Point.new(Distance.new(1.0, Distance::meter),
              Distance.new(0.0, Distance::meter),
              Distance.new(0.0, Distance::meter))

cone = GeneralCone.new
cone.base = p
cone.name = "cone"

combo.add_member(SolidMember.new(cone, SolidOperator::Difference_op))

BC_DB = BCDatabase.new;

sl = BC_DB.top_solids;

sl.push_back(combo)

e = ErrorParam.new
wrote_DB = BC_DB.write("test.g", true, e)
if (!wrote_DB)
  exit 1
else
  exit 0
end

