// BC_database.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.  BRL-CAD
// database read/write functions
//
// Note: a goal of this code is to have invariance with respect to
// geometry when converting to and from BRL-CAD, not necessarily
// preserve the exact database structures.

#ifndef TOVERO_GRAPHICS_BC_DATABASE_HPP_
#define TOVERO_GRAPHICS_BC_DATABASE_HPP_

#include <tovero/graphics/base/Database.hpp>

#include <string>
#include <vector>

namespace Roan_trail
{
  namespace Tovero_support
  {
    class Error_param;
  }

  namespace Tovero_math
  {
    class Geometric_tolerances;
    class Solid;
  }

  namespace Tovero_graphics
  {
    class BC_database : public Database
    {
    public:
      // constructor/destructor/initialization
      BC_database(const std::string& title = "");
      // read/write
      virtual bool write(const std::string& path,
                         bool overwrite,
                         Roan_trail::Tovero_support::Error_param& return_error);
      virtual bool write(const std::string& path,
                         bool overwrite,
                         const Roan_trail::Tovero_math::Geometric_tolerances& tolerances,
                         Roan_trail::Tovero_support::Error_param& return_error);
      virtual bool write_solid(Roan_trail::Tovero_math::Solid* solid,
                               const std::string& path,
                               bool overwrite,
                               Roan_trail::Tovero_support::Error_param& return_error);
      virtual bool write_solid(Roan_trail::Tovero_math::Solid* solid,
                               const std::string& path,
                               bool overwrite,
                               const Roan_trail::Tovero_math::Geometric_tolerances& tolerances,
                               Roan_trail::Tovero_support::Error_param& return_error);
      virtual bool read(const std::string& path,
                        const std::vector<std::string>& objects,
                        Roan_trail::Tovero_support::Error_param& return_error);
      bool read(const std::string& path,
                const std::vector<std::string>& objects,
                const Roan_trail::Tovero_math::Geometric_tolerances& tolerances,
                Roan_trail::Tovero_support::Error_param& return_error);
      // accessors/mutators
      bool simplify_solids_on_read() const { return m_simplify_solids_on_read; }
      void set_simplify_solids_on_read(bool simplify) { m_simplify_solids_on_read = simplify; }
      bool tolerate_database_errors() const { return m_tolerate_database_errors; }
      void set_tolerate_database_errors(bool tolerate) { m_tolerate_database_errors = tolerate; }
    private:
      bool m_simplify_solids_on_read; // e.g. when reading in an ellipsoid, simplify it to a sphere if possible
      bool m_tolerate_database_errors;
      // prevent compiler from generating
      BC_database(const BC_database& database);
      BC_database& operator=(const BC_database& database);
    };
  }
}

#endif // TOVERO_GRAPHICS_BC_DATABASE_HPP_

