// Color.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#ifndef TOVERO_GRAPHICS_COLOR_HPP_
#define TOVERO_GRAPHICS_COLOR_HPP_

#include <tovero/support/Reference_counting_base.hpp>
#include <tovero/support/common.hpp>

namespace Roan_trail
{
  namespace Tovero_graphics
  {
    class Color : public Roan_trail::Tovero_support::Reference_counting_base
    {
    public:
      // constructors
      inline Color();
      inline Color(uint8_t red,
                   uint8_t green,
                   uint8_t blue,
                   uint8_t alpha);
      // accessors
      uint8_t red() const { return m_red; }
      void set_red(uint8_t red) { m_red = red; }
      uint8_t green() const { return m_green; }
      void set_green(uint8_t green) { m_green = green; }
      uint8_t blue() const { return m_blue; }
      void set_blue(uint8_t blue) { m_blue = blue; }
      uint8_t alpha() const { return m_alpha; }
      void set_alpha(uint8_t alpha) { m_alpha = alpha; }
      //   Note: let the compiler generate copy constructor, operator=
    protected:
      // destructor
      virtual ~Color() {}
    private:
      uint8_t m_red;
      uint8_t m_green;
      uint8_t m_blue;
      uint8_t m_alpha;
    };

    //
    // Inline definitions
    //

    //
    //   Constructors
    //

    inline Color::Color()
      : m_red(0),
        m_green(0),
        m_blue(0),
        m_alpha(0) {}

    inline Color::Color(uint8_t red,
                        uint8_t green,
                        uint8_t blue,
                        uint8_t alpha)
      : m_red(red),
        m_green(green),
        m_blue(blue),
        m_alpha(alpha) {}
  }
}

#endif // TOVERO_GRAPHICS_COLOR_HPP_
