# ruby.m4
#
# Copyright 2012-2013 Roan Trail, Inc.
#
# This file is part of Tovero.
#
# Tovero is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# Tovero is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.  You should have
# received a copy of the GNU Lesser General Public License along with
# Tovero. If not, see <http://www.gnu.org/licenses/>.
#
# Originally from the file ./ruby.ac in Rice 1.1:
#
#   Copyright (C) 2009 Paul Brannan <pbrannan@atdesk.com>
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   1. Redistributions of source code must retain the above copyright
#      notice, this list of conditions and the following disclaimer.
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
#   THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
#   IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
#   OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
#   IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
#   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
#   NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
#   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
#   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
#   THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

# Get a key from ruby's configuration table
AC_DEFUN([RUBY_CONFIG], [
          $RUBY -rrbconfig -e "puts(RbConfig::CONFIG[['$1']] || '')"])

AC_DEFUN([RB_INIT_RUBY], [

AC_ARG_WITH(
    ruby,
    AC_HELP_STRING(
     --with-ruby=PATH,
     [ path to the ruby interpreter [[ruby]] ]),
    [ RUBY=$withval ],
    [ RUBY=ruby ])
AC_ARG_WITH(
    ruby_sitelibdir,
    AC_HELP_STRING(
     --with-ruby-sitelibdir=PATH,
     [ path to install ruby scripts [[auto-detect]] ]),
    [ ruby_sitelibdir=$withval ],
    [ ruby_sitelibdir=NONE ])

AC_SUBST(RUBY)

RUBY_VERSION_CODE=`$RUBY -e "puts RUBY_VERSION.gsub(/\./, '')"`
AC_SUBST(RUBY_VERSION_CODE)

RUBY_CONFIG_SO_NAME=`RUBY_CONFIG(RUBY_SO_NAME)`
RUBY_CONFIG_ARCHDIR=`RUBY_CONFIG(archdir)`
RUBY_CONFIG_ARCH=`RUBY_CONFIG(arch)`
RUBY_CONFIG_LIBDIR=`RUBY_CONFIG(libdir)`

RUBY_CONFIG_BINDIR=`RUBY_CONFIG(bindir)`
AC_SUBST(RUBY_CONFIG_BINDIR)

RUBY_CONFIG_RUBYHDRDIR=`RUBY_CONFIG(rubyhdrdir)`
RUBY_CONFIG_CFLAGS=`RUBY_CONFIG(CFLAGS)`
RUBY_CONFIG_LIBS=`RUBY_CONFIG(LIBS)`
RUBY_CONFIG_DLDLIBS=`RUBY_CONFIG(DLDLIBS)`
RUBY_CONFIG_LDFLAGS=`RUBY_CONFIG(LDFLAGS)`
RUBY_CONFIG_LIBRUBYARG=`RUBY_CONFIG(LIBRUBYARG)`
RUBY_CONFIG_LIBRUBYARG_STATIC=`RUBY_CONFIG(LIBRUBYARG_STATIC)`
RUBY_CONFIG_CCDLFLAGS=`RUBY_CONFIG(CCDLFLAGS)`

if test "x${RUBY_CONFIG_RUBYHDRDIR}x" != "xx"; then
  # 1.9
  RUBY_CPPFLAGS="-I${RUBY_CONFIG_RUBYHDRDIR}"
  RUBY_CPPFLAGS="${RUBY_CPPFLAGS} -I${RUBY_CONFIG_RUBYHDRDIR}/${RUBY_CONFIG_ARCH}"
else
  # 1.8
  RUBY_CPPFLAGS="-I${RUBY_CONFIG_ARCHDIR}"
fi
AC_SUBST(RUBY_CPPFLAGS)

RUBY_CFLAGS="${RUBY_CONFIG_CFLAGS} ${RUBY_CONFIG_CCDLFLAGS}"
AC_SUBST(RUBY_CFLAGS)

RUBY_CXXFLAGS="${RUBY_CONFIG_CFLAGS} ${RUBY_CONFIG_CCDLFLAGS}"
AC_SUBST(RUBY_CXXFLAGS)

RUBY_LDFLAGS="-L${RUBY_CONFIG_ARCHDIR} -L${RUBY_CONFIG_LIBDIR} ${RUBY_CONFIG_LDFLAGS}"
AC_SUBST(RUBY_LDFLAGS)

RUBY_LIBS="${RUBY_CONFIG_LIBS} ${RUBY_CONFIG_DLDLIBS}"
AC_SUBST(RUBY_LIBS)

RUBY_LIBRUBYARG="${RUBY_CONFIG_LIBRUBYARG}"
AC_SUBST(RUBY_LIBRUBYARG)

RUBY_LIBRUBYARG_STATIC="${RUBY_CONFIG_LIBRUBYARG_STATIC}"
AC_SUBST(RUBY_LIBRUBYARG_STATIC)

# If the user specified a prefix, then use it, otherwise default to
# the configured sitelibdir
if test "x${ruby_sitelibdir}x" != "xNONEx"
then
  RUBY_SITELIBDIR="${ruby_sitelibdir}"
else
  if test "x${prefix}x" = "xNONEx"
  then
    RUBY_SITELIBDIR=`RUBY_CONFIG(sitelibdir)`
  else
    sitelibdir_no_prefix=`$RUBY -rrbconfig \
    -e "include Config; \
    puts CONFIG[['sitelibdir']].sub(CONFIG[['prefix']], '')"`
    RUBY_SITELIBDIR="${prefix}/${sitelibdir_no_prefix}"
  fi
fi
AC_SUBST(RUBY_SITELIBDIR)

# The fourth parameter to AC_CHECK_HEADER keeps autoconf from
# searching for standard header files as a side-effect (which we want)
CPPFLAGS_save="${CPPFLAGS}"
CPPFLAGS="${CPPFLAGS} ${RUBY_CPPFLAGS}"
CXXFLAGS_save="${CXXFLAGS}"
CXXFLAGS="${CPPFLAGS}"
AC_CHECK_HEADERS(ruby.h,,AC_MSG_ERROR(
                could not find ruby.h (check config.log)),[ ])
AC_CHECK_HEADERS(node.h,,,[
#include <ruby.h>
])
AC_CHECK_HEADERS(ruby/node.h,
                 [ AC_DEFINE(REALLY_HAVE_RUBY_NODE_H, [],
                             [ Define this macro to use ruby/node.h ]) ],
                             ,[
#include <ruby.h>
])
AC_CHECK_HEADERS(version.h,,,[
#include <ruby.h>
])
AC_CHECK_HEADERS(env.h,,,[
#include <ruby.h>
])

CPPFLAGS="${CPPFLAGS_save}"
CXXFLAGS="${CXXFLAGS_save}"

AC_MINGW32

if test x"${MINGW32}"x = xyesx; then
  RB_FIX_MINGW_LIBS
fi

]) # RB_INIT_RUBY

# We would like to be able to build using MingW against the one-click
# installer, which is built using VC6.  So, we detect this situation
# and fix up the link step if this is the case.
#
# Static linking isn't likely to work correctly, so we disable it by
# default, but if the user asks for LIBRUBYARG_STATIC, they'll still
# get static linking.
AC_DEFUN([RB_FIX_MINGW_LIBS], [
RUBY_LIBS=`echo ${RUBY_LIBS} | sed -e "s%oldnames.lib%-lmoldname%"`
RUBY_LIBS=`echo ${RUBY_LIBS} | sed -e "s%user32.lib%-luser32%"`
RUBY_LIBS=`echo ${RUBY_LIBS} | sed -e "s%advapi32.lib%-ladvapi32%"`
RUBY_LIBS=`echo ${RUBY_LIBS} | sed -e "s%ws2_32.lib%-lws2_32%"`
RUBY_LIBRUBYARG=`echo ${RUBY_LIBRUBYARG} | sed -e "s%\(msvcrt-ruby.*\).lib%${RUBY_CONFIG_BINDIR}/\1.dll%"`
RUBY_LIBRUBYARG_STATIC=`echo ${RUBY_LIBRUBYARG_STATIC} | sed -e "s%\(msvcrt-ruby.*\).lib%${RUBY_CONFIG_LIBDIR}/\1.lib%"`
]) dnl RB_FIX_MINGW_LIBS

# vim:ft=config
