<< 
{ File usr/work.n  July 2005

   This file is sourced by word nn, which is equivalent to 

      "work.n" psource 

   or 

      psource("work.n") 

   depending on where you are working.  

   The file can have a mix of postfix and infix notation, separated 
   by >> and <<.

   This file is run by test/parser.
}
\-----------------------------------------------------------------------

{  Example of a high level word that is the interface to a C function 
   for sparse eigenanalysis.

   The high level word for speig1 might be in file speig1.v or speig1.n.

   As an example, assume a C function _speig1 with argument list:
      _speig1(Kxx,Mxx,nModes);

   High level word speig1 shown below does not require nModes in its
   argument list:
      speig1(Kxx,Mxx);

   It runs C function _speig1() by providing either a default value for 
   nModes or a value that has been banked into it beforehand.

   The demo below shows the use of the parser's dot notation to bank 
   nModes into speig1() before it runs _speig1().  First, here are words
   speig1 and _speig1; the latter is a standin for a C function:
}
>>

catmsg(no);

function (Val, Vec) = speig1(Kxx, Mxx) {
// This is the high level interface to C function _speig1().
   { 
     nModes = UDEF;
     nModes_def = 10;
   }
// Define the number of modes for _speig1():
   if(nModes == UDEF) nModes = min(nModes_def, rows(Mxx));

// Call C function _speig1() that expects nModes in the  argument 
// list too:
   (Val, Vec) = _speig1(Kxx, Mxx, nModes);
}

function (Val, Vec) = _speig1(Kxx, Mxx, nModes) {
// This word represents C function _speig1 for this example:

   dot("_speig1 running");
   dot(.i(nModes)," modes");
   nl();

   Val = random(rows(Mxx),1);
   Vec = random(dims(Mxx));
}

#-----------------------------------------------------------------------

#  Using dot notation.

{# These statements might appear in a script that would source words 
   from a file speig1.v or speig1.n and then run an eigenanalysis.  

   They show dot notation "speig1.nModes=X" to bank nModes into high 
   level function speig1(), and dot notation "X=speig1.nModes" to yank 
   nModes out of speig1(). #}

   Kxx = random(20, 20);
   Mxx = random(dims(Kxx));

   nl();
   speig1.nModes = 10; # bank 10 into speig1() for 1st case
   (eVal, eVec) = speig1(Kxx, Mxx);

   iter1 = speig1.nModes;

   speig1.nModes = 15; # bank 15 into speig1() for 2nd case 
   (eVal, eVec) = speig1(Kxx, Mxx);

   iter2 = speig1.nModes;

   nl();
   dot("Number of modes iterated:"); nl();
   dot("  Case 1:"); .i(iter1); nl();
   dot("  Case 2:"); .i(iter2); nl();

   halt
#-----------------------------------------------------------------------
