{ File tops/usr/uboot.v (at usrpath = tops/usr)

   User additional words at boot time.

   This file is an example of a file that can be placed in a user's 
   directory to be included at start up.  Its words will be added to 
   the catalog, or will override any matching ones created so far by
   tops/sys/boot.v.

   This file uboot.v is sourced by boot.v at start up if a user version
   of uboot.v is not found elsewhere.

   Sat Jul 14 10:23:10 PDT 2012.  More about this file:

      This file is at usrpath equal to tops/usr, the default for usrpath
      when the program is installed.  It is sourced at start up right 
      after file tops/sys/boot.v has been sourced to provide additional
      words and to override any matching words created so far.

      But this file is intended to be under user control to make user
      settings at start up.  Once the program is in serious use, this
      file tops/usr/uboot.v should not be used since it is in a tops/
      subdirectory where it can be updated any time by CVS as the pro-
      gram evolves.

      A user can point the program's usrpath to a directory that is not
      within the program's set of directories under CVS.

      This is easily done with a line like the following in a user's
      file /home/user/.bashrc (or a similar file for shells other than
      bash):

         export TOPS_USRPATH=/opt/mytops/usr/

      That line makes usrpath equal to /opt/mytops/usr/ and is where
      the program will look for file uboot.v.  If found, it will be 
      sourced at start up, instead of this one.  

      At new directory usrpath, new uboot.v can be as simple as a zero
      byte file made at the system prompt with the touch command:

         /opt/mytops/usr > touch uboot.v

      and the program will source it and never use this uboot.v file
      at tops/usr.

      To begin, it is recommended that this file be copied to the new
      usrpath and edited as necessary, keeping the lines of this file
      that are surrounded above by "keep begin" and below by "keep end"
      (there are two such groups of lines in this file).
}
\-----------------------------------------------------------------------
# keep begin (recommended at the top of a user's uboot.v file)

   uboot_done (f) \ flag from boot.v
   IF " uboot.v: only at start up" . nl halt THEN \ only source once

 \ This is a message written to the start up log file (argv -l):
  " info: sourcing " usrpath "uboot.v" + + . nl

\  Words from sys/uboot.v are sourced before this one:
   syspath "uboot.v" + filefound (0 or qFile -1)
   IF (qFile) source \ sourcing the system sys/uboot.v if it is found
   THEN

# keep end
\-----------------------------------------------------------------------

{  Contents

 \ These lines display define and inline names for a list of contents: 
      usrpath "uboot.v" + asciiload this " define:" grepr reach dot
      usrpath "uboot.v" + asciiload this " inline:" grepr reach dot

   Network
   inline: NISTdelta ( --- sec) \ NIST time minus the machine's time
   inline: IPlocal ( --- qS) \ this machine's IP address
   define: anchove ( --- ) \ remote login to machine anchove

   Graphics
   inline: line_tests (hWCB hGCB hY hX hL -- ) \ expose events for lines
   inline: pExposeUSER (hWCB hGCB hY hX hL -- ) \ expose event for a Mat

   Miscellaneous
}
\-----------------------------------------------------------------------

\  Sourcing other files:
   "_pppconnect" missing IF "web.v" source THEN

\  Use this to keep words-defined messages coming to start up log file:
   yes catmsg \ in case any files sourced above turned catmsg off

\-----------------------------------------------------------------------

 \ Network

 \ This version of NISTdelta it will override the one from net.v read
 \ at start up:
   inline: NISTdelta ( --- sec) \ NIST time minus the machine's time
{     Fri May 27 09:03:07 PDT 2011

      Fetch GMT from the National Institute of Standards and Technol-
      ogy (NIST) web sites and return the difference from the machine's
      GMT.

      This is a high level driver of word _NISTdelta in file net.v.

      In late May 2011, garbage values from NIST were first noticed,
      prompting this high level word as a quick fix.  

      Examples.  Below are three actual, real live examples.  Delta
      equal to -20 is the right answer; values of 0 correspond to -inf,
      meaning no data received.

      Example 1:
         [tops@plunger] ready > date . nl NISTdelta
         Fri May 27 10:21:54 PDT 2011
          NISTdelta contacting 192.43.244.18  received delta -20
          NISTdelta contacting 129.6.15.28    received delta 0
          NISTdelta contacting 129.6.15.29    received delta 0
          NISTdelta contacting 132.163.4.101  received delta 0
          NISTdelta contacting 132.163.4.102  received delta 0
          NISTdelta contacting 132.163.4.103  received delta 0
          NISTdelta contacting 128.138.140.44 received delta 463
          NISTdelta WARNING: NIST time invalid, keeping previous

          stack elements:
                0 number: previous  -21
          [1] ok!
         [tops@plunger] ready >
         [tops@plunger] ready > bye
         27 keys
                   Good-bye
         Fri May 27 10:22:52 PDT 2011

      Example 2:
         [dale@plunger] /home/dale > tops
                  Tops 3.2.0
         Fri May 27 10:25:50 PDT 2011
         [tops@plunger] ready > NISTdelta
          NISTdelta contacting 192.43.244.18  received delta -20
          NISTdelta contacting 129.6.15.28    received delta 531
          NISTdelta contacting 129.6.15.29    received delta 0
          NISTdelta contacting 132.163.4.101  received delta 0
          NISTdelta contacting 132.163.4.102  received delta 0
          NISTdelta contacting 132.163.4.103  received delta 0
          NISTdelta contacting 128.138.140.44 received delta -20
          NISTdelta WARNING: NIST time set to MAX sec 30

          stack elements:
                0 number: MAX  30
          [1] ok!
         [tops@plunger] ready >

      Example 3:
         [dale@plunger] /home/dale > tops
                  Tops 3.2.0
         Fri May 27 10:30:58 PDT 2011
         [tops@plunger] ready > NISTdelta
          NISTdelta contacting 192.43.244.18  received delta -20
          NISTdelta contacting 129.6.15.28    received delta 0
          NISTdelta contacting 129.6.15.29    received delta 0
          NISTdelta contacting 132.163.4.101  received delta 0
          NISTdelta contacting 132.163.4.102  received delta 0
          NISTdelta contacting 132.163.4.103  received delta -20
          NISTdelta contacting 128.138.140.44 received delta -20

          stack elements:
                0 number: Tdelta  -20
          [1] ok!
         [tops@plunger] ready >
}
      [  UDEF "previous" book
         300 "MAX" book
        -300 "MIN" book

        "' NISTdelta WARNING: NIST time invalid, keeping previous' . nl"
        ".WARNING" macro

        "' NISTdelta WARNING: NIST time set to MIN sec' . MIN .i nl"
        ".WARNING1" macro

        "' NISTdelta WARNING: NIST time set to MAX sec' . MAX .i nl"
        ".WARNING2" macro
      ]
      syspath "../usr/" + "NISTdelta" + ERRset \ 1
      _NISTdelta (sec)

    \ Weed out bad value:
      (sec) dup MIN MAX within
      IF dup "previous" book (sec) \ ok

      ELSE (sec) previous UDEF <>

         IF drop .WARNING previous \ out of range; use previous

         ELSE \ have no previous; use MAX or MIN:
            dup MAX > IF .WARNING2 drop MAX THEN
            dup MIN < IF .WARNING1 drop MIN THEN
         THEN (sec)

      THEN (sec)

      ERR \ end ERRset \ 1
   end

\  Setting verbose display in _NISTdelta:
   "_NISTdelta" exists?  IF yes "_NISTdelta" "VERBOSE" bank THEN

   "" "CLIENT_ALLOW" "clients" bank
   "" "SERVER_ALLOW" "clients" bank

   {"
      127.0.0.1     loopback
   "} chop (hT)
   (hT) dup +CLIENT_ALLOW +SERVER_ALLOW

\  Here is an example of fetching the dynamic IP address from a vendor
\  under DHCP DSL:

   host "plunger" = getlogin "dale" = and
   IF \ the author's machine and its DSL, replacing word IPlocal just
      \ created above when web.v was sourced:

   inline: IPlocal ( --- qS) \ this machine's IP address
{     For machine plunger, using Verizon DSL.

      Connect to the Verizon web interface on network 192.168.1.1 and
      get the web page that contains the dynamic IP address (running
      HTTPget in quotes using >stk puts the HTTPget text normally
      written to the display (describing the connection and speed)
      into VOL T on the stack, which is then dropped):
}     "192.168.1.1" (gateway)
      "/router_stat.htm" "HTTPget" >stk (hT) drop (hHTML)

{     Extract the IP address from the returned Verizon HTML (setting
      this up to use word between requires viewing the HTML in an 
      editor, like vi, to see what unique text surrounds the IP 
      address):
}     (hHTML) "Broadband IP Address:" "</TR>" between \ phrase with IP
      (hHTML) '">' '</TD>' between \ just the IP
      (hHTML) vol2str (qS) strchop (qS)
   end
   THEN

   host "crab" =
   IF
      define: anchove ( --- ) \ remote login to machine anchove
         "xtermsb" "XSET" yank \ save original

         TERM
         "-bg MidnightBlue -fg NavajoWhite -cr Salmon -fn 7x14 " cat
         "-display " "DISPLAY" env spaced cat cat
         "-sb -sl 1024 -geometry 72x32+1+1 -title " cat
         "xtermsb" "XSET" bank

         "rlogin anchove" xtermsb

         "xtermsb" "XSET" bank \ put original back
      end

    \ Allow these machines to connect to each other:
      depth push
         "clacker" IPhost
         "diego" IPhost
         "gutter"  IPhost
         "plunger" IPhost
         "rugger" IPhost
         "riggo" IPhost
      depth pull less pilen "SERVER_ALLOW" "clients" bank
   THEN

\-----------------------------------------------------------------------

\  Graphics

#def line_tests

 \ Struct of the columns of matrix Y used in line_tests():
   "Y" (qS)
    list: \ columns of matrix Y
       "S" "P1"
    end (qS qE) struct

   inline: line_tests (hWCB hGCB hY hX hL -- ) \ expose events for lines
{     Fri Jun 27 03:44:24 PDT 2014

      Use the graphics functions of plot.v to set up data and test C 
      functions that draw special lines.

      Incoming X and Y data has been scaled to fit the window that is
      handled by function pExpose() of plot.v, where this word's ptr 
      has been banked using the phrase:
         "line_tests" ptr "pExpose" "USERptr2" bank

      Why use a function like this one?  Why not just define WCB, GCB
      and some data to plot, then call a special line function directly?

      Thinking that just running a static word is a way to make a plot
      is the wrong way to view graphics.  Plotting is about event han-
      dlers in a constantly changing window environment, and it is more
      difficult than it appears to make the terms for calling a line 
      function directly to make a plot.

      The functions in plot.v do a lot, like handling expose events and
      clipping.  Being able to zoom into different regions of a graph 
      is an important part of debugging clipping behavior in any of the
      line functions.

      The approach here is relatively easy, and it involves a to call 
      high level word plot() and subsequent use of the banked ptr to
      this word, line_tests(), when pExpose() runs.

      To view the library of this word, run
         "line_tests" wholib

      This shows large arrays that can be freed to save memory.

------------------------------------------------------------------------

      This region is placed here for convenience.  It is run by word
      msource1() (see below) and could be anywhere, even in a separate
      file.

      This region sets up curves for testing and calls high level word
      plot().  That sets up expose event handling which will call this
      word, line_tests(), because its ptr is banked into the expose 
      event handler, pExpose() (see directly below, USERptr2).

      #def Test lines

       \ Bank ptr for line_tests(); pExpose() will call it:
         "pExpose" missing IF "plot.v" source THEN
         "line_tests" ptr "pExpose" "USERptr2" bank

       \ This sets wcb.typ to 1 in the WCB we'll be using from plot.v:
         1 plotWCB wcb.typ poke \ graph can use linet() for clipping

       \ Define line colors and styles:
         list:
            "DodgerBlue"  "LineSolid"     \ Line 1
            "ForestGreen" "LineStep"      \ Line 2
         end (hL) colorset (hLines hColors) graphset

       \ Define lines: a sine and a sine lagged by 60 degrees:
         "sine" missing IF "mmath.v" source THEN
         1 2 2pi *  0 0.01 100 sine (hY ht) "t" book (hY)
         1 2 2pi * 60 0.01 100 sine drop (hY hP1) park (hY)
{
         The ptr to line_tests() has been banked into pExpose() as 
         USERptr2, and this word, line_tests(), will be called when 
         word plot() runs in the following phrase.  

         Since USERptr2 is used instead of USERptr1, lines in Y will 
         have been drawn by the line function in pExpose() before word
         line_tests() runs.  In line_tests() additional lines are drawn
         by special line functions, based upon the data in Y for the 
         ones already drawn: 
}        (hY) t plot

      #end Test lines

      To run this test, paste the following four lines at the ready 
      prompt:
         syspath "../usr/uboot.v" +                   \
         "#def line_tests" "#end line_tests" msource1 \
         syspath "../usr/uboot.v" +                   \
         "#def Test lines" "#end Test lines" msource1

------------------------------------------------------------------------
}
      (hWCB hGCB hY hX hL) "L" book "X" book "Y" book

      (hWCB hGCB) "GCB" book "WCB" book

    \ Use incoming L or make clip vector L:
      L rows 0> not
      IF X 1st pry X dup rows ndx pry (x1 x2) Y pminmax (y1 y2)
         (x1 x2 y1 y2) 4 listn (hL) "L" book
      THEN

      WCB GCB GCcreate \ tie graphics context GCB to window WCB
 
    \ Incoming elements of Y, S and P1, have already been drawn since
    \ this word is USERptr2, and not USERptr1, in pExpose().  Extract
    \ S and P1 from Y for further use here:
      Y Y.S catch "S" book
      Y Y.P1 catch "P1" book

    \ Use linet1() to add add a new curve to the graph based upon P1:
      P1 5 (rows) lag "P2" book 
      WCB GCB "DodgerBlue4" colorpix hand P2 X L linet1 \ draw new P2

    \ Use linef() to highlight P1 when it is above or below S.
{
      Coming from pExpose(), S and P1 have been scaled to pixels in 
      window axes, where the vertical axis points down (following the
      convention of text flow from top to bottom).  This is opposite to
      graph axes when S and P1 were defined by sine() and the vertical
      axis pointed up.

      Thus less-than and greater-than used next will produce flags that
      are opposite to what would have been obtained by comparing the
      original sines:
}     S P1 < (f1)               \ lime green when S is less than P
      S P1 > (f2) park "f" book \ dumpster when S is greater than P
      [
      list:
         "#32CD32" colorpix \ lime green
         "#004F00" colorpix \ dumpster
      end "fcolors" book
      ]
      WCB GCB fcolors f P1 2 clone X L linef

    \ Use lineg() to draw grills between S and P1 and S and P2:
      S P1  < (g1)
      P2 P1 > (g2) park "g" book
      [
      list:
         "#FF6103" colorpix \ cadmium orange
         "red"     colorpix \ red
      end "gcolors" book
      ]
      WCB GCB gcolors g S P2 park P1 X L lineg

    \ Done.
      GCB GCfree

    \ Release memory:
      0 "L" book 0 "X" book 0 "Y" book
      0 "S" book 0 "P1" book 0 "P2" book
      0 "f" book 0 "g" book
   end

#end line_tests

#def pExposeUSER

   inline: pExposeUSER (hWCB hGCB hY hX hL -- ) \ expose event for a Mat
{     Fri May 24 09:07:05 PDT 2013
      User function for expose events on a Mat.  Set up data and call
      native C function linem() that draws a Mat.

      A mat:
         warp: threads running lengthwise;
         woof (weft): threads running crosswise.

      Draw a Mat, which is a series of horizontal lines pinned to curve
      Y(*,c) and running to the right for length DELTA.  

      For example, the kth horizontal line is defined by endpoints
         (X[k],Y[k, c]), (X[k]+DELTA,Y[k, c]).

      Incoming X and Y data has been scaled to fit the current graph 
      being drawn by function pExpose, where this word's ptr has been
      banked using the phrase:
         "pExposeUSER" ptr "pExpose" "USERptr1" bank

      DELTA is given as a number of rows (steps) of X.  Its actual 
      length will be determined in linem() using the step between the
      first two points in X.

      If DELTA and one-based index c are not greater than zero, this
      function is skipped.

      Example.

      Paste the following four lines at the ready prompt:
         syspath "../usr/uboot.v" +                     \
         "#def pExposeUSER" "#end pExposeUSER" msource1 \
         syspath "../usr/uboot.v" +                     \
         "#def Mat Example" "#end Mat Example" msource1 \

      #def Mat Example

       \ Load words:
         "pExpose" missing IF "plot.v" source THEN
         "looking2" missing IF "mat.v" source THEN

       \ Bank data for mat plotting:
         "pExposeUSER" ptr "pExpose" "USERptr1" bank \ pExpose will call

       \ This sets wcb.typ to 1 in the WCB we'll be using from plot.v:
         1 plotWCB wcb.typ poke \ graph will use linet() for clipping

       \ Define line colors and styles:
         list:
            "DodgerBlue"  "LineSolid"     \ Line 1
            "ForestGreen" "LineStep"      \ Line 2
         end (hL) colorset (hLines hColors) graphset

       \ Define lines: a sine and a sine lagged by 150 degrees:
         "sine" missing IF "mmath.v" source THEN
         1.0 2 2pi * 000 0.0025 400 sine (hS ht) drop \ Line 1, sine
         0.8 2 2pi * 150 0.0025 400 sine (hL ht)      \ Line 2, lagged

         (hS hL ht) "t" book (hS hL) park "S" book

         2 "pExposeUSER" "p" bank      \ pin the mat to Line 2
         50 "pExposeUSER" "DELTA" bank \ mat is 50 steps long

         "SaddleBrown" colorpix "pExposeUSER" "LineColor1" bank 
         "Red"         colorpix "pExposeUSER" "LineColor2" bank 

         S t plot

      #end Mat Example
}
      [ 0 "DELTA" book, 0 "p" book
        0 "LineColor1" book 0 "LineColor2" book 
      ]
      p 0> DELTA 0> and not IF 5 dump return THEN

    \ Fetch column p from Y (p is a 1-based index regardless of xbase):
      (hY hX hL) rot (hY) dup cols ndx p ndx min catch "Y" book

      (hWCB hGCB hX hL) "L" book "X" book 

      (hWCB hGCB) drop \ drop the incoming GCB and use the local one

    \ Get a graphics context for the GCB; the following sets gcc, the
    \ first element (as yet undefined):
      (hWCB) dup GCB GCcreate

    \ Use incoming L or make clip vector L:
      L rows 0> not
      IF X 1st pry X dup rows ndx pry (x1 x2) Y pminmax (y1 y2)
         (x1 x2 y1 y2) 4 listn (hL) "L" book
      THEN
 
    \ Example rule for vector V: Use LineColor2 when delta(Y) is not
    \ less than zero and LineColor1 otherwise.  
      LineColor1 LineColor2 pile "R" book

    \ V created below is a vector of numbers 1 and 2 (one-based indices)
    \ to use either LineColor1 or LineColor2:
      Y rows ones (hOne) dup 2 * (hTwo) Y delta 0< not (hOne hTwo hR)
      (hOne hTwo hR) looking2 (hV)

    \ Word ndx takes one-based indices and properly converts them to
    \ the current index base, so this works for 0based or 1based:
      (hV) ndx "V" book \ ndx sets V for current index base (0 or 1)
      
    \ Make vector of mat lengths, D (one row for each GCB column):
      DELTA DELTA 2 listn "D" book

      (hWCB) GCB R V Y X L D linem

      GCB GCfree 
   
    \ Release memory:
      0 "D" book 0 "L" book 0 "V" book 0 "X" book 0 "Y" book

    \ To view the library of this word, run
    \    "pExposeUSER" wholib
    \ This will show any large arrays that can be freed to save memory.

      [ GCBcreate makes GCB \ graphics context block for lines
        GAVcreate makes GAV \ graphics attrib vec for lines
      \ Setting default GC attributes in graphics attributes vector:
        0 (initial mask on stack) \ making mask:
           0 (nColor)   GAV gav.foreground poke GCForeground or
           2            GAV gav.linewidth poke GCLineWidth or
           LineSolid    GAV gav.linestyle poke GCLineStyle or
           1 (Bool yes) GAV gav.expose    poke GCGraphicsExposures or
           GXcopy       GAV gav.function  poke GCFunction or
        (mask) GCB gcb.gam poke \ mask bits number into GCB1.gam
        "GAV" ptr GCB gcb.gav poke \ gav ptr into GCB1.gav
      ]
   end

#end pExposeUSER

\-----------------------------------------------------------------------

 \ Miscellaneous

\  Setting display and options if on certain machines:

   host "sigma" alike
   host "clacker" alike or
   host "gutter" alike or
   IF getlogin "jdoe" alike \ is it me?
      IF
       \ Setting my display:
         "DISPLAY=140.125.68.46:0.0" setenv 

       \ Path for fbook files:
         "/scratch" "fbook" "path" bank 

       \ Additional files I want to source at start up when running
       \ on the hosts listed above:

         "nas.v" filefound IF source THEN \ words for Nastran

      THEN
   THEN

\  My words to allow file and path names without quotes:

   host "clacker" alike
   IF
      "'march.v'"  "march.v"  inlinex
      "'mfil.v'"   "mfil.v"   inlinex
      "'mday.v'"   "mday.v"   inlinex
      "'mini.v'"   "mini.v"   inlinex
      "'mweb.v'"   "mweb.v"   inlinex

      "'/home/dale/mdat/'" "mpath" inlinex
   THEN

\-----------------------------------------------------------------------
# keep begin (recommended at the bottom of a user's uboot.v file)

 \ This is a message written to the start up log file (argv -l):
   " info: sourcing " usrpath "uboot.v complete" + + . nl

   private halt \ this ends sourcing this file

# keep end
\-----------------------------------------------------------------------
