{  File tops_http.v
   February 2005

   Copyright (C) 2005-2014  Dale R. Williamson

   Words for daemon servers tops_http and tops_https.

   This file contains words and phrases sourced at start up by tops_http
   and tops_https.
}
\-----------------------------------------------------------------------

   CATMSG push no catmsg

\-----------------------------------------------------------------------

\  Words.

   inline: clientIP ( --- hT) \ clientIP from host
    \ Sat Mar  8 09:26:57 PST 2014
    \ This is requested by a machine wanting its IP address.

      remotefd clientindex (k) push

      clientIPs (hT) peek quote strchop (qIP) spaced 
      clientLOGINs (hT) pull quote strchop + spaced
      date + 
   end

   inline: HOSTcheck (qR nSocket --- qR) \ check HTTP response to host
{     Adds client host IP to usrpath/ACCESS.

      The ptr to this word may be in HTTPput() to run before sending
      R to the client.

    \ Mon Mar 17 17:20:53 PDT 2014
      WARNING: R will be chopped at the first null by strp() run below.
      Do not use this function for strings R, sent to trusted clients,
      that are allowed to contain nulls, such as encoded strings for
      special processing made in REQUESTrun() and sent by HTTPput().

      Checks HTTP response to client host for HTTP client error 4xx.

      If the server response to host is an acceptable client error 
      message, the IP address in usrpath/ACCESS will have * appended
      to it, indicating a "good" IP address.

      With * appended, good IP addresses will not be matched later when
      APP_CLIENT_ALLOW checks the list for connecting IP addresses to
      not to allow.

      See Appendix for the 4xx and 5xx client error messages, which are
      taken to be unacceptable errors.
}
      (nSocket) this clientindex -1 >
      IF (qR nSocket)
         clientIPs swap (S) clientindex quote strchop (qIP)

         (qR qIP) that (qR) uppercase "<TITLE>" "</TITLE>" between 
         noblanklines any?
         IF (qW) numerate any?
            IF ontop "N" book
               N 400 499 within
               N 500 599 within or
               IF " " ELSE "*" THEN
            ELSE "*"
            THEN
         ELSE "*"
         THEN (qIP qTAG) +
         (qR qIP) spaced date +

         "APP_CLIENT_ALLOW" "FILE" yank "FILE" book
         FILE file? IF FILE asciiload ELSE "" THEN (hT)

         (qR qIP hT) swap pile (hT1)
         (qR hT1) chop noblanklines neat (hT1) FILE save (qR)

      ELSE (qR nSocket) drop
      THEN (qR)

      (qR) "Port " "WPORT" main intstr + "Port 80" strp
      (qR) "PORTSSL" main (f) IF "Port 80" "Port 443" strp THEN 
      (qR)
   end
\  Bank the ptr to HOSTcheck into HTTPput for its RESPONSEcheck:
   "HOSTcheck" ptr "HTTPput" "RESPONSEcheck" bank

   inline: msgcomm_bad ( --- f) \ flag true if msgcomm has gone bad
{     Wed Feb 16 15:07:56 PST 2011.  Use msgPeek to read msgcomm
      to avoid read errors when other programs are writing to it.

      Fri Nov 26 09:33:58 PST 2010.  

      On fortycoupe.com, file msgcomm has been getting overwritten,
      causing collection from INO to be skipped because the message
      "skipINO no" is gone.

      The default has been changed to cause INO collection even if
      the message "skipINO no" is missing, but there is still the
      problem of learning how the file is getting overwritten.

      This word tests msgcomm for string "plunger" which must be
      present.
}
      "SERVER-CYCLE" SLEEP

      yes "msgPeek" "EOP" bank \ error output this call is on
      3 "msgPeek" "TRIES" bank \ attempts this call to peek at message
      "plunger" msgPeek chars any not
      IF " msgcomm_bad: keyword plunger not found" . nl true
      ELSE false
      THEN

      "SERVER-CYCLE" WAKE
   end

   inline: REQUESTcheck (qR nSocket --- qR1) \ check HTTP request
{     Sat Mar  8 10:36:42 PST 2014.  Update for clientIP.

      Requests will be sent to tops_wbsvr(WBSVR), which looks for
      files at this location (under root control): /var/www/.

      IMPORTANT: Put links at /var/www/ if files are elsewhere, such
      as at mpath used several places below.
 
      If invalid request, replace R with BAD_REQUEST that will send
      back robots.txt and cause future access to be denied (see file
      usrpath/ACCESS).
} 
      [ "CONNECT " "BAD_REQUEST" book, 256 "CHECK" book 

        "index.html SUMMARYR.TXT default.html" words mpath nose (hT)
        "REQUESTS" book
      ]
      drop "R" book

    \ Look at CHECK number of bytes in R.
    \ Word crowd removes commas and puts one space between strings.
      R 1st over chars CHECK min items catch crowd spaced "Rcheck" book 

      "REQUESTcheck " Rcheck 1st over chars 48 min items catch + ERRset

      0
      Rcheck "CONNECT"          grepr rows any or
      Rcheck "GET http://"      grepr rows any or
      Rcheck "GET https://"     grepr rows any or
      Rcheck "GET /default.ida" grepr rows any or
      Rcheck "SEARCH / "        grepr rows any or
      Rcheck "POST"             grepr rows any or
      Rcheck "HEAD"             grepr rows any or
      Rcheck "Authorization"    grepr rows any or
      Rcheck "Negotiate"        grepr rows any or

      IF BAD_REQUEST R + \ prepend a bad request to R so will bomb

      ELSE 
      {  Touch the file that is requested or Apache (if it is being
         used instead of tops_wbsvr) will be very slow in responding 
         (somehow due to requesting from local 127.0.0.1 and Apache 
         detecting that the file has not changed):
      }  Rcheck 2nd word 
         IF -path (hRfile) any?
            IF REQUESTS (hR) dup rot (hR hRfile) grepr any?
               IF (hR hRows) reach "touch " swap + shell
               ELSE (hR) drop
               THEN
            THEN
         THEN

         Rcheck "GET /status.html " grepr rows any
         IF 
          \ Make and then return file status.html (must have write
          \ permission where file is placed, and a link to it in 
          \ /var/www):
            status (hT) wrapHTML (hHTML) mpath "status.html" + save

         ELSE
            Rcheck "GET /clientIP.html " grepr rows any
            IF 
             \ Sat Mar  8 09:26:57 PST 2014.  Return my IP.  
             \ Make and then return file clientIP.html (must have 
             \ write permission where file is placed, and a link to 
             \ it in /var/www):
               clientIP (hT) wrapHTML (hHTML) mpath "clientIP.html" + 
               (hT qS) save 

{           ELSE Rcheck "GET / " grepr rows any
               IF R "GET /" "GET /default.html" strp "R" book 
               ELSE Rcheck "GET /robots.txt " grepr rows any
                  IF R "GET /robots.txt" "GET /default.html" strp 
                     "R" book 
                  THEN
               THEN }

            THEN
         THEN
         R 
      THEN (qR1)

      ERR
   end
\  Bank the ptr to REQUESTcheck into HTTPput for its REQUESTcheck:
   "REQUESTcheck" ptr "HTTPput" "REQUESTcheck" bank

   inline: status ( --- hHTML) \ status report from host
\     This is requested by a machine monitoring the status of a host,
\     as a basis for setting ALARMs.

      [ "HOME" env "WORK.LOG"    catpath "W" book
        "HOME" env "COLLECT.LOG" catpath "C" book

      {" (qFname --- hT)
        "fname" book fname -path 12 blpad spaced
        fname filetime ctime + " AGE: " + 
        time1 fname filetime - intstr + \ use sys time1, not prog time 
      "} "STATUS" macro

      ] 
      host " status on " + date + " TIME: " + time intstr +
      W STATUS pile
      C STATUS pile

    \ Debug for monitoring msgcomm problem on a particular machine:
      ontheweb 
      IF msgcomm_bad
         IF "MSGCOMM BAD " ELSE "MSGCOMM OK " THEN date + pile
      THEN
   end

   inline: WSERVER (qT nSocket --- qR) \ server on local machine
      "S" book textget asciify chop noblanklines "T" book

      " WSERVER: on " host + " received from socket " +
      S intstr + ":" + . nl
      T 3 indent . nl

    \ Send back a response:
      "402 Payment Required" wrapHTML
   end

\-----------------------------------------------------------------------

   pull catmsg private halt

\-----------------------------------------------------------------------

; Appendix

Here are 4xx and 5xx responses from HTTP RFC 2616:

  See: http://www.ietf.org/rfc/rfc2616.txt

   10.4  Client Error 4xx ............................................65
   10.4.1    400 Bad Request .........................................65
   10.4.2    401 Unauthorized ........................................66
   10.4.3    402 Payment Required ....................................66
   10.4.4    403 Forbidden ...........................................66
   10.4.5    404 Not Found ...........................................66
   10.4.6    405 Method Not Allowed ..................................66
   10.4.7    406 Not Acceptable ......................................67
   10.4.8    407 Proxy Authentication Required .......................67
   10.4.9    408 Request Timeout .....................................67
   10.4.10   409 Conflict ............................................67
   10.4.11   410 Gone ................................................68
   10.4.12   411 Length Required .....................................68
   10.4.13   412 Precondition Failed .................................68
   10.4.14   413 Request Entity Too Large ............................69
   10.4.15   414 Request-URI Too Long ................................69
   10.4.16   415 Unsupported Media Type ..............................69
   10.4.17   416 Requested Range Not Satisfiable .....................69
   10.4.18   417 Expectation Failed ..................................70
   10.5  Server Error 5xx ............................................70
   10.5.1   500 Internal Server Error ................................70
   10.5.2   501 Not Implemented ......................................70
   10.5.3   502 Bad Gateway ..........................................70
   10.5.4   503 Service Unavailable ..................................70
   10.5.5   504 Gateway Timeout ......................................71
   10.5.6   505 HTTP Version Not Supported ...........................71

This shows that an Apache server response contains Port 9880.  It is
part of the response to a "404 Not Found" client error:

  46  3C 41 44 44 52 45 53 53 3E 41 70 61 63 68 65 2F  <ADDRESS>Apache/
  48  31 2E 33 2E 32 36 20 53 65 72 76 65 72 20 61 74  1.3.26 Server at
  50  20 74 6F 70 73 64 6F 67 2E 63 6F 6D 20 50 6F 72   topsdog.com Por
  52  74 20 39 38 38 30 3C 2F 41 44 44 52 45 53 53 3E  t 9880</ADDRESS>
  54  0A 3C 2F 42 4F 44 59 3E 3C 2F 48 54 4D 4C 3E 0A  .</BODY></HTML>.

