{  File prxy.v  July 2012
   Client proxy server

   Copyright (c) 2012   D. R. Williamson

------------------------------------------------------------------------


   Fri Sep 21 15:31:11 PDT 2012.

   The purpose of the words in this file is to receive and transmit 
   bytes back and forth between a web browser and its site.

   The need for this capability never materialized, and the work in 
   this file has not been completed.

   Accommodations for both plain text and SSL connections are in the
   work so far.  But full operation with SSL will require changes in
   some program native C files.  See ideas below, notes Sat Jul 21 
   15:03:18 PDT 2012.

   Work more or less ended with word URI() to make a proper Request-
   URI.  See "U2 0 return" in URI(), and personal file notes about HTTP 
   Request-URI.

------------------------------------------------------------------------

   Using this file:

      In the server window, load server words and start the client
      proxy server:
         ready > "prxy.v" source
         ready > SW

      In the client window (only used when testing), send a request
      to the client proxy server:
         ready > "prxy.v" source
         ready > CW

------------------------------------------------------------------------

   Contents:

   Use this to obtain the following list of contents:
      usrpath "prxy.v" + asciiload this " inline:" grepr reach dot

   Words
   inline: CW ( --- ) \ load client words
   inline: SP ( --- nPort) \ server listening port
   inline: SW ( --- ) \ load server words

   Client Words

   Server Words
   inline: CLIENT_NEW (nS --- ) \ new client on S
   inline: HOST_CONNECT (hT nS --- ) \ connect client on S to host
   inline: ROUTER (hT nS --- ) \ route bytes between client and host
   inline: ROUTER_CLOSE (nS --- ) \ close Sx of pair (S, Sx)
   inline: RT ( --- hRT) \ router table of paired sockets
   inline: URI (hU --- 0 or hU1 qhostIP nhostPort -1) \ make Request-URI

   HTML messages

   Configuring the program as a client proxy server 

   Appendix
      Test run: client proxy server for client browser Google Chrome
      An example of a browser connecting to this program on port 80
      Problems during development
         Multiple connections
         SSL
}
\-----------------------------------------------------------------------
 
 \ Words

   inline: CW ( --- ) \ load client words
{     Wed Jul 18 17:25:54 PDT 2012.  Normally, the client is a foreign
      program (not this program).  

      Client words are used for testing, where this program acts like
      a foreign client and connects to the client proxy server using 
      CLIENT_F().
}     
      "prxy.v" "#def Client Words" msource
   end   

   inline: SP ( --- nPort) \ server listening port
    \ Wed Jul 18 17:52:27 PDT 2012
      [ 9877 "P" book ] P
   end

   inline: SW ( --- ) \ load server words
    \ Wed Jul 18 17:29:39 PDT 2012.  Load words used by this program's
    \ server acting as a proxy for its client.
 
      "prxy.v" "#def Server Words" msource
   end

   private halt

------------------------------------------------------------------------

#def Client Words

 \ Run these words in another window after Server Words have been 
 \ sourced and client proxy server is running.

 \ When CW is keyed in the client window, this will run the client
 \ proxy server listening on port 80:
   IPloop 80 CLIENT_F "S" book clients
   "GET http://mysite.com:9877/status.html" S remoteputf

 \ Here is a string to paste into a browser for a client proxy server
 \ on LAN 192.158.1.104 and listening on port 80:
 \    192.158.1.104/http://mysite.com/status.html

   private halt
#end

\-----------------------------------------------------------------------

#def Server Words

 \ Key SW to load server words and start the client proxy server.

   inline: CLIENT_NEW (nS --- ) \ new client on S
{     Thu Jul 19 06:49:14 PDT 2012.  Clientmake() has a new client on S.

      Zero the ROUTER.RTAB table (RT) entries for client S and host S1.

      The ptr to this word was given to SERVE_F.ADDptr() when the client
      proxy server was set up (see below).  Every time a new client con-
      nects, this word is contacted with the new socket number S.
}
    \ Sun Jul 22 10:54:12 PDT 2012.  The set_sysout() command saved a
    \ 63 page log file with ntrace output, showing a lot of issues to
    \ be handled before this proxy server works:  
    \    ntrace "/home/dale/prx.log" set_sysout
    \ View the log file on Windows machine solano:
    \    Libraries\Documents\My Documents\prx.docx

      (nS) "HOST_CONNECT" "VALID" localrun "S" book 

      RT S pry (nS1) dup 0>
      IF (nS1) 0 RT rot (0 RT nS1) poke \ RT(S1)=0
      ELSE (0) drop
      THEN

      0 RT S poke \ RT(S)=0
   end

   inline: HOST_CONNECT (hT nS --- ) \ connect client on S to host
{     Wed Jul 18 21:24:56 PDT 2012.  A client has just connected on S.

      Adapted from TELNETD_CONNECT() in term.v.

      This word assumes that incoming text T on socket S is for a host
      that is an HTTP server.

      Make a connection on socket S1 to the host given in T and run 
      ROUTER() to send bytes in T to the host.  

      This is the initial request from client on S.  Subsequent back-
      and-forth traffic between S and S1 will be handled entirely by
      ROUTER() until client or host closes its connection.

      Initial connection from client:

         client ----S---> HOST_CONNECT

      After connection to host, with ROUTER() in the middle:

         client <---S---> ROUTER <---S1---> host

      Example when host is an HTTP server:

         To use the client proxy server, this is how the command in a
         client browser might look:

            http://192.168.1.104:9877/http://host:port/dir1/.../file

         where http://192.168.1.104:9877 is the IP address and port of
         the client proxy server, in this case a machine on a LAN.  

         The client proxy server string is simply tacked on at the left
         of what would otherwise be run, http://host:port/.../file.

         With that command, the browser will connect to the client proxy
         server on 

            http://192.168.1.1:9877 

         and the browser request will be in T on the stack:

            T = GET /http://host:port/dir1/.../file+Req

         The host and port information that don't belong in T are re-
         moved by URI() and used to connect to the host.

         The set of bytes from URI() with host and port removed are in
         the form of a correct Request-URI, and are ready to send to 
         the host:

            T = GET /dir1/dir2/.../file+Req
}
      (nS) VALID "S" book (hT) dup "Torig" book
{
    \ The browser sends the /favicon.ico request on a socket different
    \ from the one that set up the proxy connection.  This causes an
    \ error because there is no host:port string on the left of the
    \ request.  Skip favicon.ico:
      (hT) dup "favicon.ico" grepr rows 0>
      IF (hT) drop 
         " HOST_CONNECT: ignoring favicon.ico on client socket" . 
         S .i nl S sclose return 
      THEN
}
      (hT) URI (0 or hT qIP nPort -1) 

      IF (hT qIP nPort) "hostPort" book "hostIP" book "T" book
       \ Connect to host:
         hostIP hostPort "ROUTER" ptr CONNECT_HOST (nS1)

         (nS1) this -1 =
         IF (-1) drop
            hostIP ":" + hostPort intstr + push 
            " HOST_CONNECT: cannot connect to host " peek + . nl
            "Cannot_Connect" main (hT) "XXXX" pull strp (hT)
            (hT) S remoteputf S sclose
         ELSE
            (nS1) VALID "S1" book

          \ Set up ROUTER table for S <----> S1:
            S RT (hRT) S1 poke \ RT(S1)=S
            S1 RT (hRT) S poke \ RT(S)=S1
            " HOST_CONNECT: client socket" . S .i 
            " and host socket" . S1 .i " are a route" . nl

          \ Ptr to word that clientclose() will run when S or S1 closes:
            "ROUTER_CLOSE" ptr (nptr) dup 
            S ptrCls_upd (nptr) S1 ptrCls_upd

          \ Send request T from S to host:
            " HOST_CONNECT: sending initial request to host: " . nl
            T textget 3 indent . nl
            T S ROUTER
         THEN

      ELSE " HOST_CONNECT: error in Request URI or Request Header:" . nl
         Torig textget 3 indent . nl

         "Invalid_Request" main (hT) "XXXX" 
         Torig strp (hT) S remoteputf S sclose
      THEN
      " HOST_CONNECT: end " . date . nl 

      [ {" (nSocket --- nSocket) \ returns if valid, HALTs if invalid
{
           Since socket numbers S and S1 are small integers (and not
           equal to zero due to other sockets already defined), let
           each socket number be the index in the RTAB array in ROUTER.

           This macro, VALID, checks these assumptions:
}      
           (nSocket) "ROUTER" "MAX_INDEX" yank
           that < that 0= or \ test for Socket>MAX_INDEX or Socket=0

           IF (nSocket) this sclose
              " HOST_CONNECT: socket number " swap intstr +
              " is invalid to use for an index" + ersys HALT
           THEN (nSocket)

        "} "VALID" macro
      ]
   end

   inline: ROUTER (hT nS --- ) \ route bytes between client and host
{     Wed Jul 18 18:24:14 PDT 2012.  This word sends all bytes that go
      from the client to the host and from the host to the client. 

      Adapted from ROUTER() in term.v.

      Bytes T from socket S are sent to the host when S is the client,
      and to the client when S is the host.

      The ptr to ROUTER() was given to SERVE_F.SERVICE() when the client
      proxy server was set up (see below), so SERVE_F() runs ROUTER()
      whenever bytes arrive on the server from a client.

      The ptr to ROUTER() was also given to CONNECT_HOST() when the host
      was connected in HOST_CONNECT(), so ROUTER() is also run whenever
      bytes arrive on the server from a host.

      This shows the flow of bytes through ROUTER():

        Client Machine | Client Proxy Machine       | Host Machine
                       |                            | 
         client program|<---S1---> ROUTER <---S2--->|host program 
}
      [ 100 "MAX_INDEX" book         \ max socket number S1 or S2
        MAX_INDEX 1 null "RTAB" book \ HOST_CONNECT() stores values
      ]
      (hT nS) RTAB over (RTAB nS) pry (nSx) any? (0 or nSx -1)
      IF (hT nS nSx) 

         NTRACE (f)
         IF " ROUTER: receive from socket" . over (nS) .i
            " send to socket" . dup (nSx) .i nl
         THEN

         (hT nS nSx) lop (hT nSx) remoteputf

      ELSE \ S has no host Sx in table; need to connect to host:
         (hT nS) HOST_CONNECT
      THEN
   end

   inline: ROUTER_CLOSE (nS --- ) \ close Sx of pair (S, Sx)
{     Thu Jul 19 06:11:12 PDT 2012.  Client on S has closed or host on 
      S has closed.  Close the other socket of ROUTER() pair (S, Sx).

      This word is run by clientclose() for socket S.

      The ptr to this word was given to clientclose() by HOST_CONNECT() 
      for both client socket S and host socket S1.
}
      RT (hRT) swap (nS) pry (nSx) dup sclose 
      (nSx) " ROUTER_CLOSE: closing socket" . .i nl
   end

   inline: RT ( --- hRT) \ router table of paired sockets
    \ Thu Jul 19 07:18:14 PDT 2012
      "ROUTER" "RTAB" yank (hRT)
   end

   inline: URI (hU --- 0 or hU1 qhostIP nhostPort -1) \ make Request-URI
{     Sat Jul 21 06:15:36 PDT 2012  

      Remove information from U used to reach the client proxy server 
      and properly format the Request-URI (Uniform Resource Identifier)
      with the path to the requested resource; and insert the host net-
      work location into the Request Host field.

      Returned U1 has a valid Request-URI and valid Request Host field.

      Returned hostIP and hostPort are required to connect to the host
      intended to receive U1.
 
      If success, a true flag follows U1, hostIP and hostPort on the
      stack.

      If error, only a false flag is returned on the stack.
}
      [  80 "hostPort_default" book
        443 "hostPort_SSL_default" book
        UDEF "SSL" book

        1st 8 items "1:8" book
        1st 9 items "1:9" book

        "/http://" "s8" book
        "/https://" "s9" book
      ]
      (hU) "U" book

      U 2nd string (0 or qU2 -1) 
      IF (qU2) dup "U2" book

       \ Determine connection type (encrypted or not) from the initial
       \ bytes of U2:
         (qU2) dup 1:8 catch s8 strmatch 0=
         IF (qU2) drop no
         ELSE (qU2) 1:9 catch s9 strmatch 0=
            IF yes
            ELSE UDEF \ no initial strings /http:// or /https:// found
            THEN
         THEN (n) "SSL" book

         SSL UDEF = 
         IF \ no /http:// string in U2 to define hostIP and hostPort
          \ U2 must already be a path and hostIP and hostPort must be
          \ given elsewhere.

          \ The following U2 valid path will make it to here even
          \ though it contains http (with :// encoded as %3A%2F%2F):
          \    /ads/iframe.php?url=http%3A%2F%2Fad...

U2 0 return 

         ELSE  
          \ Extract hostIP and hostPort from the left portion of U2 and
          \ make the right portion of U2 into a path:
            U2 "/" chblank 2nd string (0 or qS -1)
            IF 
             \ Fetch hostIP and hostPort:
               (qS) dup "H" book ":" chblank strings (hW) dup rows 2 =
               IF (hW) dup 2nd quote number (0 or N -1) 0=
                  IF -1 (N) THEN (N) 
               ELSE SSL 
                  IF hostPort_SSL_default 
                  ELSE hostPort_default
                  THEN (N)
               THEN (N) any? (0 or N -1)

               IF (qS N) "hostPort" book
                  (qS) 1st quote strchop "hostIP" book

                \ Fetch path and store it in U where U2 now is:
                  U2 H " " strp 2nd string (0 or qS -1) 0=
                  IF "/" THEN \ server root if no path specified 
                  (qPath) U U2 rot strp "U" book 

                  U "Host: " grepr rows 0> (f)

                  IF
                   \ Network location for this request must be in the
                   \ Host field.  Replace the Host field in U, incor-
                   \ rectly referring to this server, with the hostIP
                   \ server string.
                   \ Here's a ditty; can't get along without xray():
                     U dup (hU) "0D 0A" hexbytes smap (hM) dup
                        (hM hM) U "0D 0A" hexbytes "Host: " + smap @ (x)
                        (hM hM x) bsearch (r f) drop (hM r) 1+ pry (n)
                     (hU n) split (hA hB) push (hA)

                     (hA) dup "Host: " smap @ (hA n) split (hA hB) drop
                     (hA) "Host: " hostIP + + (hA)
                     (hA) pull (hA hB) + (hU1)

                     (hU1) hostIP hostPort

                  ELSE " URI: Host field is missing" . nl 0 return
                  THEN

               ELSE (qS) drop " URI: host port bad number" . nl 0 return
               THEN (hU1 qhostIP nhostPort)
            ELSE " URI: error 1" . nl 0 return
            THEN (hU1 qhostIP nhostPort)

         THEN

      ELSE " URI: no host found in URI" . nl 0 return
      THEN 
      (hU1 qhostIP nhostPort) true (-1)
   end

#end

\-----------------------------------------------------------------------

 \ HTML messages

   {" ( --- hT) \ Apache style HTML
      <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
      <HTML><HEAD>
      <TITLE>200 Error</TITLE>
      </HEAD><BODY>
      <H1>Cannot connect to host XXXX</H1>
      </BODY></HTML>
   "} left justify "Cannot_Connect" book

   {" ( --- hT) \ Apache style HTML
      <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
      <HTML><HEAD>
      <TITLE>200 Error</TITLE>
      </HEAD><BODY>
      <H1>Invalid Request-URI or Request Header Field: XXXX</H1>
      </BODY></HTML>
   "} left justify "Invalid_Request" book

\-----------------------------------------------------------------------

 \ Configuring the program as a client proxy server 

   "ROUTER" ptr     "SERVE_F" "SERVICE" bank (hT nSocket --- )
   "CLIENT_NEW" ptr "SERVE_F" "ADDptr"  bank (nSocket --- )
   1                "SERVE_F" "TYPE"    bank 

   30 new_client_timeout \ 30 seconds to send something after connect

 \ Start the server:
   getuid 0= 
   IF 
    \ Root listens on 443 for https:
      443 "SP" "P" bank 
      " prxy.v: secure server on port" . SP .i nl
      "" SP SERVER_SSL
   ELSE
      "" SP SERVER
   THEN

   private halt

------------------------------------------------------------------------

Appendix

Test run: client proxy server for client browser Google Chrome
Thu Jul 19 14:10:08 PDT 2012   

This is the browser command sent from client browser Google Chrome on a
Windows machine to the client proxy server listening on port 9877:

   http://192.168.1.104:9877/http://mysite.com/status.html

Two sockets, 6 and 7, connected simultaneously.  They are probably the
request for /status.html and the request for /favicon.ico.  The latter,
not part of the command shown above, has been observed on servers that
service browser requests and appears to be a frivolous item.

For this test, Google Chrome requested /favicon.ico but MS Internet
Explorer did not.

Socket 8 is the connection to the host opened by HOST_CONNECT(), pro-
bably for socket 6, the request for /status.html.  The page was cor-
rectly sent by the client proxy server and displayed in the browser.   

A report from clientclose() reports socket 8 closing, but there are no
similar reports for sockets 6 and 7.  Both 6 and 8 use ROUTER_CLOSE().

Add a message to ROUTER_CLOSE() when a socket closes. [Done]

Add a message to HOST_CONNECT() that gives the client and host socket
numbers that have been linked for ROUTER(). [Done]

Errors (see text from the server window shown below):

   Host in the text sent from HOST_CONNECT() is wrong since it refers 
   to the client proxy server and not the host further downstream:
      Host: 192.168.1.104:9877

   Word HOST_CONNECT() should change the host name in its string T to
   what it calls hostIP, which in this case is mysite.com:
      Host: mysite.com [Done]

   Request GET /favicon.ico HTTP/1.1 showed up from Google Chrome with-
   out the preceding http://192.168.1.104:9877/ so it caused HOST_CON-
   NECT() to come up with an empty hostIP.  Its "NO_HOST" error message
   sent back to the browser never showed up on the browser display of
   page status.html, but that message is sent to socket 7 instead of 
   socket 6.

   Ignore a /favicon.ico request and close the client socket. [Done]

Messages are shown every time the program runs; eventually they should
appear only when a trace is on, like wtrace (when less output appears)
or ntrace (when more output appears).

[dale@kaffia] /home/dale > tops
         Tops 3.2.0
Thu Jul 19 13:43:37 PDT 2012
[tops@kaffia] ready > "prxy.v" source
 word CW into catalog
 word SP into catalog
 word SW into catalog

[tops@kaffia] ready > SW
 word CLIENT_NEW into catalog
 word VALID,0:HOST_CONNECT into catalog
 word HOST_CONNECT into catalog
 word ROUTER into catalog
 word ROUTER_CLOSE into catalog
 word RT into catalog

[tops@kaffia] ready > 
Thu Jul 19 13:43:56 PDT 2012 SERVER: 192.168.1.101 connect
 857960 bytes delta: memprobe socket 6 connect

Thu Jul 19 13:43:56 PDT 2012 SERVER: 192.168.1.101 connect
 80 bytes delta: memprobe socket 7 connect
 HOST_CONNECT: sending request to host: 
   GET /status.html HTTP/1.1
   Host: 192.168.1.104:9877
   Connection: keep-alive
   Cache-Control: max-age=0
   User-Agent: Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/536.11
      (KHTML, like Gecko) Chrome/20.0.1132.57 Safari/536.11
   Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;
      q=0.8
   Accept-Encoding: gzip,deflate,sdch
   Accept-Language: en-US,en;q=0.8
   Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.3
   DNT: 1
   If-None-Match: W/"1459e-79a-845946ae"
   If-Modified-Since: Thu, 19 Jul 2012 20:42:28 GMT
 HOST_CONNECT: end Thu Jul 19 13:43:56 PDT 2012
 clientclose: socket 8 closing on flag 1, Thu Jul 19 13:43:56 PDT 2012
 clientclose: socket 8, port 80, conn C>F is closed
 HOST_CONNECT: empty hostIP or bad hostPort number for request string:
   GET /favicon.ico HTTP/1.1
   Host: 192.168.1.104:9877
   Connection: keep-alive
   Accept: */*
   User-Agent: Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/536.11
      (KHTML, like Gecko) Chrome/20.0.1132.57 Safari/536.11
   Accept-Encoding: gzip,deflate,sdch
   Accept-Language: en-US,en;q=0.8
   Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.3
   DNT: 1
 
 HOST_CONNECT: end Thu Jul 19 13:43:56 PDT 2012

[tops@kaffia] ready > clients
 Server local is listening on port 9877
 No clients

[tops@kaffia] ready > 

------------------------------------------------------------------------

An example of a browser connecting to this program on port 80
This was run before this file was written.

After starting the server below, run this netscape command:
   [dale@plunger] /home/dale > netscape http://127.0.0.1/index.html &

Root starting a server on port 80:

[root@plunger] /home/dale # tops
         Tops 3.2.0
Fri Jul 13 07:34:27 PDT 2012
[tops@plunger] ready # '' 80 SERVER

[tops@plunger] ready # clients
 Server local is listening on port 80
 No clients

[tops@plunger] ready # ntrace

[tops@plunger] ready #
Fri Jul 13 07:35:17 PDT 2012 SERVER: 127.0.0.1 connect
 850120 bytes delta: memprobe socket 6 connect
 SERVER: new client on socket 6 Fri Jul 13 07:35:17 PDT 2012
 drainf: socket 6 type -1 entering
       0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F  0123456789ABCDEF
   0  47 45 54 20 2F 69 6E 64 65 78 2E 68 74 6D 6C 20  GET /index.html
   2  48 54 54 50 2F 31 2E 31 0D 0A 48 6F 73 74 3A 20  HTTP/1.1..Host:
   4  31 32 37 2E 30 2E 30 2E 31 0D 0A 55 73 65 72 2D  127.0.0.1..User-
   6  41 67 65 6E 74 3A 20 4D 6F 7A 69 6C 6C 61 2F 35  Agent: Mozilla/5
   8  2E 30 20 28 58 31 31 3B 20 55 3B 20 4C 69 6E 75  .0 (X11; U; Linu
  10  78 20 69 36 38 36 3B 20 65 6E 2D 55 53 3B 20 72  x i686; en-US; r
  12  76 3A 31 2E 34 29 20 47 65 63 6B 6F 2F 32 30 30  v:1.4) Gecko/200
  14  33 30 36 32 34 20 4E 65 74 73 63 61 70 65 2F 37  30624 Netscape/7
  16  2E 31 0D 0A 41 63 63 65 70 74 3A 20 74 65 78 74  .1..Accept: text
  18  2F 78 6D 6C 2C 61 70 70 6C 69 63 61 74 69 6F 6E  /xml,application
  20  2F 78 6D 6C 2C 61 70 70 6C 69 63 61 74 69 6F 6E  /xml,application
  22  2F 78 68 74 6D 6C 2B 78 6D 6C 2C 74 65 78 74 2F  /xhtml+xml,text/
  24  68 74 6D 6C 3B 71 3D 30 2E 39 2C 74 65 78 74 2F  html;q=0.9,text/
  26  70 6C 61 69 6E 3B 71 3D 30 2E 38 2C 76 69 64 65  plain;q=0.8,vide
  28  6F 2F 78 2D 6D 6E 67 2C 69 6D 61 67 65 2F 70 6E  o/x-mng,image/pn
  30  67 2C 69 6D 61 67 65 2F 6A 70 65 67 2C 69 6D 61  g,image/jpeg,ima
  32  67 65 2F 67 69 66 3B 71 3D 30 2E 32 2C 2A 2F 2A  ge/gif;q=0.2,*/*
  34  3B 71 3D 30 2E 31 0D 0A 41 63 63 65 70 74 2D 4C  ;q=0.1..Accept-L
  36  61 6E 67 75 61 67 65 3A 20 65 6E 2D 75 73 2C 65  anguage: en-us,e
  38  6E 3B 71 3D 30 2E 35 0D 0A 41 63 63 65 70 74 2D  n;q=0.5..Accept-
  40  45 6E 63 6F 64 69 6E 67 3A 20 67 7A 69 70 2C 64  Encoding: gzip,d
  42  65 66 6C 61 74 65 0D 0A 41 63 63 65 70 74 2D 43  eflate..Accept-C
  44  68 61 72 73 65 74 3A 20 49 53 4F 2D 38 38 35 39  harset: ISO-8859
  46  2D 31 2C 75 74 66 2D 38 3B 71 3D 30 2E 37 2C 2A  -1,utf-8;q=0.7,*
  48  3B 71 3D 30 2E 37 0D 0A 4B 65 65 70 2D 41 6C 69  ;q=0.7..Keep-Ali
  50  76 65 3A 20 33 30 30 0D 0A 43 6F 6E 6E 65 63 74  ve: 300..Connect
  52  69 6F 6E 3A 20 6B 65 65 70 2D 61 6C 69 76 65 0D  ion: keep-alive.
  54  0A 0D 0A 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
 1342190136793877 microsec delta: end readn1
 drainf: 435 bytes from socket 6 type -1 ptrRun 0x0 0x0
 drainf: socket 6 set to type 3, FOREIGN
 drainf: server type is 0
 remoteputf: writing 2 bytes to socket 6
       0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F  0123456789ABCDEF
   0  0D 0A 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
 27115 microsec delta: end remoteputf
 clientclose: socket 6, port 41849, conn S<F is closed

------------------------------------------------------------------------

Problems during development

   Multiple connections
   Sat Jul 21 15:36:26 PDT 2012

   Once a connection to a host is made, more connections to other 
   places for the same host can pour in.
 
   For browser string: 

      http://192.168.1.104:9877/ \
         http://www.barchart.com/commodityfutures/All

   the connection is made, page received and browser updated and socket
   closed.  But many other connections are made from the same client, 
   (sometimes after a number of minutes) and of course they are all 
   missing the leftmost http://192.168.104:9877/ contained in the orig-
   inal request.

   In these other connections, however, the original connection string
   is in the Referer field, in this case given by

     Referer: http://192.168.1.104:9877/ \
        http://www.barchart.com/commodityfutures/All

  as shown in the xray below:

       0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F  0123456789ABCDEF
   0  47 45 54 20 2F 73 68 61 72 65 64 2F 69 6D 61 67  GET /shared/imag
   2  65 73 2F 6F 70 74 69 6F 6E 73 5F 69 63 6F 6E 2E  es/options_icon.
   4  67 69 66 20 48 54 54 50 2F 31 2E 31 0D 0A 48 6F  gif HTTP/1.1..Ho
   6  73 74 3A 20 31 39 32 2E 31 36 38 2E 31 2E 31 30  st: 192.168.1.10
   8  34 3A 39 38 37 37 0D 0A 43 6F 6E 6E 65 63 74 69  4:9877..Connecti
  10  6F 6E 3A 20 6B 65 65 70 2D 61 6C 69 76 65 0D 0A  on: keep-alive..
  12  55 73 65 72 2D 41 67 65 6E 74 3A 20 4D 6F 7A 69  User-Agent: Mozi
  14  6C 6C 61 2F 35 2E 30 20 28 57 69 6E 64 6F 77 73  lla/5.0 (Windows
  16  20 4E 54 20 36 2E 31 3B 20 57 4F 57 36 34 29 20   NT 6.1; WOW64)
  18  41 70 70 6C 65 57 65 62 4B 69 74 2F 35 33 36 2E  AppleWebKit/536.
  20  31 31 20 28 4B 48 54 4D 4C 2C 20 6C 69 6B 65 20  11 (KHTML, like
  22  47 65 63 6B 6F 29 20 43 68 72 6F 6D 65 2F 32 30  Gecko) Chrome/20
  24  2E 30 2E 31 31 33 32 2E 35 37 20 53 61 66 61 72  .0.1132.57 Safar
  26  69 2F 35 33 36 2E 31 31 0D 0A 41 63 63 65 70 74  i/536.11..Accept
  28  3A 20 2A 2F 2A 0D 0A 52 65 66 65 72 65 72 3A 20  : */*..Referer:
  30  68 74 74 70 3A 2F 2F 31 39 32 2E 31 36 38 2E 31  http://192.168.1
  32  2E 31 30 34 3A 39 38 37 37 2F 68 74 74 70 3A 2F  .104:9877/http:/
  34  2F 77 77 77 2E 62 61 72 63 68 61 72 74 2E 63 6F  /www.barchart.co
  36  6D 2F 63 6F 6D 6D 6F 64 69 74 79 66 75 74 75 72  m/commodityfutur
  38  65 73 2F 41 6C 6C 0D 0A 41 63 63 65 70 74 2D 45  es/All..Accept-E
  40  6E 63 6F 64 69 6E 67 3A 20 67 7A 69 70 2C 64 65  ncoding: gzip,de
  42  66 6C 61 74 65 2C 73 64 63 68 0D 0A 41 63 63 65  flate,sdch..Acce

   Thus URI() (or a word like it) has process text that contains the
   the same information but when it is in this form.

------------------------------------------------------------------------

   SSL
   Sat Jul 21 15:03:18 PDT 2012  

   When the client proxy server is an SSL server, TYPE 1 closes the
   socket after bytes arrive, but just the first byte (G) comes to
   the stack from drainf().  The rest of the request is still in the
   SSL buffer and does not come out before HOST_CONNECT() runs and
   fails.

   Changing TYPE to 0 (HTTP) causes drainf() to read all the SSL bytes.
   But TYPE should be 1 (TERM), not 0 (HTTP).

   So there are some problems to work out with SSL within the program 
   C code.

   A logical fix seems to be to make the program put all SSL buffer
   bytes on the stack, like drainf() does, before the socket is closed.

   Better yet: do not let drainf() return until all SSL buffer bytes
   are on the stack, like it does in its while loop (for TYPE HTTP?).

   There may be problems on the remote SSL server too, and working 
   that problem may require ntrace in the remote tops SSL server to
   see what is going on.

------------------------------------------------------------------------




