\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}}
}

{ File konet.v  January 2004

   Copyright (c) 2004   D. R. Williamson

   Unsupervised learning networks, after the work of T. Kohonen.

   These networks use a competitive learning algorithm.  The "learning"
   is primarily pattern classification.

   Reference:

      1. Hertz, J., A. Krogh and R. G. Palmer, "Introduction to the
         Theory of Neural Computation," Perseus Publishing, 1991.

   Training notes:

      Convergence is very slow if initial weight vectors are far from
      the training vectors they are supposed to eventually come close
      to.

      Reducing the learning rate for runners up, rather than using the
      same for all, speeds up convergence.  Word netTrain uses this
      strategy.

      Several training sessions using fewer and fewer runners up gives
      good performance, as in this example with word netTrain using the
      nearest 3, then 2, then 1 (where 1 means just the winner) with 
      smaller and smaller learning rates (.1, .01, .001):

      \ netTrain (qNet hA eta near steps --- ) \ train network on A

         NET PATTERNS .1   3 1000 netTrain
         NET PATTERNS .01  2 1000 netTrain
         NET PATTERNS .001 1 1000 netTrain

   Demo:

      "konet.v" "CLUSTER DEMO" msource halt
}
\-----------------------------------------------------------------------

   "plotWCB" missing IF "plot.v" source graphpair THEN
   "ranint" missing IF "math.v" source THEN

\-----------------------------------------------------------------------

   inline: netInit (qNet --- ) \ initialize network
      "Net" book
\     Make random N-by-M weights matrix, rows normalized to unity RSS:
      -1 1 
      Net "N" yank \ input units (rows in W)
      Net "M" yank \ output units (columns in W)
      (-1 1 N M) ranreal norm (hW) 
      Net "W" bank
   end

   inline: netMake (qNet M N --- ) \ creating network word Net
{     This word creates a network word for unsupervised competitive
      learning. 

      Quoted name Net will be the name of the network word; the network 
      will contain a single layer of M output units that each receive 
      N inputs.

      Network output is from the one unit producing the highest output 
      among all M units.  That output unit defines the classification 
      given to the input received by the network.  Its weight vector 
      provides the pattern that goes with the classification.

      Connection between all units in the layer is simulated by nearest
      neighbor updating during winner-take-all training.  Nearest means
      nearest output amplitude, not nearest physical location. 

      When the network word is fired, all it does is put its name on 
      the stack, to be used as a handle for other words that access its
      local library during initialization, training, and later use.
}
\     Making new word in main library with name given by string Net.  
      rot (qNet) "Net" book
      "[ defname 'Net' book ] Net" Net inlinex

\     Network word has been created.  The word's action will be to put 
\     its defname on the stack when it runs.  Bank N and M into its 
\     library:
      (N) Net "N" bank \ number of input units
      (M) Net "M" bank \ number of output units
   end

   inline: netOut (qNet hA --- hOut) \ network output for inputs A
{     For network word Net, row k of returned vector Out contains the 
      index of the network unit having weights that are closest to in-
      puts given in column k of A.  

      The pattern for network unit n is the nth column of weight matrix,
      W, in the library of word Net.  This phrase will fetch the weight
      vectors for the indices returned in Out: 
         (hOut qNet) "W" yank (hW) swap (hW hOut) catch (hWout)
}
      "A" book
      (qNet) "W" yank "W" book
      1st W cols items "INDX" book

      A cols 1st
      DO W A I catch those cols clone less mag (error) LOOP
      A cols parkn "Mag" book 

    \ Output is the index of the winning unit, the one with the 
    \ smallest mag error:
      list:
         Mag cols 1st
         DO INDX Mag I catch park yes 2nd sorton 1st pry LOOP
      end (hOut)
   end

   inline: netTrain (qNet hA eta near steps --- ) \ train network on A
{     Training a network by unsupervised competitive learning.

      Using weight update rule like (9.6) of Reference 1:

         Wnew = Wold + eta*(A - Wold)

      where Wnew is computed only for winner and nearby runners up.
      The winner is the weight vector that has the smallest error
      magnitude from the input vector A.
}
      (steps) "steps" book

\     Note: the value of near includes the winner; near=3 means the
\     winner plus two runners up.
      1st swap (near) items "near" book \ winner + neighbors to update

    \ Neighbors use learning rate eta diminished by factor 1/N, where 
    \ N=1 for the winner, N=2,3,... for runners up.
      (eta)
      near rows ones, one near rows items slash (Fac) \ 1, 1/2, 1/3, ...
      (eta Fac) star "eta" book

      (hA) "A" book 

      (qNet) "Net" book
      1st Net "M" yank (M units) items "INDX" book

      INDX rows, near rows < 
      IF " netTrain: number of nearby units exceeds network size"
         ersys return
      THEN

      Net "W" yank "W" book

    \ List of A columns, randomly chosen, to train upon:
      1st A cols ndx, steps one ranint "COLS" book

      steps 1st
      DO A COLS I pry catch "Ai" book \ vector A randomly fetched

       \ Finding W vectors closest to input A (Ref 1, (9.3)):
         W Ai those cols clone less (W - A) mag (hErr)
         (hErr) INDX park yes sort \ smallest mag error in first row

       \ Updating weight vectors of winner and near winners:
         2nd catch (INDX) near reach (Cols) \ list of W cols to update
         (Cols) dup push rows 1st 
         DO W peek (Cols) I pry catch (W) 
            (W) Ai that less (A - W) 
            eta I pry star (dW) plus (W1) \ W1 = W + eta*(A - W)
         LOOP peek rows parkn (W1)        \ updated W1 cols parked
         (W1) pull (Cols) W cram          \ W1 into W at Cols
      LOOP
   end

   private halt 

\-----------------------------------------------------------------------
{
   CLUSTER DEMO

   time seedset
   "netTrain" missing IF "konet.v" source THEN

   depth push

\  100 points clustered at 10,2:
   -1 1 100 1 ranreal 10 plus \ X
   -1 1 100 1 ranreal  2 plus \ Y
   park bend 

\  200 points clustered at 10,10:
   -1 1 200 1 ranreal 10 plus \ X
   -1 1 200 1 ranreal 10 plus \ Y
   park bend 

\  400 points clustered at 2,10:
   -1 1 400 1 ranreal  2 plus \ X
   -1 1 400 1 ranreal 10 plus \ Y
   park bend 

   depth pull less parkn "A" book

\  Showing clusters of inputs:
      " Cluster densities, clockwise, should appear in proportion "
      "400:200:100." cat nl . nl
      A bend this 2nd catch swap 1st catch plot
      pause

\  Making network word CNET:
      "CNET" 70 (units M) 2 (inputs N) netMake 
      CNET netInit

\  Randomly choosing M vectors from A to be initial weight vectors:
      A 1st those cols ndx (n1 n2) 
      CNET "M" yank one (M 1) ranint (hRake)
      (hA hRake) catch (hW) CNET "W" bank

\  Training the network:
      " Training " . CNET . "..." .
      2 is Nfac
      CNET A   .1 3 1000 Nfac * netTrain
      CNET A  .01 2 1000 Nfac * netTrain
      CNET A .001 1 1000 Nfac * netTrain
      " done" . nl

\  Showing clusters of CNET weights:
      " CNET weights, clockwise, should appear in proportion "
      "40:20:10." cat nl . nl
      CNET "W" yank bend 
      this 2nd catch that 1st catch atan2 park (hW) yes 3rd sorton

      this 2nd catch swap 1st catch plot
      pause plotclose

\  Showing the library of network word CNET:
      " Showing the library of network word CNET: " nl . nl
      CNET wholib

   halt
}

   private halt

\-----------------------------------------------------------------------

;  Appendix

   Early versions of some words.  Weight vectors were stored by rows
   in W.  Now they are stored by columns, the same as input vectors.

  _inline: netOut (qNet hA --- hOut) \ network output for inputs A
\     Matrix Out contains two columns and one row for each column in A.
\     Column 1 of row k gives index of the winning unit for input k,
\     and column 2 gives its output level.
      swap "W" yank
      1st those (W) rows items "ROWS" book
      swap star (W*A) "Out" book Out cols 1st
      DO Out I catch dup abs ROWS park no sort
         1st 2nd fetch swap that pry park
      LOOP
      Out cols pilen
   end

  _inline: netTrain (qNet hA eta near steps --- ) \ train network
\     Using update rule like (9.6) of Reference 1.
      "steps" book
      1st swap items "near" book \ neighbors to update
      "eta" book
      "A" book 
      A bend "A'" book \ transpose of A when updating rows of W

      "Net" book
      1st Net "M" yank (M units) items "ROWS" book

      ROWS rows near rows < 
      IF " netTrain: number of nearby units exceeds network size"
         ersys return
      THEN

      Net "W" yank "W" book

      steps 1st
      DO 
       \ Finding closest weight vectors to inputs A (Ref 1, (9.3)):
         A' rows 1st 
         DO W A' I reach those rows repeat less bend mag LOOP
         A' rows parkn "Out" book 

       \ Updating weight vectors of winner and near winners:
         Out cols 1st
         DO Out I catch abs ROWS park yes sort 
            2nd catch near reach (Rows) \ list of W rows to update
            dup push rows 1st 
            DO W peek I pry reach (W) 
               A' peek I pry reach (A)
               that less (A - W) 
             \ The next two lines line do (9.7) of Ref 1:
             \ Out J catch peek I pry 
             \ reach ontop star        \ Out*(A - W)
               eta star (dW) plus (W1) \ W1 = W + eta*(A - W)
            LOOP peek rows pilen (W1)  \ W1 piled
            (W1) pull (Rows) W ram     \ W1 into W at Rows
         LOOP
      LOOP
   end

  _inline: netTrain (qNet hA eta near steps --- ) \ train network
\     Using update rule like (9.6) of Reference 1.
      "steps" book
      1st swap items "near" book \ neighbors to update
      "eta" book
      "A" book 
      A bend "A'" book \ transpose of A when updating rows of W

      "Net" book
      1st Net "M" yank (M units) items "ROWS" book

      ROWS rows near rows < 
      IF " netTrain: number of nearby units exceeds network size"
         ersys return
      THEN

      steps 1st
      DO Net "W" yank "W" book
         W A star "Out" book Out cols 1st
         DO Out I catch abs ROWS park no sort 
            2nd catch near reach (Rows) \ list of W rows to update
            dup push rows 1st 
            DO W peek I pry reach (W) 
               A' peek I pry reach (A)
               that less (A - W) 
             \ The next two lines line do (9.7) of Ref 1:
             \ Out J catch peek I pry 
             \ reach ontop star        \ Out*(A - W)
               eta star (dW) plus (W1) \ W1 = W + eta*(A - W)
            LOOP peek rows pilen (W1)  \ W1 piled
            (W1) pull (Rows) W ram     \ W1 into W at Rows
         LOOP
         W bend norm bend Net "W" bank
      LOOP
   end

