% saveop4(filename, digits, a, b, c, ...)
%
% Write matlab matrices to a Nastran .op4 file.  All .op4 file types,
% storage schemes, and matrix types are supported.  Sparse matlab matrices 
% are saved as sparse .op4 matrices using the BIGMAT=TRUE scheme.  Binary
% matrices are always written in double precision.
%
% Input:
%     filename    The name of the .op4 file to write to.  If the file
%                 exists it will be overwritten.
%     digits      digits =  0 creates a binary file
%                 digits = -1 creates a binary file with bytes swapped in an
%                             endian sense opposite that of this machine
%                 digits >  0 creates a text file whose matrices are written 
%                 with a field width of digits+7 characters (corresponds to 
%                 the Nastran OUTPUT4 option of the same name).
%     a,b,c,...   The matlab matrices to be written to the .op4 file.
%
% See also:       loadop4
